package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImTableFlags {
  int None = 0;
  /**Enable+resizing+columns.*/
  int Resizable = 1 << 0;
  /**Enable+reordering+columns+in+header+row+%28need+calling+TableSetupColumn%28%29+%2B+TableHeadersRow%28%29+to+display+headers%29*/
  int Reorderable = 1 << 1;
  /**Enable+hiding%7Cdisabling+columns+in+context+menu.*/
  int Hideable = 1 << 2;
  /**Enable+sorting.+Call+TableGetSortSpecs%28%29+to+obtain+sort+specs.+Also+see+ImGuiTableFlags_SortMulti+and+ImGuiTableFlags_SortTristate.*/
  int Sortable = 1 << 3;
  /**Disable+persisting+columns+order%2C+width+and+sort+settings+in+the+.ini+file.*/
  int NoSavedSettings = 1 << 4;
  /**Right-click+on+columns+body%7Ccontents+will+display+table+context+menu.+By+default+it+is+available+in+TableHeadersRow%28%29.*/
  int ContextMenuInBody = 1 << 5;
  /**Set+each+RowBg+color+with+ImGuiCol_TableRowBg+or+ImGuiCol_TableRowBgAlt+%28equivalent+of+calling+TableSetBgColor+with+ImGuiTableBgFlags_RowBg0+on+each+row+manually%29*/
  int RowBg = 1 << 6;
  /**Draw+horizontal+borders+between+rows.*/
  int BordersInnerH = 1 << 7;
  /**Draw+horizontal+borders+at+the+top+and+bottom.*/
  int BordersOuterH = 1 << 8;
  /**Draw+vertical+borders+between+columns.*/
  int BordersInnerV = 1 << 9;
  /**Draw+vertical+borders+on+the+left+and+right+sides.*/
  int BordersOuterV = 1 << 10;
  /**Draw+horizontal+borders.*/
  int BordersH = BordersInnerH | BordersOuterH;
  /**Draw+vertical+borders.*/
  int BordersV = BordersInnerV | BordersOuterV;
  /**Draw+inner+borders.*/
  int BordersInner = BordersInnerV | BordersInnerH;
  /**Draw+outer+borders.*/
  int BordersOuter = BordersOuterV | BordersOuterH;
  /**Draw+all+borders.*/
  int Borders = BordersInner | BordersOuter;
  /**%5BALPHA%5D+Disable+vertical+borders+in+columns+Body+%28borders+will+always+appears+in+Headers%29.+-%3E+May+move+to+style*/
  int NoBordersInBody = 1 << 11;
  /**%5BALPHA%5D+Disable+vertical+borders+in+columns+Body+until+hovered+for+resize+%28borders+will+always+appears+in+Headers%29.+-%3E+May+move+to+style*/
  int NoBordersInBodyUntilResize = 1 << 12;
  /**Columns+default+to+_WidthFixed+or+_WidthAuto+%28if+resizable+or+not+resizable%29%2C+matching+contents+width.*/
  int SizingFixedFit = 1 << 13;
  /**Columns+default+to+_WidthFixed+or+_WidthAuto+%28if+resizable+or+not+resizable%29%2C+matching+the+maximum+contents+width+of+all+columns.+Implicitly+enable+ImGuiTableFlags_NoKeepColumnsVisible.*/
  int SizingFixedSame = 2 << 13;
  /**Columns+default+to+_WidthStretch+with+default+weights+proportional+to+each+columns+contents+widths.*/
  int SizingStretchProp = 3 << 13;
  /**Columns+default+to+_WidthStretch+with+default+weights+all+equal%2C+unless+overridden+by+TableSetupColumn%28%29.*/
  int SizingStretchSame = 4 << 13;
  /**Make+outer+width+auto-fit+to+columns%2C+overriding+outer_size.x+value.+Only+available+when+ScrollX%7CScrollY+are+disabled+and+Stretch+columns+are+not+used.*/
  int NoHostExtendX = 1 << 16;
  /**Make+outer+height+stop+exactly+at+outer_size.y+%28prevent+auto-extending+table+past+the+limit%29.+Only+available+when+ScrollX%7CScrollY+are+disabled.+Data+below+the+limit+will+be+clipped+and+not+visible.*/
  int NoHostExtendY = 1 << 17;
  /**Disable+keeping+column+always+minimally+visible+when+ScrollX+is+off+and+table+gets+too+small.+Not+recommended+if+columns+are+resizable.*/
  int NoKeepColumnsVisible = 1 << 18;
  /**Disable+distributing+remainder+width+to+stretched+columns+%28width+allocation+on+a+100-wide+table+with+3+columns%3A+Without+this+flag%3A+33%2C33%2C34.+With+this+flag%3A+33%2C33%2C33%29.+With+larger+number+of+columns%2C+resizing+will+appear+to+be+less+smooth.*/
  int PreciseWidths = 1 << 19;
  /**Disable+clipping+rectangle+for+every+individual+columns+%28reduce+draw+command+count%2C+items+will+be+able+to+overflow+into+other+columns%29.+Generally+incompatible+with+TableSetupScrollFreeze%28%29.*/
  int NoClip = 1 << 20;
  /**Default+if+BordersOuterV+is+on.+Enable+outer-most+padding.+Generally+desirable+if+you+have+headers.*/
  int PadOuterX = 1 << 21;
  /**Default+if+BordersOuterV+is+off.+Disable+outer-most+padding.*/
  int NoPadOuterX = 1 << 22;
  /**Disable+inner+padding+between+columns+%28double+inner+padding+if+BordersOuterV+is+on%2C+single+inner+padding+if+BordersOuterV+is+off%29.*/
  int NoPadInnerX = 1 << 23;
  /**Enable+horizontal+scrolling.+Require+%27outer_size%27+parameter+of+BeginTable%28%29+to+specify+the+container+size.+Changes+default+sizing+policy.+Because+this+create+a+child+window%2C+ScrollY+is+currently+generally+recommended+when+using+ScrollX.*/
  int ScrollX = 1 << 24;
  /**Enable+vertical+scrolling.+Require+%27outer_size%27+parameter+of+BeginTable%28%29+to+specify+the+container+size.*/
  int ScrollY = 1 << 25;
  /**Hold+shift+when+clicking+headers+to+sort+on+multiple+column.+TableGetSortSpecs%28%29+may+return+specs+where+%28SpecsCount+%3E+1%29.*/
  int SortMulti = 1 << 26;
  /**Allow+no+sorting%2C+disable+default+sorting.+TableGetSortSpecs%28%29+may+return+specs+where+%28SpecsCount+%3D%3D+0%29.*/
  int SortTristate = 1 << 27;
  int SizingMask = SizingFixedFit | SizingFixedSame | SizingStretchProp | SizingStretchSame;
  enum Type implements Flag {
    None(JImTableFlags.None),
    Resizable(JImTableFlags.Resizable),
    Reorderable(JImTableFlags.Reorderable),
    Hideable(JImTableFlags.Hideable),
    Sortable(JImTableFlags.Sortable),
    NoSavedSettings(JImTableFlags.NoSavedSettings),
    ContextMenuInBody(JImTableFlags.ContextMenuInBody),
    RowBg(JImTableFlags.RowBg),
    BordersInnerH(JImTableFlags.BordersInnerH),
    BordersOuterH(JImTableFlags.BordersOuterH),
    BordersInnerV(JImTableFlags.BordersInnerV),
    BordersOuterV(JImTableFlags.BordersOuterV),
    BordersH(JImTableFlags.BordersH),
    BordersV(JImTableFlags.BordersV),
    BordersInner(JImTableFlags.BordersInner),
    BordersOuter(JImTableFlags.BordersOuter),
    Borders(JImTableFlags.Borders),
    NoBordersInBody(JImTableFlags.NoBordersInBody),
    NoBordersInBodyUntilResize(JImTableFlags.NoBordersInBodyUntilResize),
    SizingFixedFit(JImTableFlags.SizingFixedFit),
    SizingFixedSame(JImTableFlags.SizingFixedSame),
    SizingStretchProp(JImTableFlags.SizingStretchProp),
    SizingStretchSame(JImTableFlags.SizingStretchSame),
    NoHostExtendX(JImTableFlags.NoHostExtendX),
    NoHostExtendY(JImTableFlags.NoHostExtendY),
    NoKeepColumnsVisible(JImTableFlags.NoKeepColumnsVisible),
    PreciseWidths(JImTableFlags.PreciseWidths),
    NoClip(JImTableFlags.NoClip),
    PadOuterX(JImTableFlags.PadOuterX),
    NoPadOuterX(JImTableFlags.NoPadOuterX),
    NoPadInnerX(JImTableFlags.NoPadInnerX),
    ScrollX(JImTableFlags.ScrollX),
    ScrollY(JImTableFlags.ScrollY),
    SortMulti(JImTableFlags.SortMulti),
    SortTristate(JImTableFlags.SortTristate),
    SizingMask(JImTableFlags.SizingMask),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
