/*
 * Decompiled with CFR 0.152.
 */
package org.ice1000.jimgui;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ice1000.jimgui.util.JImGuiUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JImTextureID {
    long nativeObjectPtr;
    public final int width;
    public final int height;

    private JImTextureID(long nativeObjectPtr, int width, int height) {
        this.width = width;
        this.height = height;
        this.nativeObjectPtr = nativeObjectPtr;
    }

    @NotNull
    public static JImTextureID fromFile(@NotNull String fileName) {
        return JImTextureID.createJImTextureID("cannot load " + fileName, JImTextureID.createTextureFromFile(JImGuiUtil.getBytes(fileName)));
    }

    @Contract(value="_, null -> fail")
    @NotNull
    private static JImTextureID createJImTextureID(@NotNull String errorMessage, long @Nullable [] extractedData) {
        if (extractedData == null || extractedData.length != 3 || extractedData[0] == 0L) {
            throw new IllegalStateException(errorMessage);
        }
        return new JImTextureID(extractedData[0], (int)extractedData[1], (int)extractedData[2]);
    }

    @NotNull
    public static JImTextureID fromUri(@NotNull URI uri) {
        return JImTextureID.fromPath(Paths.get(uri));
    }

    @NotNull
    public static JImTextureID fromFile(@NotNull File file) {
        return JImTextureID.fromFile(file.getAbsolutePath());
    }

    @NotNull
    public static JImTextureID fromPath(@NotNull Path path) {
        return JImTextureID.fromFile(path.toString());
    }

    @NotNull
    public static JImTextureID fromBytes(byte @NotNull [] rawData) {
        long[] texture = JImTextureID.createTextureFromBytes(rawData, rawData.length);
        return JImTextureID.createJImTextureID("Failed to create texture!", texture);
    }

    @NotNull
    public static JImTextureID fromExistingID(long nativeObjectPtr, int width, int height) {
        return new JImTextureID(nativeObjectPtr, width, height);
    }

    private static native long[] createTextureFromFile(byte @NotNull [] var0);

    private static native long[] createTextureFromBytes(byte @NotNull [] var0, int var1);
}

