/*
 * Decompiled with CFR 0.152.
 */
package org.ice1000.jimgui;

import org.ice1000.jimgui.cpp.DeallocatableObject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NativeFloat
extends Number
implements DeallocatableObject,
Cloneable {
    long nativeObjectPtr;

    @Contract
    public NativeFloat() {
        this.nativeObjectPtr = NativeFloat.allocateNativeObject();
    }

    @Contract(pure=true)
    public NativeFloat(long nativeObjectPtr) {
        this.nativeObjectPtr = nativeObjectPtr;
    }

    @Override
    @Contract
    public void deallocateNativeObject() {
        NativeFloat.deallocateNativeObject0(this.nativeObjectPtr);
        this.nativeObjectPtr = 0L;
    }

    @Contract(pure=true)
    public float accessValue() {
        return NativeFloat.accessValue(this.nativeObjectPtr);
    }

    @Contract
    public void increaseValue(float increment) {
        NativeFloat.increaseValue(this.nativeObjectPtr, increment);
    }

    @Contract
    public void modifyValue(float newValue) {
        NativeFloat.modifyValue(this.nativeObjectPtr, newValue);
    }

    @Override
    @Contract(pure=true)
    public int intValue() {
        return (int)this.accessValue();
    }

    @Override
    @Contract(pure=true)
    public long longValue() {
        return (long)this.accessValue();
    }

    @Override
    @Contract(pure=true)
    public float floatValue() {
        return this.accessValue();
    }

    @Override
    @Contract(pure=true)
    public double doubleValue() {
        return this.accessValue();
    }

    private static native float accessValue(long var0);

    private static native void modifyValue(long var0, float var2);

    private static native void increaseValue(long var0, float var2);

    private static native long allocateNativeObject();

    private static native void deallocateNativeObject0(long var0);

    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        return this == o || o instanceof NativeFloat && this.nativeObjectPtr == ((NativeFloat)o).nativeObjectPtr;
    }

    @Contract(pure=true)
    public int hashCode() {
        return Long.hashCode(this.nativeObjectPtr);
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.accessValue());
    }

    @Contract
    @NotNull
    public NativeFloat clone() {
        NativeFloat newInstance = new NativeFloat();
        newInstance.modifyValue(this.accessValue());
        return newInstance;
    }
}

