/*
 * Decompiled with CFR 0.152.
 */
package org.ice1000.jimgui;

import org.ice1000.jimgui.cpp.DeallocatableObject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NativeLong
extends Number
implements DeallocatableObject,
Cloneable {
    long nativeObjectPtr;

    @Contract
    public NativeLong() {
        this.nativeObjectPtr = NativeLong.allocateNativeObject();
    }

    @Contract(pure=true)
    public NativeLong(long nativeObjectPtr) {
        this.nativeObjectPtr = nativeObjectPtr;
    }

    @Override
    @Contract
    public void deallocateNativeObject() {
        NativeLong.deallocateNativeObject0(this.nativeObjectPtr);
        this.nativeObjectPtr = 0L;
    }

    @Contract(pure=true)
    public long accessValue() {
        return NativeLong.accessValue(this.nativeObjectPtr);
    }

    @Contract
    public void increaseValue(long increment) {
        NativeLong.increaseValue(this.nativeObjectPtr, increment);
    }

    @Contract
    public void modifyValue(long newValue) {
        NativeLong.modifyValue(this.nativeObjectPtr, newValue);
    }

    @Override
    @Contract(pure=true)
    public int intValue() {
        return (int)this.accessValue();
    }

    @Override
    @Contract(pure=true)
    public long longValue() {
        return this.accessValue();
    }

    @Override
    @Contract(pure=true)
    public float floatValue() {
        return this.accessValue();
    }

    @Override
    @Contract(pure=true)
    public double doubleValue() {
        return this.accessValue();
    }

    private static native long accessValue(long var0);

    private static native void modifyValue(long var0, long var2);

    private static native void increaseValue(long var0, long var2);

    private static native long allocateNativeObject();

    private static native void deallocateNativeObject0(long var0);

    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        return this == o || o instanceof NativeLong && this.nativeObjectPtr == ((NativeLong)o).nativeObjectPtr;
    }

    @Contract(pure=true)
    public int hashCode() {
        return Long.hashCode(this.nativeObjectPtr);
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.accessValue());
    }

    @Contract
    @NotNull
    public NativeLong clone() {
        NativeLong newInstance = new NativeLong();
        newInstance.modifyValue(this.accessValue());
        return newInstance;
    }
}

