/*
 * Decompiled with CFR 0.152.
 */
package org.ice1000.jimgui;

import java.nio.charset.StandardCharsets;
import org.ice1000.jimgui.NativeBool;
import org.ice1000.jimgui.cpp.DeallocatableObject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NativeString
implements CharSequence,
DeallocatableObject {
    long nativeObjectPtr;

    @Contract
    public NativeString() {
        this(16);
    }

    @Contract
    public NativeString(int initialCapacity) {
        this(NativeString.allocateNativeObject(initialCapacity));
    }

    public boolean isNull() {
        return this.nativeObjectPtr == 0L;
    }

    @Contract(pure=true)
    protected NativeString(long nativeObjectPtr) {
        this.nativeObjectPtr = nativeObjectPtr;
    }

    @Override
    @Contract
    public void deallocateNativeObject() {
        NativeString.deallocateNativeObject0(this.nativeObjectPtr);
        this.nativeObjectPtr = 0L;
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        return this == o || o instanceof NativeBool && this.nativeObjectPtr == ((NativeBool)o).nativeObjectPtr;
    }

    @Contract(pure=true)
    public int hashCode() {
        return Long.hashCode(this.nativeObjectPtr);
    }

    @Override
    @Contract(pure=true)
    public int length() {
        return NativeString.length(this.nativeObjectPtr);
    }

    @Contract
    public void clear() {
        NativeString.clear(this.nativeObjectPtr);
    }

    @Contract
    public void append(byte chr) {
        NativeString.appendChar(this.nativeObjectPtr, chr);
    }

    @Contract
    public void append(char chr) {
        this.append((byte)chr);
    }

    @Override
    @Contract(pure=true)
    public char charAt(int position) {
        return (char)NativeString.byteAt(this.nativeObjectPtr, position);
    }

    @Contract
    public void setByteAt(int position, byte newValue) {
        NativeString.setByteAt(this.nativeObjectPtr, position, newValue);
    }

    @Contract
    public void setCharAt(int position, char newValue) {
        this.setByteAt(position, (byte)newValue);
    }

    @Override
    @NotNull
    public NativeString subSequence(int start, int end) {
        return new NativeString(NativeString.substring(this.nativeObjectPtr, start, end));
    }

    @Contract(pure=true)
    public byte byteAt(int position) {
        return NativeString.byteAt(this.nativeObjectPtr, position);
    }

    public byte @NotNull [] toBytes() {
        byte[] values = new byte[this.length()];
        NativeString.readValues(this.nativeObjectPtr, values);
        return values;
    }

    @Override
    @NotNull
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static NativeString fromRaw(long constCharPtr) {
        return new NativeString(NativeString.allocateNativeObjectFromRaw(constCharPtr));
    }

    private static native long allocateNativeObject(int var0);

    private static native long allocateNativeObjectFromRaw(long var0);

    private static native void deallocateNativeObject0(long var0);

    private static native byte byteAt(long var0, int var2);

    private static native void setByteAt(long var0, int var2, byte var3);

    private static native int length(long var0);

    private static native void clear(long var0);

    private static native long substring(long var0, int var2, int var3);

    private static native void appendChar(long var0, byte var2);

    private static native void readValues(long var0, byte @NotNull [] var2);
}

