/*
 * Decompiled with CFR 0.152.
 */
package org.ice1000.jimgui.util;

import org.ice1000.jimgui.util.NativeUtil;
import org.ice1000.jimgui.util.SharedState;

public interface JniLoader {
    public static final String OsName = System.getProperty("os.name");
    public static final String ArchitectureName = System.getProperty("os.arch");
    public static final boolean X86 = "x86".equals(ArchitectureName);
    public static final boolean Linux = "Linux".equals(OsName);
    public static final boolean Windows95 = "Windows 95".equals(OsName);
    public static final boolean Windows98 = "Windows 98".equals(OsName);
    public static final boolean Windows200X = OsName.startsWith("Windows 200");
    public static final boolean WindowsXP = "Windows XP".equals(OsName);
    public static final boolean WindowsVista = "Windows Vista".equals(OsName);
    public static final boolean Windows7 = "Windows 7".equals(OsName) || OsName.startsWith("Windows Server 2008");
    public static final boolean Windows8 = "Windows 8".equals(OsName) || "Windows 8.1".equals(OsName) || OsName.startsWith("Windows Server 2012");
    public static final boolean Windows10 = "Windows 10".equals(OsName) || OsName.startsWith("Windows Server 2019") || OsName.startsWith("Windows Server 2016");
    public static final boolean OSX = "Mac OS X".equals(OsName);

    public static void load() {
        if (SharedState.isLoaded) {
            return;
        }
        if (Linux) {
            JniLoader.loadLib(X86 ? "libjimgui32.so" : "libjimgui.so");
        } else if (WindowsVista || WindowsXP) {
            JniLoader.loadDX9();
        } else if (Windows7 || Windows8 || Windows10) {
            JniLoader.loadDX11();
        } else if (OSX) {
            JniLoader.loadLib("libjimgui.dylib");
        } else {
            if (Windows98 || Windows95 || Windows200X) {
                throw new UnsupportedOperationException("Windows 98/95/2000/2003 are not supported and won't be supported.");
            }
            throw new UnsupportedOperationException("Unknown OS " + OsName + ", please submit issue to https://github.com/ice1000/jimgui/issues");
        }
        SharedState.isLoaded = true;
    }

    public static void loadDX11() {
        JniLoader.loadLib(X86 ? "jimgui32.dll" : "jimgui.dll");
        JniLoader.loadLib(X86 ? "jimgui32-dx11.dll" : "jimgui-dx11.dll");
    }

    public static void loadDX9() {
        JniLoader.loadLib(X86 ? "jimgui32.dll" : "jimgui.dll");
        JniLoader.loadLib(X86 ? "jimgui32-dx9.dll" : "jimgui-dx9.dll");
    }

    public static void loadLib(String libraryName) {
        NativeUtil.loadLibraryFromJar(libraryName, NativeUtil.class);
    }
}

