package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.4
 */
@SuppressWarnings("ALL")

public class JImGuiFontConfigGen {
protected long nativeObjectPtr;

  /** package-private by design */
  JImGuiFontConfigGen(long nativeObjectPtr) {
    this.nativeObjectPtr = nativeObjectPtr;
  }

  private static native void setGlyphExtraSpacingX(long nativeObjectPtr,float newValue);
  /**0%2C+0+++++%7C%7C+Extra+spacing+%28in+pixels%29+between+glyphs.+Only+X+axis+is+supported+for+now.*/
  public void setGlyphExtraSpacingX(float newValue){setGlyphExtraSpacingX(nativeObjectPtr, newValue); }
  private static native float getGlyphExtraSpacingX(long nativeObjectPtr);
  /**0%2C+0+++++%7C%7C+Extra+spacing+%28in+pixels%29+between+glyphs.+Only+X+axis+is+supported+for+now.*/
  public float getGlyphExtraSpacingX(){return getGlyphExtraSpacingX(nativeObjectPtr);}
  private static native void setGlyphExtraSpacingY(long nativeObjectPtr,float newValue);
  /**0%2C+0+++++%7C%7C+Extra+spacing+%28in+pixels%29+between+glyphs.+Only+X+axis+is+supported+for+now.*/
  public void setGlyphExtraSpacingY(float newValue){setGlyphExtraSpacingY(nativeObjectPtr, newValue); }
  private static native float getGlyphExtraSpacingY(long nativeObjectPtr);
  /**0%2C+0+++++%7C%7C+Extra+spacing+%28in+pixels%29+between+glyphs.+Only+X+axis+is+supported+for+now.*/
  public float getGlyphExtraSpacingY(){return getGlyphExtraSpacingY(nativeObjectPtr);}
  private static native void setGlyphOffsetX(long nativeObjectPtr,float newValue);
  /**0%2C+0+++++%7C%7C+Offset+all+glyphs+from+this+font+input.%0A++Input++++%7C%7C+For+custom+font+glyphs+only%3A+glyph+display+offset*/
  public void setGlyphOffsetX(float newValue){setGlyphOffsetX(nativeObjectPtr, newValue); }
  private static native float getGlyphOffsetX(long nativeObjectPtr);
  /**0%2C+0+++++%7C%7C+Offset+all+glyphs+from+this+font+input.%0A++Input++++%7C%7C+For+custom+font+glyphs+only%3A+glyph+display+offset*/
  public float getGlyphOffsetX(){return getGlyphOffsetX(nativeObjectPtr);}
  private static native void setGlyphOffsetY(long nativeObjectPtr,float newValue);
  /**0%2C+0+++++%7C%7C+Offset+all+glyphs+from+this+font+input.%0A++Input++++%7C%7C+For+custom+font+glyphs+only%3A+glyph+display+offset*/
  public void setGlyphOffsetY(float newValue){setGlyphOffsetY(nativeObjectPtr, newValue); }
  private static native float getGlyphOffsetY(long nativeObjectPtr);
  /**0%2C+0+++++%7C%7C+Offset+all+glyphs+from+this+font+input.%0A++Input++++%7C%7C+For+custom+font+glyphs+only%3A+glyph+display+offset*/
  public float getGlyphOffsetY(){return getGlyphOffsetY(nativeObjectPtr);}
  /**TTF%7COTF+data+size*/
  public int getFontDataSize(){return getFontDataSize(nativeObjectPtr);}
  protected static native int getFontDataSize(long nativeObjectPtr);
  /**TTF%7COTF+data+size*/
  public void setFontDataSize(int newValue) {setFontDataSize(nativeObjectPtr, newValue);}
  protected static native void setFontDataSize(long nativeObjectPtr, int newValue);
  /**0++++++++%7C%7C+Index+of+font+within+TTF%7COTF+file*/
  public int getFontNo(){return getFontNo(nativeObjectPtr);}
  protected static native int getFontNo(long nativeObjectPtr);
  /**0++++++++%7C%7C+Index+of+font+within+TTF%7COTF+file*/
  public void setFontNo(int newValue) {setFontNo(nativeObjectPtr, newValue);}
  protected static native void setFontNo(long nativeObjectPtr, int newValue);
  /**3++++++++%7C%7C+Rasterize+at+higher+quality+for+sub-pixel+positioning.+Note+the+difference+between+2+and+3+is+minimal+so+you+can+reduce+this+to+2+to+save+memory.+Read+https%3A%7C%7Cgithub.com%7Cnothings%7Cstb%7Cblob%7Cmaster%7Ctests%7Coversample%7CREADME.md+for+details.*/
  public int getOversampleH(){return getOversampleH(nativeObjectPtr);}
  protected static native int getOversampleH(long nativeObjectPtr);
  /**3++++++++%7C%7C+Rasterize+at+higher+quality+for+sub-pixel+positioning.+Note+the+difference+between+2+and+3+is+minimal+so+you+can+reduce+this+to+2+to+save+memory.+Read+https%3A%7C%7Cgithub.com%7Cnothings%7Cstb%7Cblob%7Cmaster%7Ctests%7Coversample%7CREADME.md+for+details.*/
  public void setOversampleH(int newValue) {setOversampleH(nativeObjectPtr, newValue);}
  protected static native void setOversampleH(long nativeObjectPtr, int newValue);
  /**1++++++++%7C%7C+Rasterize+at+higher+quality+for+sub-pixel+positioning.+This+is+not+really+useful+as+we+don%27t+use+sub-pixel+positions+on+the+Y+axis.*/
  public int getOversampleV(){return getOversampleV(nativeObjectPtr);}
  protected static native int getOversampleV(long nativeObjectPtr);
  /**1++++++++%7C%7C+Rasterize+at+higher+quality+for+sub-pixel+positioning.+This+is+not+really+useful+as+we+don%27t+use+sub-pixel+positions+on+the+Y+axis.*/
  public void setOversampleV(int newValue) {setOversampleV(nativeObjectPtr, newValue);}
  protected static native void setOversampleV(long nativeObjectPtr, int newValue);
  /**0++++++++%7C%7C+Settings+for+custom+font+builder.+THIS+IS+BUILDER+IMPLEMENTATION+DEPENDENT.+Leave+as+zero+if+unsure.%0A++Shared+flags+%28for+all+fonts%29+for+custom+font+builder.+THIS+IS+BUILD+IMPLEMENTATION+DEPENDENT.+Per-font+override+is+also+available+in+ImFontConfig.*/
  public int getFontBuilderFlags(){return getFontBuilderFlags(nativeObjectPtr);}
  protected static native int getFontBuilderFlags(long nativeObjectPtr);
  /**0++++++++%7C%7C+Settings+for+custom+font+builder.+THIS+IS+BUILDER+IMPLEMENTATION+DEPENDENT.+Leave+as+zero+if+unsure.%0A++Shared+flags+%28for+all+fonts%29+for+custom+font+builder.+THIS+IS+BUILD+IMPLEMENTATION+DEPENDENT.+Per-font+override+is+also+available+in+ImFontConfig.*/
  public void setFontBuilderFlags(int newValue) {setFontBuilderFlags(nativeObjectPtr, newValue);}
  protected static native void setFontBuilderFlags(long nativeObjectPtr, int newValue);
  /**Size+in+pixels+for+rasterizer+%28more+or+less+maps+to+the+resulting+font+height%29.*/
  public float getSizePixels(){return getSizePixels(nativeObjectPtr);}
  protected static native float getSizePixels(long nativeObjectPtr);
  /**Size+in+pixels+for+rasterizer+%28more+or+less+maps+to+the+resulting+font+height%29.*/
  public void setSizePixels(float newValue) {setSizePixels(nativeObjectPtr, newValue);}
  protected static native void setSizePixels(long nativeObjectPtr, float newValue);
  /**1.0f+++++%7C%7C+Brighten+%28%3E1.0f%29+or+darken+%28%3C1.0f%29+font+output.+Brightening+small+fonts+may+be+a+good+workaround+to+make+them+more+readable.*/
  public float getRasterizerMultiply(){return getRasterizerMultiply(nativeObjectPtr);}
  protected static native float getRasterizerMultiply(long nativeObjectPtr);
  /**1.0f+++++%7C%7C+Brighten+%28%3E1.0f%29+or+darken+%28%3C1.0f%29+font+output.+Brightening+small+fonts+may+be+a+good+workaround+to+make+them+more+readable.*/
  public void setRasterizerMultiply(float newValue) {setRasterizerMultiply(nativeObjectPtr, newValue);}
  protected static native void setRasterizerMultiply(long nativeObjectPtr, float newValue);
  /**0++++++++%7C%7C+Minimum+AdvanceX+for+glyphs%2C+set+Min+to+align+font+icons%2C+set+both+Min%7CMax+to+enforce+mono-space+font*/
  public float getGlyphMinAdvanceX(){return getGlyphMinAdvanceX(nativeObjectPtr);}
  protected static native float getGlyphMinAdvanceX(long nativeObjectPtr);
  /**0++++++++%7C%7C+Minimum+AdvanceX+for+glyphs%2C+set+Min+to+align+font+icons%2C+set+both+Min%7CMax+to+enforce+mono-space+font*/
  public void setGlyphMinAdvanceX(float newValue) {setGlyphMinAdvanceX(nativeObjectPtr, newValue);}
  protected static native void setGlyphMinAdvanceX(long nativeObjectPtr, float newValue);
  /**FLT_MAX++%7C%7C+Maximum+AdvanceX+for+glyphs*/
  public float getGlyphMaxAdvanceX(){return getGlyphMaxAdvanceX(nativeObjectPtr);}
  protected static native float getGlyphMaxAdvanceX(long nativeObjectPtr);
  /**FLT_MAX++%7C%7C+Maximum+AdvanceX+for+glyphs*/
  public void setGlyphMaxAdvanceX(float newValue) {setGlyphMaxAdvanceX(nativeObjectPtr, newValue);}
  protected static native void setGlyphMaxAdvanceX(long nativeObjectPtr, float newValue);
  /**true+++++%7C%7C+TTF%7COTF+data+ownership+taken+by+the+container+ImFontAtlas+%28will+delete+memory+itself%29.*/
  public boolean isFontDataOwnedByAtlas(){return isFontDataOwnedByAtlas(this.nativeObjectPtr);}
  public static native boolean isFontDataOwnedByAtlas(long nativeObjectPtr);
  /**true+++++%7C%7C+TTF%7COTF+data+ownership+taken+by+the+container+ImFontAtlas+%28will+delete+memory+itself%29.*/
  public void setFontDataOwnedByAtlas(boolean newValue){setFontDataOwnedByAtlas(this.nativeObjectPtr,newValue);}
  public static native void setFontDataOwnedByAtlas(long nativeObjectPtr, boolean newValue);
  /**false++++%7C%7C+Align+every+glyph+to+pixel+boundary.+Useful+e.g.+if+you+are+merging+a+non-pixel+aligned+font+with+the+default+font.+If+enabled%2C+you+can+set+OversampleH%7CV+to+1.*/
  public boolean isPixelSnapH(){return isPixelSnapH(this.nativeObjectPtr);}
  public static native boolean isPixelSnapH(long nativeObjectPtr);
  /**false++++%7C%7C+Align+every+glyph+to+pixel+boundary.+Useful+e.g.+if+you+are+merging+a+non-pixel+aligned+font+with+the+default+font.+If+enabled%2C+you+can+set+OversampleH%7CV+to+1.*/
  public void setPixelSnapH(boolean newValue){setPixelSnapH(this.nativeObjectPtr,newValue);}
  public static native void setPixelSnapH(long nativeObjectPtr, boolean newValue);
  /**false++++%7C%7C+Merge+into+previous+ImFont%2C+so+you+can+combine+multiple+inputs+font+into+one+ImFont+%28e.g.+ASCII+font+%2B+icons+%2B+Japanese+glyphs%29.+You+may+want+to+use+GlyphOffset.y+when+merge+font+of+different+heights.*/
  public boolean isMergeMode(){return isMergeMode(this.nativeObjectPtr);}
  public static native boolean isMergeMode(long nativeObjectPtr);
  /**false++++%7C%7C+Merge+into+previous+ImFont%2C+so+you+can+combine+multiple+inputs+font+into+one+ImFont+%28e.g.+ASCII+font+%2B+icons+%2B+Japanese+glyphs%29.+You+may+want+to+use+GlyphOffset.y+when+merge+font+of+different+heights.*/
  public void setMergeMode(boolean newValue){setMergeMode(this.nativeObjectPtr,newValue);}
  public static native void setMergeMode(long nativeObjectPtr, boolean newValue);

}