package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")

public class JImGuiStyleGen {
  @Contract(pure = true)
  public static @NotNull JImGuiStyleGen getInstance(@NotNull JImGui owner) { return owner.getStyle(); }

  /** package-private by design */
  JImGuiStyleGen(long nativeObjectPtr) {
    this.nativeObjectPtr = nativeObjectPtr;
  }

  protected long nativeObjectPtr;

  private static native void setWindowPaddingX(long nativeObjectPtr,float newValue);
  /**Padding+within+a+window.%0A++Window+padding+at+the+time+of+Begin%28%29.*/
  public void setWindowPaddingX(float newValue){setWindowPaddingX(nativeObjectPtr, newValue); }
  private static native float getWindowPaddingX(long nativeObjectPtr);
  /**Padding+within+a+window.%0A++Window+padding+at+the+time+of+Begin%28%29.*/
  public float getWindowPaddingX(){return getWindowPaddingX(nativeObjectPtr);}
  private static native void setWindowPaddingY(long nativeObjectPtr,float newValue);
  /**Padding+within+a+window.%0A++Window+padding+at+the+time+of+Begin%28%29.*/
  public void setWindowPaddingY(float newValue){setWindowPaddingY(nativeObjectPtr, newValue); }
  private static native float getWindowPaddingY(long nativeObjectPtr);
  /**Padding+within+a+window.%0A++Window+padding+at+the+time+of+Begin%28%29.*/
  public float getWindowPaddingY(){return getWindowPaddingY(nativeObjectPtr);}
  private static native void setWindowMinSizeX(long nativeObjectPtr,float newValue);
  /**Minimum+window+size.+This+is+a+global+setting.+If+you+want+to+constraint+individual+windows%2C+use+SetNextWindowSizeConstraints%28%29.*/
  public void setWindowMinSizeX(float newValue){setWindowMinSizeX(nativeObjectPtr, newValue); }
  private static native float getWindowMinSizeX(long nativeObjectPtr);
  /**Minimum+window+size.+This+is+a+global+setting.+If+you+want+to+constraint+individual+windows%2C+use+SetNextWindowSizeConstraints%28%29.*/
  public float getWindowMinSizeX(){return getWindowMinSizeX(nativeObjectPtr);}
  private static native void setWindowMinSizeY(long nativeObjectPtr,float newValue);
  /**Minimum+window+size.+This+is+a+global+setting.+If+you+want+to+constraint+individual+windows%2C+use+SetNextWindowSizeConstraints%28%29.*/
  public void setWindowMinSizeY(float newValue){setWindowMinSizeY(nativeObjectPtr, newValue); }
  private static native float getWindowMinSizeY(long nativeObjectPtr);
  /**Minimum+window+size.+This+is+a+global+setting.+If+you+want+to+constraint+individual+windows%2C+use+SetNextWindowSizeConstraints%28%29.*/
  public float getWindowMinSizeY(){return getWindowMinSizeY(nativeObjectPtr);}
  private static native void setWindowTitleAlignX(long nativeObjectPtr,float newValue);
  /**Alignment+for+title+bar+text.+Defaults+to+%280.0f%2C0.5f%29+for+left-aligned%2Cvertically+centered.*/
  public void setWindowTitleAlignX(float newValue){setWindowTitleAlignX(nativeObjectPtr, newValue); }
  private static native float getWindowTitleAlignX(long nativeObjectPtr);
  /**Alignment+for+title+bar+text.+Defaults+to+%280.0f%2C0.5f%29+for+left-aligned%2Cvertically+centered.*/
  public float getWindowTitleAlignX(){return getWindowTitleAlignX(nativeObjectPtr);}
  private static native void setWindowTitleAlignY(long nativeObjectPtr,float newValue);
  /**Alignment+for+title+bar+text.+Defaults+to+%280.0f%2C0.5f%29+for+left-aligned%2Cvertically+centered.*/
  public void setWindowTitleAlignY(float newValue){setWindowTitleAlignY(nativeObjectPtr, newValue); }
  private static native float getWindowTitleAlignY(long nativeObjectPtr);
  /**Alignment+for+title+bar+text.+Defaults+to+%280.0f%2C0.5f%29+for+left-aligned%2Cvertically+centered.*/
  public float getWindowTitleAlignY(){return getWindowTitleAlignY(nativeObjectPtr);}
  private static native void setFramePaddingX(long nativeObjectPtr,float newValue);
  /**Padding+within+a+framed+rectangle+%28used+by+most+widgets%29.%0A++style.FramePadding+locked+at+the+time+of+BeginTabBar%28%29*/
  public void setFramePaddingX(float newValue){setFramePaddingX(nativeObjectPtr, newValue); }
  private static native float getFramePaddingX(long nativeObjectPtr);
  /**Padding+within+a+framed+rectangle+%28used+by+most+widgets%29.%0A++style.FramePadding+locked+at+the+time+of+BeginTabBar%28%29*/
  public float getFramePaddingX(){return getFramePaddingX(nativeObjectPtr);}
  private static native void setFramePaddingY(long nativeObjectPtr,float newValue);
  /**Padding+within+a+framed+rectangle+%28used+by+most+widgets%29.%0A++style.FramePadding+locked+at+the+time+of+BeginTabBar%28%29*/
  public void setFramePaddingY(float newValue){setFramePaddingY(nativeObjectPtr, newValue); }
  private static native float getFramePaddingY(long nativeObjectPtr);
  /**Padding+within+a+framed+rectangle+%28used+by+most+widgets%29.%0A++style.FramePadding+locked+at+the+time+of+BeginTabBar%28%29*/
  public float getFramePaddingY(){return getFramePaddingY(nativeObjectPtr);}
  private static native void setItemSpacingX(long nativeObjectPtr,float newValue);
  /**Horizontal+and+vertical+spacing+between+widgets%7Clines.*/
  public void setItemSpacingX(float newValue){setItemSpacingX(nativeObjectPtr, newValue); }
  private static native float getItemSpacingX(long nativeObjectPtr);
  /**Horizontal+and+vertical+spacing+between+widgets%7Clines.*/
  public float getItemSpacingX(){return getItemSpacingX(nativeObjectPtr);}
  private static native void setItemSpacingY(long nativeObjectPtr,float newValue);
  /**Horizontal+and+vertical+spacing+between+widgets%7Clines.*/
  public void setItemSpacingY(float newValue){setItemSpacingY(nativeObjectPtr, newValue); }
  private static native float getItemSpacingY(long nativeObjectPtr);
  /**Horizontal+and+vertical+spacing+between+widgets%7Clines.*/
  public float getItemSpacingY(){return getItemSpacingY(nativeObjectPtr);}
  private static native void setCellPaddingX(long nativeObjectPtr,float newValue);
  /**Padding+within+a+table+cell*/
  public void setCellPaddingX(float newValue){setCellPaddingX(nativeObjectPtr, newValue); }
  private static native float getCellPaddingX(long nativeObjectPtr);
  /**Padding+within+a+table+cell*/
  public float getCellPaddingX(){return getCellPaddingX(nativeObjectPtr);}
  private static native void setCellPaddingY(long nativeObjectPtr,float newValue);
  /**Padding+within+a+table+cell*/
  public void setCellPaddingY(float newValue){setCellPaddingY(nativeObjectPtr, newValue); }
  private static native float getCellPaddingY(long nativeObjectPtr);
  /**Padding+within+a+table+cell*/
  public float getCellPaddingY(){return getCellPaddingY(nativeObjectPtr);}
  private static native void setItemInnerSpacingX(long nativeObjectPtr,float newValue);
  /**Horizontal+and+vertical+spacing+between+within+elements+of+a+composed+widget+%28e.g.+a+slider+and+its+label%29.*/
  public void setItemInnerSpacingX(float newValue){setItemInnerSpacingX(nativeObjectPtr, newValue); }
  private static native float getItemInnerSpacingX(long nativeObjectPtr);
  /**Horizontal+and+vertical+spacing+between+within+elements+of+a+composed+widget+%28e.g.+a+slider+and+its+label%29.*/
  public float getItemInnerSpacingX(){return getItemInnerSpacingX(nativeObjectPtr);}
  private static native void setItemInnerSpacingY(long nativeObjectPtr,float newValue);
  /**Horizontal+and+vertical+spacing+between+within+elements+of+a+composed+widget+%28e.g.+a+slider+and+its+label%29.*/
  public void setItemInnerSpacingY(float newValue){setItemInnerSpacingY(nativeObjectPtr, newValue); }
  private static native float getItemInnerSpacingY(long nativeObjectPtr);
  /**Horizontal+and+vertical+spacing+between+within+elements+of+a+composed+widget+%28e.g.+a+slider+and+its+label%29.*/
  public float getItemInnerSpacingY(){return getItemInnerSpacingY(nativeObjectPtr);}
  private static native void setTouchExtraPaddingX(long nativeObjectPtr,float newValue);
  /**Expand+reactive+bounding+box+for+touch-based+system+where+touch+position+is+not+accurate+enough.+Unfortunately+we+don%27t+sort+widgets+so+priority+on+overlap+will+always+be+given+to+the+first+widget.+So+don%27t+grow+this+too+much%21*/
  public void setTouchExtraPaddingX(float newValue){setTouchExtraPaddingX(nativeObjectPtr, newValue); }
  private static native float getTouchExtraPaddingX(long nativeObjectPtr);
  /**Expand+reactive+bounding+box+for+touch-based+system+where+touch+position+is+not+accurate+enough.+Unfortunately+we+don%27t+sort+widgets+so+priority+on+overlap+will+always+be+given+to+the+first+widget.+So+don%27t+grow+this+too+much%21*/
  public float getTouchExtraPaddingX(){return getTouchExtraPaddingX(nativeObjectPtr);}
  private static native void setTouchExtraPaddingY(long nativeObjectPtr,float newValue);
  /**Expand+reactive+bounding+box+for+touch-based+system+where+touch+position+is+not+accurate+enough.+Unfortunately+we+don%27t+sort+widgets+so+priority+on+overlap+will+always+be+given+to+the+first+widget.+So+don%27t+grow+this+too+much%21*/
  public void setTouchExtraPaddingY(float newValue){setTouchExtraPaddingY(nativeObjectPtr, newValue); }
  private static native float getTouchExtraPaddingY(long nativeObjectPtr);
  /**Expand+reactive+bounding+box+for+touch-based+system+where+touch+position+is+not+accurate+enough.+Unfortunately+we+don%27t+sort+widgets+so+priority+on+overlap+will+always+be+given+to+the+first+widget.+So+don%27t+grow+this+too+much%21*/
  public float getTouchExtraPaddingY(){return getTouchExtraPaddingY(nativeObjectPtr);}
  private static native void setButtonTextAlignX(long nativeObjectPtr,float newValue);
  /**Alignment+of+button+text+when+button+is+larger+than+text.+Defaults+to+%280.5f%2C+0.5f%29+%28centered%29.*/
  public void setButtonTextAlignX(float newValue){setButtonTextAlignX(nativeObjectPtr, newValue); }
  private static native float getButtonTextAlignX(long nativeObjectPtr);
  /**Alignment+of+button+text+when+button+is+larger+than+text.+Defaults+to+%280.5f%2C+0.5f%29+%28centered%29.*/
  public float getButtonTextAlignX(){return getButtonTextAlignX(nativeObjectPtr);}
  private static native void setButtonTextAlignY(long nativeObjectPtr,float newValue);
  /**Alignment+of+button+text+when+button+is+larger+than+text.+Defaults+to+%280.5f%2C+0.5f%29+%28centered%29.*/
  public void setButtonTextAlignY(float newValue){setButtonTextAlignY(nativeObjectPtr, newValue); }
  private static native float getButtonTextAlignY(long nativeObjectPtr);
  /**Alignment+of+button+text+when+button+is+larger+than+text.+Defaults+to+%280.5f%2C+0.5f%29+%28centered%29.*/
  public float getButtonTextAlignY(){return getButtonTextAlignY(nativeObjectPtr);}
  private static native void setSelectableTextAlignX(long nativeObjectPtr,float newValue);
  /**Alignment+of+selectable+text.+Defaults+to+%280.0f%2C+0.0f%29+%28top-left+aligned%29.+It%27s+generally+important+to+keep+this+left-aligned+if+you+want+to+lay+multiple+items+on+a+same+line.*/
  public void setSelectableTextAlignX(float newValue){setSelectableTextAlignX(nativeObjectPtr, newValue); }
  private static native float getSelectableTextAlignX(long nativeObjectPtr);
  /**Alignment+of+selectable+text.+Defaults+to+%280.0f%2C+0.0f%29+%28top-left+aligned%29.+It%27s+generally+important+to+keep+this+left-aligned+if+you+want+to+lay+multiple+items+on+a+same+line.*/
  public float getSelectableTextAlignX(){return getSelectableTextAlignX(nativeObjectPtr);}
  private static native void setSelectableTextAlignY(long nativeObjectPtr,float newValue);
  /**Alignment+of+selectable+text.+Defaults+to+%280.0f%2C+0.0f%29+%28top-left+aligned%29.+It%27s+generally+important+to+keep+this+left-aligned+if+you+want+to+lay+multiple+items+on+a+same+line.*/
  public void setSelectableTextAlignY(float newValue){setSelectableTextAlignY(nativeObjectPtr, newValue); }
  private static native float getSelectableTextAlignY(long nativeObjectPtr);
  /**Alignment+of+selectable+text.+Defaults+to+%280.0f%2C+0.0f%29+%28top-left+aligned%29.+It%27s+generally+important+to+keep+this+left-aligned+if+you+want+to+lay+multiple+items+on+a+same+line.*/
  public float getSelectableTextAlignY(){return getSelectableTextAlignY(nativeObjectPtr);}
  private static native void setDisplayWindowPaddingX(long nativeObjectPtr,float newValue);
  /**Window+position+are+clamped+to+be+visible+within+the+display+area+or+monitors+by+at+least+this+amount.+Only+applies+to+regular+windows.*/
  public void setDisplayWindowPaddingX(float newValue){setDisplayWindowPaddingX(nativeObjectPtr, newValue); }
  private static native float getDisplayWindowPaddingX(long nativeObjectPtr);
  /**Window+position+are+clamped+to+be+visible+within+the+display+area+or+monitors+by+at+least+this+amount.+Only+applies+to+regular+windows.*/
  public float getDisplayWindowPaddingX(){return getDisplayWindowPaddingX(nativeObjectPtr);}
  private static native void setDisplayWindowPaddingY(long nativeObjectPtr,float newValue);
  /**Window+position+are+clamped+to+be+visible+within+the+display+area+or+monitors+by+at+least+this+amount.+Only+applies+to+regular+windows.*/
  public void setDisplayWindowPaddingY(float newValue){setDisplayWindowPaddingY(nativeObjectPtr, newValue); }
  private static native float getDisplayWindowPaddingY(long nativeObjectPtr);
  /**Window+position+are+clamped+to+be+visible+within+the+display+area+or+monitors+by+at+least+this+amount.+Only+applies+to+regular+windows.*/
  public float getDisplayWindowPaddingY(){return getDisplayWindowPaddingY(nativeObjectPtr);}
  private static native void setDisplaySafeAreaPaddingX(long nativeObjectPtr,float newValue);
  /**If+you+cannot+see+the+edges+of+your+screen+%28e.g.+on+a+TV%29+increase+the+safe+area+padding.+Apply+to+popups%7Ctooltips+as+well+regular+windows.+NB%3A+Prefer+configuring+your+TV+sets+correctly%21*/
  public void setDisplaySafeAreaPaddingX(float newValue){setDisplaySafeAreaPaddingX(nativeObjectPtr, newValue); }
  private static native float getDisplaySafeAreaPaddingX(long nativeObjectPtr);
  /**If+you+cannot+see+the+edges+of+your+screen+%28e.g.+on+a+TV%29+increase+the+safe+area+padding.+Apply+to+popups%7Ctooltips+as+well+regular+windows.+NB%3A+Prefer+configuring+your+TV+sets+correctly%21*/
  public float getDisplaySafeAreaPaddingX(){return getDisplaySafeAreaPaddingX(nativeObjectPtr);}
  private static native void setDisplaySafeAreaPaddingY(long nativeObjectPtr,float newValue);
  /**If+you+cannot+see+the+edges+of+your+screen+%28e.g.+on+a+TV%29+increase+the+safe+area+padding.+Apply+to+popups%7Ctooltips+as+well+regular+windows.+NB%3A+Prefer+configuring+your+TV+sets+correctly%21*/
  public void setDisplaySafeAreaPaddingY(float newValue){setDisplaySafeAreaPaddingY(nativeObjectPtr, newValue); }
  private static native float getDisplaySafeAreaPaddingY(long nativeObjectPtr);
  /**If+you+cannot+see+the+edges+of+your+screen+%28e.g.+on+a+TV%29+increase+the+safe+area+padding.+Apply+to+popups%7Ctooltips+as+well+regular+windows.+NB%3A+Prefer+configuring+your+TV+sets+correctly%21*/
  public float getDisplaySafeAreaPaddingY(){return getDisplaySafeAreaPaddingY(nativeObjectPtr);}
  /**Side+of+the+collapsing%7Cdocking+button+in+the+title+bar+%28None%7CLeft%7CRight%29.+Defaults+to+ImGuiDir_Left.*/
  public int getWindowMenuButtonPosition(){return getWindowMenuButtonPosition(nativeObjectPtr);}
  protected static native int getWindowMenuButtonPosition(long nativeObjectPtr);
  /**Side+of+the+collapsing%7Cdocking+button+in+the+title+bar+%28None%7CLeft%7CRight%29.+Defaults+to+ImGuiDir_Left.*/
  public void setWindowMenuButtonPosition(int newValue) {setWindowMenuButtonPosition(nativeObjectPtr, newValue);}
  protected static native void setWindowMenuButtonPosition(long nativeObjectPtr, int newValue);
  /**Side+of+the+color+button+in+the+ColorEdit4+widget+%28left%7Cright%29.+Defaults+to+ImGuiDir_Right.*/
  public int getColorButtonPosition(){return getColorButtonPosition(nativeObjectPtr);}
  protected static native int getColorButtonPosition(long nativeObjectPtr);
  /**Side+of+the+color+button+in+the+ColorEdit4+widget+%28left%7Cright%29.+Defaults+to+ImGuiDir_Right.*/
  public void setColorButtonPosition(int newValue) {setColorButtonPosition(nativeObjectPtr, newValue);}
  protected static native void setColorButtonPosition(long nativeObjectPtr, int newValue);
  /**Global+alpha+applies+to+everything+in+Dear+ImGui.*/
  public float getAlpha(){return getAlpha(nativeObjectPtr);}
  protected static native float getAlpha(long nativeObjectPtr);
  /**Global+alpha+applies+to+everything+in+Dear+ImGui.*/
  public void setAlpha(float newValue) {setAlpha(nativeObjectPtr, newValue);}
  protected static native void setAlpha(long nativeObjectPtr, float newValue);
  /**Radius+of+window+corners+rounding.+Set+to+0.0f+to+have+rectangular+windows.+Large+values+tend+to+lead+to+variety+of+artifacts+and+are+not+recommended.%0A++Window+rounding+at+the+time+of+Begin%28%29.+May+be+clamped+lower+to+avoid+rendering+artifacts+with+title+bar%2C+menu+bar+etc.*/
  public float getWindowRounding(){return getWindowRounding(nativeObjectPtr);}
  protected static native float getWindowRounding(long nativeObjectPtr);
  /**Radius+of+window+corners+rounding.+Set+to+0.0f+to+have+rectangular+windows.+Large+values+tend+to+lead+to+variety+of+artifacts+and+are+not+recommended.%0A++Window+rounding+at+the+time+of+Begin%28%29.+May+be+clamped+lower+to+avoid+rendering+artifacts+with+title+bar%2C+menu+bar+etc.*/
  public void setWindowRounding(float newValue) {setWindowRounding(nativeObjectPtr, newValue);}
  protected static native void setWindowRounding(long nativeObjectPtr, float newValue);
  /**Thickness+of+border+around+windows.+Generally+set+to+0.0f+or+1.0f.+%28Other+values+are+not+well+tested+and+more+CPU%7CGPU+costly%29.%0A++Window+border+size+at+the+time+of+Begin%28%29.*/
  public float getWindowBorderSize(){return getWindowBorderSize(nativeObjectPtr);}
  protected static native float getWindowBorderSize(long nativeObjectPtr);
  /**Thickness+of+border+around+windows.+Generally+set+to+0.0f+or+1.0f.+%28Other+values+are+not+well+tested+and+more+CPU%7CGPU+costly%29.%0A++Window+border+size+at+the+time+of+Begin%28%29.*/
  public void setWindowBorderSize(float newValue) {setWindowBorderSize(nativeObjectPtr, newValue);}
  protected static native void setWindowBorderSize(long nativeObjectPtr, float newValue);
  /**Radius+of+child+window+corners+rounding.+Set+to+0.0f+to+have+rectangular+windows.*/
  public float getChildRounding(){return getChildRounding(nativeObjectPtr);}
  protected static native float getChildRounding(long nativeObjectPtr);
  /**Radius+of+child+window+corners+rounding.+Set+to+0.0f+to+have+rectangular+windows.*/
  public void setChildRounding(float newValue) {setChildRounding(nativeObjectPtr, newValue);}
  protected static native void setChildRounding(long nativeObjectPtr, float newValue);
  /**Thickness+of+border+around+child+windows.+Generally+set+to+0.0f+or+1.0f.+%28Other+values+are+not+well+tested+and+more+CPU%7CGPU+costly%29.*/
  public float getChildBorderSize(){return getChildBorderSize(nativeObjectPtr);}
  protected static native float getChildBorderSize(long nativeObjectPtr);
  /**Thickness+of+border+around+child+windows.+Generally+set+to+0.0f+or+1.0f.+%28Other+values+are+not+well+tested+and+more+CPU%7CGPU+costly%29.*/
  public void setChildBorderSize(float newValue) {setChildBorderSize(nativeObjectPtr, newValue);}
  protected static native void setChildBorderSize(long nativeObjectPtr, float newValue);
  /**Radius+of+popup+window+corners+rounding.+%28Note+that+tooltip+windows+use+WindowRounding%29*/
  public float getPopupRounding(){return getPopupRounding(nativeObjectPtr);}
  protected static native float getPopupRounding(long nativeObjectPtr);
  /**Radius+of+popup+window+corners+rounding.+%28Note+that+tooltip+windows+use+WindowRounding%29*/
  public void setPopupRounding(float newValue) {setPopupRounding(nativeObjectPtr, newValue);}
  protected static native void setPopupRounding(long nativeObjectPtr, float newValue);
  /**Thickness+of+border+around+popup%7Ctooltip+windows.+Generally+set+to+0.0f+or+1.0f.+%28Other+values+are+not+well+tested+and+more+CPU%7CGPU+costly%29.*/
  public float getPopupBorderSize(){return getPopupBorderSize(nativeObjectPtr);}
  protected static native float getPopupBorderSize(long nativeObjectPtr);
  /**Thickness+of+border+around+popup%7Ctooltip+windows.+Generally+set+to+0.0f+or+1.0f.+%28Other+values+are+not+well+tested+and+more+CPU%7CGPU+costly%29.*/
  public void setPopupBorderSize(float newValue) {setPopupBorderSize(nativeObjectPtr, newValue);}
  protected static native void setPopupBorderSize(long nativeObjectPtr, float newValue);
  /**Radius+of+frame+corners+rounding.+Set+to+0.0f+to+have+rectangular+frame+%28used+by+most+widgets%29.*/
  public float getFrameRounding(){return getFrameRounding(nativeObjectPtr);}
  protected static native float getFrameRounding(long nativeObjectPtr);
  /**Radius+of+frame+corners+rounding.+Set+to+0.0f+to+have+rectangular+frame+%28used+by+most+widgets%29.*/
  public void setFrameRounding(float newValue) {setFrameRounding(nativeObjectPtr, newValue);}
  protected static native void setFrameRounding(long nativeObjectPtr, float newValue);
  /**Thickness+of+border+around+frames.+Generally+set+to+0.0f+or+1.0f.+%28Other+values+are+not+well+tested+and+more+CPU%7CGPU+costly%29.*/
  public float getFrameBorderSize(){return getFrameBorderSize(nativeObjectPtr);}
  protected static native float getFrameBorderSize(long nativeObjectPtr);
  /**Thickness+of+border+around+frames.+Generally+set+to+0.0f+or+1.0f.+%28Other+values+are+not+well+tested+and+more+CPU%7CGPU+costly%29.*/
  public void setFrameBorderSize(float newValue) {setFrameBorderSize(nativeObjectPtr, newValue);}
  protected static native void setFrameBorderSize(long nativeObjectPtr, float newValue);
  public float getIndentSpacing(){return getIndentSpacing(nativeObjectPtr);}
  protected static native float getIndentSpacing(long nativeObjectPtr);
  public void setIndentSpacing(float newValue) {setIndentSpacing(nativeObjectPtr, newValue);}
  protected static native void setIndentSpacing(long nativeObjectPtr, float newValue);
  /**Minimum+horizontal+spacing+between+two+columns.+Preferably+%3E+%28FramePadding.x+%2B+1%29.*/
  public float getColumnsMinSpacing(){return getColumnsMinSpacing(nativeObjectPtr);}
  protected static native float getColumnsMinSpacing(long nativeObjectPtr);
  /**Minimum+horizontal+spacing+between+two+columns.+Preferably+%3E+%28FramePadding.x+%2B+1%29.*/
  public void setColumnsMinSpacing(float newValue) {setColumnsMinSpacing(nativeObjectPtr, newValue);}
  protected static native void setColumnsMinSpacing(long nativeObjectPtr, float newValue);
  /**Width+of+the+vertical+scrollbar%2C+Height+of+the+horizontal+scrollbar.*/
  public float getScrollbarSize(){return getScrollbarSize(nativeObjectPtr);}
  protected static native float getScrollbarSize(long nativeObjectPtr);
  /**Width+of+the+vertical+scrollbar%2C+Height+of+the+horizontal+scrollbar.*/
  public void setScrollbarSize(float newValue) {setScrollbarSize(nativeObjectPtr, newValue);}
  protected static native void setScrollbarSize(long nativeObjectPtr, float newValue);
  /**Radius+of+grab+corners+for+scrollbar.*/
  public float getScrollbarRounding(){return getScrollbarRounding(nativeObjectPtr);}
  protected static native float getScrollbarRounding(long nativeObjectPtr);
  /**Radius+of+grab+corners+for+scrollbar.*/
  public void setScrollbarRounding(float newValue) {setScrollbarRounding(nativeObjectPtr, newValue);}
  protected static native void setScrollbarRounding(long nativeObjectPtr, float newValue);
  /**Minimum+width%7Cheight+of+a+grab+box+for+slider%7Cscrollbar.*/
  public float getGrabMinSize(){return getGrabMinSize(nativeObjectPtr);}
  protected static native float getGrabMinSize(long nativeObjectPtr);
  /**Minimum+width%7Cheight+of+a+grab+box+for+slider%7Cscrollbar.*/
  public void setGrabMinSize(float newValue) {setGrabMinSize(nativeObjectPtr, newValue);}
  protected static native void setGrabMinSize(long nativeObjectPtr, float newValue);
  /**Radius+of+grabs+corners+rounding.+Set+to+0.0f+to+have+rectangular+slider+grabs.*/
  public float getGrabRounding(){return getGrabRounding(nativeObjectPtr);}
  protected static native float getGrabRounding(long nativeObjectPtr);
  /**Radius+of+grabs+corners+rounding.+Set+to+0.0f+to+have+rectangular+slider+grabs.*/
  public void setGrabRounding(float newValue) {setGrabRounding(nativeObjectPtr, newValue);}
  protected static native void setGrabRounding(long nativeObjectPtr, float newValue);
  /**The+size+in+pixels+of+the+dead-zone+around+zero+on+logarithmic+sliders+that+cross+zero.*/
  public float getLogSliderDeadzone(){return getLogSliderDeadzone(nativeObjectPtr);}
  protected static native float getLogSliderDeadzone(long nativeObjectPtr);
  /**The+size+in+pixels+of+the+dead-zone+around+zero+on+logarithmic+sliders+that+cross+zero.*/
  public void setLogSliderDeadzone(float newValue) {setLogSliderDeadzone(nativeObjectPtr, newValue);}
  protected static native void setLogSliderDeadzone(long nativeObjectPtr, float newValue);
  /**Radius+of+upper+corners+of+a+tab.+Set+to+0.0f+to+have+rectangular+tabs.*/
  public float getTabRounding(){return getTabRounding(nativeObjectPtr);}
  protected static native float getTabRounding(long nativeObjectPtr);
  /**Radius+of+upper+corners+of+a+tab.+Set+to+0.0f+to+have+rectangular+tabs.*/
  public void setTabRounding(float newValue) {setTabRounding(nativeObjectPtr, newValue);}
  protected static native void setTabRounding(long nativeObjectPtr, float newValue);
  /**Thickness+of+border+around+tabs.*/
  public float getTabBorderSize(){return getTabBorderSize(nativeObjectPtr);}
  protected static native float getTabBorderSize(long nativeObjectPtr);
  /**Thickness+of+border+around+tabs.*/
  public void setTabBorderSize(float newValue) {setTabBorderSize(nativeObjectPtr, newValue);}
  protected static native void setTabBorderSize(long nativeObjectPtr, float newValue);
  /**Minimum+width+for+close+button+to+appears+on+an+unselected+tab+when+hovered.+Set+to+0.0f+to+always+show+when+hovering%2C+set+to+FLT_MAX+to+never+show+close+button+unless+selected.*/
  public float getTabMinWidthForCloseButton(){return getTabMinWidthForCloseButton(nativeObjectPtr);}
  protected static native float getTabMinWidthForCloseButton(long nativeObjectPtr);
  /**Minimum+width+for+close+button+to+appears+on+an+unselected+tab+when+hovered.+Set+to+0.0f+to+always+show+when+hovering%2C+set+to+FLT_MAX+to+never+show+close+button+unless+selected.*/
  public void setTabMinWidthForCloseButton(float newValue) {setTabMinWidthForCloseButton(nativeObjectPtr, newValue);}
  protected static native void setTabMinWidthForCloseButton(long nativeObjectPtr, float newValue);
  /**Scale+software+rendered+mouse+cursor+%28when+io.MouseDrawCursor+is+enabled%29.+May+be+removed+later.*/
  public float getMouseCursorScale(){return getMouseCursorScale(nativeObjectPtr);}
  protected static native float getMouseCursorScale(long nativeObjectPtr);
  /**Scale+software+rendered+mouse+cursor+%28when+io.MouseDrawCursor+is+enabled%29.+May+be+removed+later.*/
  public void setMouseCursorScale(float newValue) {setMouseCursorScale(nativeObjectPtr, newValue);}
  protected static native void setMouseCursorScale(long nativeObjectPtr, float newValue);
  /**Tessellation+tolerance+when+using+PathBezierCurveTo%28%29+without+a+specific+number+of+segments.+Decrease+for+highly+tessellated+curves+%28higher+quality%2C+more+polygons%29%2C+increase+to+reduce+quality.%0A++Tessellation+tolerance+when+using+PathBezierCurveTo%28%29*/
  public float getCurveTessellationTol(){return getCurveTessellationTol(nativeObjectPtr);}
  protected static native float getCurveTessellationTol(long nativeObjectPtr);
  /**Tessellation+tolerance+when+using+PathBezierCurveTo%28%29+without+a+specific+number+of+segments.+Decrease+for+highly+tessellated+curves+%28higher+quality%2C+more+polygons%29%2C+increase+to+reduce+quality.%0A++Tessellation+tolerance+when+using+PathBezierCurveTo%28%29*/
  public void setCurveTessellationTol(float newValue) {setCurveTessellationTol(nativeObjectPtr, newValue);}
  protected static native void setCurveTessellationTol(long nativeObjectPtr, float newValue);
  /**Maximum+error+%28in+pixels%29+allowed+when+using+AddCircle%28%29%7CAddCircleFilled%28%29+or+drawing+rounded+corner+rectangles+with+no+explicit+segment+count+specified.+Decrease+for+higher+quality+but+more+geometry.*/
  public float getCircleTessellationMaxError(){return getCircleTessellationMaxError(nativeObjectPtr);}
  protected static native float getCircleTessellationMaxError(long nativeObjectPtr);
  /**Maximum+error+%28in+pixels%29+allowed+when+using+AddCircle%28%29%7CAddCircleFilled%28%29+or+drawing+rounded+corner+rectangles+with+no+explicit+segment+count+specified.+Decrease+for+higher+quality+but+more+geometry.*/
  public void setCircleTessellationMaxError(float newValue) {setCircleTessellationMaxError(nativeObjectPtr, newValue);}
  protected static native void setCircleTessellationMaxError(long nativeObjectPtr, float newValue);
  /**Enable+anti-aliased+lines%7Cborders.+Disable+if+you+are+really+tight+on+CPU%7CGPU.+Latched+at+the+beginning+of+the+frame+%28copied+to+ImDrawList%29.*/
  public boolean isAntiAliasedLines(){return isAntiAliasedLines(this.nativeObjectPtr);}
  public static native boolean isAntiAliasedLines(long nativeObjectPtr);
  /**Enable+anti-aliased+lines%7Cborders.+Disable+if+you+are+really+tight+on+CPU%7CGPU.+Latched+at+the+beginning+of+the+frame+%28copied+to+ImDrawList%29.*/
  public void setAntiAliasedLines(boolean newValue){setAntiAliasedLines(this.nativeObjectPtr,newValue);}
  public static native void setAntiAliasedLines(long nativeObjectPtr, boolean newValue);
  /**Enable+anti-aliased+edges+around+filled+shapes+%28rounded+rectangles%2C+circles%2C+etc.%29.+Disable+if+you+are+really+tight+on+CPU%7CGPU.+Latched+at+the+beginning+of+the+frame+%28copied+to+ImDrawList%29.*/
  public boolean isAntiAliasedFill(){return isAntiAliasedFill(this.nativeObjectPtr);}
  public static native boolean isAntiAliasedFill(long nativeObjectPtr);
  /**Enable+anti-aliased+edges+around+filled+shapes+%28rounded+rectangles%2C+circles%2C+etc.%29.+Disable+if+you+are+really+tight+on+CPU%7CGPU.+Latched+at+the+beginning+of+the+frame+%28copied+to+ImDrawList%29.*/
  public void setAntiAliasedFill(boolean newValue){setAntiAliasedFill(this.nativeObjectPtr,newValue);}
  public static native void setAntiAliasedFill(long nativeObjectPtr, boolean newValue);
  public static native void scaleAllSizes(float scaleFactor, long nativeObjectPtr);
  public final void scaleAllSizes(float scaleFactor){scaleAllSizes(scaleFactor,this.nativeObjectPtr);}

}