package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImInputTextFlags {
  int None = 0;
  /**Allow+0123456789.%2B-**/
  int CharsDecimal = 1 << 0;
  /**Allow+0123456789ABCDEFabcdef*/
  int CharsHexadecimal = 1 << 1;
  /**Turn+a..z+into+A..Z*/
  int CharsUppercase = 1 << 2;
  /**Filter+out+spaces%2C+tabs*/
  int CharsNoBlank = 1 << 3;
  /**Select+entire+text+when+first+taking+mouse+focus*/
  int AutoSelectAll = 1 << 4;
  /**Return+%27true%27+when+Enter+is+pressed+%28as+opposed+to+every+time+the+value+was+modified%29.+Consider+looking+at+the+IsItemDeactivatedAfterEdit%28%29+function.*/
  int EnterReturnsTrue = 1 << 5;
  /**Callback+on+pressing+TAB+%28for+completion+handling%29*/
  int CallbackCompletion = 1 << 6;
  /**Callback+on+pressing+Up%7CDown+arrows+%28for+history+handling%29*/
  int CallbackHistory = 1 << 7;
  /**Callback+on+each+iteration.+User+code+may+query+cursor+position%2C+modify+text+buffer.*/
  int CallbackAlways = 1 << 8;
  /**Callback+on+character+inputs+to+replace+or+discard+them.+Modify+%27EventChar%27+to+replace+or+discard%2C+or+return+1+in+callback+to+discard.*/
  int CallbackCharFilter = 1 << 9;
  /**Pressing+TAB+input+a+%27%5Ct%27+character+into+the+text+field*/
  int AllowTabInput = 1 << 10;
  /**In+multi-line+mode%2C+unfocus+with+Enter%2C+add+new+line+with+Ctrl%2BEnter+%28default+is+opposite%3A+unfocus+with+Ctrl%2BEnter%2C+add+line+with+Enter%29.*/
  int CtrlEnterForNewLine = 1 << 11;
  /**Disable+following+the+cursor+horizontally*/
  int NoHorizontalScroll = 1 << 12;
  int AlwaysInsertMode = 1 << 13;
  /**Read-only+mode*/
  int ReadOnly = 1 << 14;
  /**Password+mode%2C+display+all+characters+as+%27*%27*/
  int Password = 1 << 15;
  /**Disable+undo%7Credo.+Note+that+input+text+owns+the+text+data+while+active%2C+if+you+want+to+provide+your+own+undo%7Credo+stack+you+need+e.g.+to+call+ClearActiveID%28%29.*/
  int NoUndoRedo = 1 << 16;
  /**Allow+0123456789.%2B-*%7CeE+%28Scientific+notation+input%29*/
  int CharsScientific = 1 << 17;
  /**Callback+on+buffer+capacity+changes+request+%28beyond+%27buf_size%27+parameter+value%29%2C+allowing+the+string+to+grow.+Notify+when+the+string+wants+to+be+resized+%28for+string+types+which+hold+a+cache+of+their+Size%29.+You+will+be+provided+a+new+BufSize+in+the+callback+and+NEED+to+honor+it.+%28see+misc%7Ccpp%7Cimgui_stdlib.h+for+an+example+of+using+this%29*/
  int CallbackResize = 1 << 18;
  /**Callback+on+any+edit+%28note+that+InputText%28%29+already+returns+true+on+edit%2C+the+callback+is+useful+mainly+to+manipulate+the+underlying+buffer+while+focus+is+active%29*/
  int CallbackEdit = 1 << 19;
  /**For+internal+use+by+InputTextMultiline%28%29*/
  int Multiline = 1 << 20;
  /**For+internal+use+by+functions+using+InputText%28%29+before+reformatting+data*/
  int NoMarkEdited = 1 << 21;
  enum Type implements Flag {
    None(JImInputTextFlags.None),
    CharsDecimal(JImInputTextFlags.CharsDecimal),
    CharsHexadecimal(JImInputTextFlags.CharsHexadecimal),
    CharsUppercase(JImInputTextFlags.CharsUppercase),
    CharsNoBlank(JImInputTextFlags.CharsNoBlank),
    AutoSelectAll(JImInputTextFlags.AutoSelectAll),
    EnterReturnsTrue(JImInputTextFlags.EnterReturnsTrue),
    CallbackCompletion(JImInputTextFlags.CallbackCompletion),
    CallbackHistory(JImInputTextFlags.CallbackHistory),
    CallbackAlways(JImInputTextFlags.CallbackAlways),
    CallbackCharFilter(JImInputTextFlags.CallbackCharFilter),
    AllowTabInput(JImInputTextFlags.AllowTabInput),
    CtrlEnterForNewLine(JImInputTextFlags.CtrlEnterForNewLine),
    NoHorizontalScroll(JImInputTextFlags.NoHorizontalScroll),
    AlwaysInsertMode(JImInputTextFlags.AlwaysInsertMode),
    ReadOnly(JImInputTextFlags.ReadOnly),
    Password(JImInputTextFlags.Password),
    NoUndoRedo(JImInputTextFlags.NoUndoRedo),
    CharsScientific(JImInputTextFlags.CharsScientific),
    CallbackResize(JImInputTextFlags.CallbackResize),
    CallbackEdit(JImInputTextFlags.CallbackEdit),
    Multiline(JImInputTextFlags.Multiline),
    NoMarkEdited(JImInputTextFlags.NoMarkEdited),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
