package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImSliderFlags {
  int None = 0;
  /**Clamp+value+to+min%7Cmax+bounds+when+input+manually+with+CTRL%2BClick.+By+default+CTRL%2BClick+allows+going+out+of+bounds.*/
  int AlwaysClamp = 1 << 4;
  /**Make+the+widget+logarithmic+%28linear+otherwise%29.+Consider+using+ImGuiSliderFlags_NoRoundToFormat+with+this+if+using+a+format-string+with+small+amount+of+digits.*/
  int Logarithmic = 1 << 5;
  /**Disable+rounding+underlying+value+to+match+precision+of+the+display+format+string+%28e.g.+%25.3f+values+are+rounded+to+those+3+digits%29*/
  int NoRoundToFormat = 1 << 6;
  /**Disable+CTRL%2BClick+or+Enter+key+allowing+to+input+text+directly+into+the+widget*/
  int NoInput = 1 << 7;
  /**%5BInternal%5D+We+treat+using+those+bits+as+being+potentially+a+%27float+power%27+argument+from+the+previous+API+that+has+got+miscast+to+this+enum%2C+and+will+trigger+an+assert+if+needed.*/
  int InvalidMask_ = 0x7000000F;
  enum Type implements Flag {
    None(JImSliderFlags.None),
    AlwaysClamp(JImSliderFlags.AlwaysClamp),
    Logarithmic(JImSliderFlags.Logarithmic),
    NoRoundToFormat(JImSliderFlags.NoRoundToFormat),
    NoInput(JImSliderFlags.NoInput),
    InvalidMask_(JImSliderFlags.InvalidMask_),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
