/*
 * Decompiled with CFR 0.152.
 */
package org.ice1000.jimgui;

import org.ice1000.jimgui.JImDrawList;
import org.ice1000.jimgui.JImFont;
import org.ice1000.jimgui.JImFontAtlas;
import org.ice1000.jimgui.JImGuiDrawListGen;
import org.ice1000.jimgui.JImGuiIO;
import org.ice1000.jimgui.JImSortSpecs;
import org.ice1000.jimgui.JImStr;
import org.ice1000.jimgui.JImStyle;
import org.ice1000.jimgui.JImTextureID;
import org.ice1000.jimgui.JImVec4;
import org.ice1000.jimgui.JImWidgets;
import org.ice1000.jimgui.NativeString;
import org.ice1000.jimgui.cpp.DeallocatableObject;
import org.ice1000.jimgui.util.JImGuiUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JImGui
extends JImWidgets
implements DeallocatableObject {
    @NotNull
    public static final String DEFAULT_TITLE = "ImGui window created by JImGui";
    long nativeObjectPtr;
    @NotNull
    private JImVec4 background;
    @Nullable
    private JImGuiIO io;

    public JImGui() {
        this(1280, 720);
    }

    public JImGui(@NotNull String title) {
        this(1280, 720, title);
    }

    public JImGui(int width, int height, @NotNull String title) {
        this(JImGui.allocateNativeObjects(width, height, 0L, JImGuiUtil.getBytes(title), 0L));
        JImGui.setupImguiSpecificObjects(this.nativeObjectPtr, 0L);
    }

    public JImGui(int width, int height) {
        this(width, height, DEFAULT_TITLE);
    }

    public JImGui(int width, int height, @NotNull JImFontAtlas fontAtlas, @NotNull String title) {
        this(width, height, fontAtlas, title, 0L);
    }

    public JImGui(int width, int height, @NotNull JImFontAtlas fontAtlas, @NotNull String title, long anotherWindow) {
        this(JImGui.allocateNativeObjects(width, height, fontAtlas.nativeObjectPtr, JImGuiUtil.getBytes(title), anotherWindow));
        JImGui.setupImguiSpecificObjects(this.nativeObjectPtr, fontAtlas.nativeObjectPtr);
    }

    private JImGui(long nativeObjectPtr) {
        this.nativeObjectPtr = nativeObjectPtr;
        if (nativeObjectPtr == 0L) {
            System.err.println("Unknown error has happened during initialization!");
            System.exit(1);
        }
        this.io = new JImGuiIO();
        this.background = new JImVec4(0.4f, 0.55f, 0.6f, 1.0f);
    }

    @NotNull
    public static JImGui fromExistingPointer(long nativeObjectPtr, @NotNull JImFontAtlas fontAtlas) {
        JImGui imGui = new JImGui(nativeObjectPtr);
        JImGui.setupImguiSpecificObjects(nativeObjectPtr, fontAtlas.nativeObjectPtr);
        return imGui;
    }

    @NotNull
    public static JImGui fromExistingPointer(long nativeObjectPtr) {
        JImGui imGui = new JImGui(nativeObjectPtr);
        JImGui.setupImguiSpecificObjects(nativeObjectPtr, 0L);
        return imGui;
    }

    @Override
    public final void deallocateNativeObject() {
        this.background.close();
        JImGui.deallocateNativeObjects(this.nativeObjectPtr);
        this.io = null;
    }

    @Override
    public final void close() {
        this.deallocateNativeObject();
        JImGui.deallocateGuiFramework(this.nativeObjectPtr);
    }

    @Contract
    public void setBackground(@NotNull JImVec4 background) {
        if (this.background == background) {
            return;
        }
        this.background.close();
        this.background = background;
    }

    @Contract(pure=true)
    @Nullable
    public JImGuiIO findIO() {
        return this.io;
    }

    @Contract(pure=true)
    @NotNull
    public JImGuiIO getIO() {
        return null == this.io ? (JImGuiIO)this.alreadyDisposed() : this.io;
    }

    @Contract(pure=true)
    @NotNull
    public JImStyle getStyle() {
        JImStyle style = this.findStyle();
        return null == style ? (JImStyle)this.alreadyDisposed() : style;
    }

    @Contract(pure=true)
    @NotNull
    public JImFont getFont() {
        JImFont font = this.findFont();
        return null == font ? (JImFont)this.alreadyDisposed() : font;
    }

    @Contract(pure=true)
    @Nullable
    public JImDrawList findWindowDrawList() {
        long drawListNativeObjectPtr = JImGui.getWindowDrawListNativeObjectPtr();
        return drawListNativeObjectPtr == 0L ? null : new JImDrawList(drawListNativeObjectPtr);
    }

    @Contract(pure=true)
    @NotNull
    public JImSortSpecs tableGetSortSpecs() {
        return new JImSortSpecs(JImGui.getTableSortSpecsNativeObjectPtr());
    }

    @Contract(pure=true)
    @NotNull
    public JImDrawList getWindowDrawList() {
        @Nullable JImDrawList windowDrawList = this.findWindowDrawList();
        return null == windowDrawList ? (JImDrawList)this.alreadyDisposed() : windowDrawList;
    }

    @Contract(pure=true)
    @Nullable
    public JImDrawList findForegroundDrawList() {
        long drawListNativeObjectPtr = JImGui.getForegroundDrawListNativeObjectPtr();
        return drawListNativeObjectPtr == 0L ? null : new JImDrawList(drawListNativeObjectPtr);
    }

    @Contract(pure=true)
    @NotNull
    public JImDrawList getForegroundDrawList() {
        @Nullable JImDrawList windowDrawList = this.findForegroundDrawList();
        return null == windowDrawList ? (JImDrawList)this.alreadyDisposed() : windowDrawList;
    }

    @Contract(pure=true)
    @Nullable
    public JImStyle findStyle() {
        long styleNativeObjectPtr = JImGui.getStyleNativeObjectPtr();
        return styleNativeObjectPtr == 0L ? null : new JImStyle(styleNativeObjectPtr);
    }

    @Contract(pure=true)
    @Nullable
    public JImFont findFont() {
        long fontNativeObjectPtr = JImGui.getFontNativeObjectPtr();
        return fontNativeObjectPtr == 0L ? null : new JImFont(fontNativeObjectPtr);
    }

    @Contract(pure=true)
    public boolean isDisposed() {
        return this.io == null;
    }

    @Contract(pure=true)
    @NotNull
    public JImVec4 getBackground() {
        return this.background;
    }

    public float getPlatformWindowSizeX() {
        return JImGui.getPlatformWindowSizeX(this.nativeObjectPtr);
    }

    public float getPlatformWindowSizeY() {
        return JImGui.getPlatformWindowSizeY(this.nativeObjectPtr);
    }

    public float getPlatformWindowPosX() {
        return JImGui.getPlatformWindowPosX(this.nativeObjectPtr);
    }

    public float getPlatformWindowPosY() {
        return JImGui.getPlatformWindowPosY(this.nativeObjectPtr);
    }

    public void setPlatformWindowSize(float newX, float newY) {
        JImGui.setPlatformWindowSize(this.nativeObjectPtr, newX, newY);
    }

    public void setPlatformWindowPos(float newX, float newY) {
        JImGui.setPlatformWindowPos(this.nativeObjectPtr, newX, newY);
    }

    public static native void pushID(int var0);

    public static native float getWindowPosX();

    public static native float getWindowPosY();

    public static native float getContentRegionMaxX();

    public static native float getContentRegionMaxY();

    public static native float getContentRegionAvailX();

    public static native float getContentRegionAvailY();

    public static native float getWindowContentRegionMinX();

    public static native float getWindowContentRegionMinY();

    public static native float getWindowContentRegionMaxX();

    public static native float getWindowContentRegionMaxY();

    public static native float getFontTexUvWhitePixelX();

    public static native float getFontTexUvWhitePixelY();

    public static native float getItemRectMinX();

    public static native float getItemRectMinY();

    public static native float getItemRectMaxX();

    public static native float getItemRectMaxY();

    public static native float getItemRectSizeX();

    public static native float getItemRectSizeY();

    public static native float getMousePosOnOpeningCurrentPopupX();

    public static native float getMousePosOnOpeningCurrentPopupY();

    @Contract(pure=true)
    public boolean windowShouldClose() {
        return JImGui.windowShouldClose(this.nativeObjectPtr);
    }

    @Contract
    public void render() {
        JImGui.render(this.nativeObjectPtr, this.background.nativeObjectPtr);
    }

    @Contract
    public void setWindowTitle(@NotNull String title) {
        JImGui.setWindowTitle(this.nativeObjectPtr, JImGuiUtil.getBytes(title));
    }

    @Contract
    public void setWindowTitle(@NotNull JImStr title) {
        JImGui.setWindowTitle(this.nativeObjectPtr, title.bytes);
    }

    @Contract
    public void setWindowTitle(@NotNull NativeString title) {
        JImGui.setWindowTitlePtr(this.nativeObjectPtr, title.nativeObjectPtr);
    }

    @Contract
    public void initNewFrame() {
        JImGui.initNewFrame(this.nativeObjectPtr);
    }

    public void loadIniSettingsFromMemory(@NotNull String data) {
        JImGui.loadIniSettingsFromMemory(JImGuiUtil.getBytes(data));
    }

    @NotNull
    public String saveIniSettingsToMemory() {
        return new String(JImGui.saveIniSettingsToMemory0());
    }

    @NotNull
    public String getClipboardText() {
        return new String(JImGui.getClipboardText0());
    }

    public void windowDrawListAddImage(@NotNull JImTextureID id, float aX, float aY, float bX, float bY, float uvAX, float uvAY, float uvBX, float uvBY, int color) {
        long ptr = JImGui.getWindowDrawListNativeObjectPtr();
        JImGuiDrawListGen.addImage(id.nativeObjectPtr, aX, aY, bX, bY, uvAX, uvAY, uvBX, uvBY, color, ptr);
    }

    public void windowDrawListAddLine(float aX, float aY, float bX, float bY, int u32Color, float thickness) {
        JImGuiDrawListGen.addLine(aX, aY, bX, bY, u32Color, thickness, JImGui.getWindowDrawListNativeObjectPtr());
    }

    public void windowDrawListAddLine(float aX, float aY, float bX, float bY, int u32Color) {
        this.windowDrawListAddLine(aX, aY, bX, bY, u32Color, 1.0f);
    }

    public static void setTimeLocale(@NotNull String locale) {
        JImGui.setTimeLocale(JImGuiUtil.getBytes(locale));
    }

    public static void setTimeLocale(@NotNull JImStr locale) {
        JImGui.setTimeLocale(locale.bytes);
    }

    private static native long allocateNativeObjects(int var0, int var1, long var2, byte @NotNull [] var4, long var5);

    private static native void setTimeLocale(byte @NotNull [] var0);

    protected static native void setupImguiSpecificObjects(long var0, long var2);

    private static native void deallocateNativeObjects(long var0);

    private static native void deallocateGuiFramework(long var0);

    private static native void initNewFrame(long var0);

    private static native long getFontNativeObjectPtr();

    private static native long getStyleNativeObjectPtr();

    private static native long getWindowDrawListNativeObjectPtr();

    private static native long getTableSortSpecsNativeObjectPtr();

    private static native long getForegroundDrawListNativeObjectPtr();

    private static native boolean windowShouldClose(long var0);

    private static native void render(long var0, long var2);

    private static native void setWindowTitle(long var0, byte @NotNull [] var2);

    private static native void setWindowTitlePtr(long var0, long var2);

    private static native float getPlatformWindowSizeX(long var0);

    private static native float getPlatformWindowSizeY(long var0);

    private static native float getPlatformWindowPosX(long var0);

    private static native float getPlatformWindowPosY(long var0);

    private static native void setPlatformWindowSize(long var0, float var2, float var3);

    private static native void setPlatformWindowPos(long var0, float var2, float var3);

    private static native void loadIniSettingsFromMemory(byte @NotNull [] var0);

    private static native byte @NotNull [] saveIniSettingsToMemory0();

    private static native byte @NotNull [] getClipboardText0();
}

