/*
 * Decompiled with CFR 0.152.
 */
package dlparty;

import org.ice1000.jimgui.JImDrawList;
import org.ice1000.jimgui.JImGui;
import org.ice1000.jimgui.JImGuiIO;
import org.ice1000.jimgui.JImStr;
import org.ice1000.jimgui.util.ColorUtil;
import org.ice1000.jimgui.util.JniLoader;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface TestBed {
    public static final int sizeX = 320;
    public static final int sizeY = 180;

    public void fx(@NotNull JImDrawList var1, ImVec2 var2, ImVec2 var3, ImVec2 var4, ImVec4 var5, float var6);

    default public float sin(float x) {
        return (float)StrictMath.sin(x);
    }

    default public float cos(float x) {
        return (float)StrictMath.cos(x);
    }

    default public float pow(float x, float y) {
        return (float)StrictMath.pow(x, y);
    }

    default public int IM_COL32(int red, int green, int blue, int alpha) {
        return ColorUtil.colorU32((int)red, (int)green, (int)blue, (int)alpha);
    }

    default public int IM_COL32(float red, float green, float blue, float alpha) {
        return ColorUtil.colorU32((int)((int)red), (int)((int)green), (int)((int)blue), (int)((int)alpha));
    }

    default public int IM_COL32(double red, double green, double blue, double alpha) {
        return ColorUtil.colorU32((int)((int)red), (int)((int)green), (int)((int)blue), (int)((int)alpha));
    }

    default public ImVec2 ImClamp(ImVec2 v, ImVec2 mn, ImVec2 mx) {
        return new ImVec2(v.x < mn.x ? mn.x : Math.min(v.x, mx.x), v.y < mn.y ? mn.y : Math.min(v.y, mx.y));
    }

    default public float ImLerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    default public float ImClamp(float v, float mn, float mx) {
        return v < mn ? mn : Math.min(v, mx);
    }

    default public ImVec2 ImLerp(ImVec2 a, ImVec2 b, float t) {
        return new ImVec2(a.x + (b.x - a.x) * t, a.y + (b.y - a.y) * t);
    }

    default public ImVec2 ImLerp(ImVec2 a, ImVec2 b, ImVec2 t) {
        return new ImVec2(a.x + (b.x - a.x) * t.x, a.y + (b.y - a.y) * t.y);
    }

    default public ImVec4 ImLerp(ImVec4 a, ImVec4 b, float t) {
        return new ImVec4(a.x + (b.x - a.x) * t, a.y + (b.y - a.y) * t, a.z + (b.z - a.z) * t, a.w + (b.w - a.w) * t);
    }

    public static void launch(TestBed bed) {
        bed.launch();
    }

    default public void launch() {
        JniLoader.load();
        try (JImGui imGui = new JImGui(400, 300, "FX");){
            JImStr str = new JImStr("FX");
            while (!imGui.windowShouldClose()) {
                imGui.initNewFrame();
                imGui.setNextWindowPos(0.0f, 0.0f);
                this.testBed(imGui, str);
                imGui.render();
            }
        }
    }

    default public void testBed(@NotNull JImGui imGui, @NotNull JImStr title) {
        if (imGui.begin(title, 2)) {
            JImGuiIO io = imGui.getIO();
            JImDrawList drawList = imGui.getWindowDrawList();
            imGui.invisibleButton("canvas", 320.0f, 180.0f);
            float minX = imGui.getItemRectMinX();
            float minY = imGui.getItemRectMinY();
            float maxX = imGui.getItemRectMaxX();
            float maxY = imGui.getItemRectMaxY();
            drawList.pushClipRect(minX, minY, maxX, maxY);
            ImVec4 mouse = new ImVec4((io.getMousePosX() - minX) / 320.0f, (io.getMousePosY() - minY) / 180.0f, JImGuiIO.mouseDownDurationAt((int)0), JImGuiIO.mouseDownDurationAt((int)1));
            this.fx(drawList, new ImVec2(minX, minY), new ImVec2(maxX, maxY), new ImVec2(320.0f, 180.0f), mouse, imGui.getTime());
            imGui.end();
        }
    }

    public static final class ImVec2 {
        public float x;
        public float y;

        @Contract(pure=true)
        public ImVec2(@NotNull ImVec2 vec2) {
            this(vec2.x, vec2.y);
        }

        @Contract(pure=true)
        public ImVec2(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public ImVec2 add(ImVec2 o) {
            return new ImVec2(this.x + o.x, this.y + o.y);
        }

        public ImVec2 sub(ImVec2 o) {
            return new ImVec2(this.x - o.x, this.y - o.y);
        }

        public ImVec2 mul(float i) {
            return new ImVec2(this.x * i, this.y * i);
        }

        public ImVec2 div(float i) {
            return new ImVec2(this.x / 2.0f, this.y / 2.0f);
        }
    }

    public static final class ImVec4 {
        public float x;
        public float y;
        public float z;
        public float w;

        @Contract(pure=true)
        public ImVec4(float x, float y, float z, float w) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }
    }

    public static final class Pair<A, B> {
        public A first;
        public B second;

        public Pair(A first, B second) {
            this.first = first;
            this.second = second;
        }
    }
}

