/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.ajax;

import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.FacesBehaviorRenderer;
import org.icefaces.ace.JSONBuilder;
import org.icefaces.ace.api.IceClientBehaviorHolder;
import org.icefaces.mobi.component.ajax.AjaxBehavior;
import org.icefaces.mobi.utils.Utils;

@FacesBehaviorRenderer(rendererType="org.icefaces.mobi.component.AjaxBehaviorRenderer")
public class AjaxBehaviorRenderer
extends ClientBehaviorRenderer {
    public void decode(FacesContext context, UIComponent component, ClientBehavior behavior) {
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (!ajaxBehavior.isDisabled()) {
            AjaxBehaviorEvent event = new AjaxBehaviorEvent(component, (Behavior)behavior);
            PhaseId phaseId = this.isImmediate(component, ajaxBehavior) ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION;
            event.setPhaseId(phaseId);
            component.queueEvent((FacesEvent)event);
        }
    }

    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled()) {
            return null;
        }
        FacesContext fc = behaviorContext.getFacesContext();
        UIComponent component = behaviorContext.getComponent();
        String clientId = component.getClientId(fc);
        String source = behaviorContext.getSourceId();
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("mobi.AjaxRequest");
        jb.beginMap().entry("source", source);
        String execute = null;
        if (ajaxBehavior.getExecute() != null) {
            execute = ajaxBehavior.getExecute();
        } else if (component instanceof IceClientBehaviorHolder) {
            execute = ((IceClientBehaviorHolder)component).getDefaultExecute(behaviorContext.getEventName());
        }
        if (execute == null || "".equals(execute)) {
            jb.entry("execute", clientId);
        } else {
            jb.entry("execute", Utils.findClientIds(fc, component, execute));
        }
        String render = null;
        if (ajaxBehavior.getRender() != null) {
            render = ajaxBehavior.getRender();
        } else {
            if (component instanceof IceClientBehaviorHolder) {
                render = ((IceClientBehaviorHolder)component).getDefaultRender(behaviorContext.getEventName());
            }
            if (render == null || "".equals(render)) {
                render = "@all";
            }
        }
        jb.entry("render", Utils.findClientIds(fc, component, render));
        jb.entry("event", behaviorContext.getEventName());
        if (ajaxBehavior.getOnStart() != null) {
            jb.entry("onstart", "function(xhr){" + ajaxBehavior.getOnStart() + ";}", true);
        }
        if (ajaxBehavior.getOnError() != null) {
            jb.entry("onerror", "function(xhr, status, error){" + ajaxBehavior.getOnError() + ";}", true);
        }
        if (ajaxBehavior.getOnSuccess() != null) {
            jb.entry("onsuccess", "function(data, status, xhr, args){" + ajaxBehavior.getOnSuccess() + ";}", true);
        }
        if (ajaxBehavior.getOnComplete() != null) {
            jb.entry("oncomplete", "function(xhr, status, args){" + ajaxBehavior.getOnComplete() + ";}", true);
        }
        jb.entry("params", "arguments[1]", true);
        jb.endMap().endFunction();
        return jb.toString();
    }

    private boolean isImmediate(UIComponent component, AjaxBehavior ajaxBehavior) {
        boolean immediate = false;
        if (ajaxBehavior.isImmediateSet()) {
            immediate = ajaxBehavior.isImmediate();
        } else if (component instanceof EditableValueHolder) {
            immediate = ((EditableValueHolder)component).isImmediate();
        } else if (component instanceof ActionSource) {
            immediate = ((ActionSource)component).isImmediate();
        }
        return immediate;
    }
}

