/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.audio;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.component.audio.Audio;
import org.icefaces.mobi.renderkit.BaseResourceRenderer;
import org.icefaces.mobi.utils.PassThruAttributeWriter;
import org.icefaces.mobi.utils.Utils;

public class AudioRenderer
extends BaseResourceRenderer {
    private static Logger log = Logger.getLogger(AudioRenderer.class.getName());

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String srcAttribute;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        Audio audio = (Audio)uiComponent;
        Map contextMap = facesContext.getAttributes();
        String deviceType = "iphone";
        if (null != contextMap.get("device")) {
            deviceType = contextMap.get("device").toString();
        }
        boolean disabled = audio.isDisabled();
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, audio.getSpanPassThruAttributes());
        StringBuilder styleClass = new StringBuilder("mobi-video");
        if (audio.getStyleClass() != null) {
            styleClass.append(" ").append(audio.getStyleClass());
        }
        writer.writeAttribute("class", (Object)styleClass.toString(), null);
        if (!deviceType.equals("bberry")) {
            writer.startElement("audio", uiComponent);
            if (disabled) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            srcAttribute = this.writeCommonAttributes(writer, audio, facesContext, clientId);
            writer.endElement("audio");
        } else {
            writer.startElement("video", uiComponent);
            srcAttribute = this.writeCommonAttributes(writer, audio, facesContext, clientId);
            writer.writeAttribute("autoplay", (Object)"true", null);
            if (disabled) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            writer.writeAttribute("height", (Object)"20", null);
            writer.writeAttribute("width", (Object)"100", null);
            writer.endElement("video");
        }
        if (!Utils.isIOS() && audio.getLinkLabel() != null) {
            writer.startElement("br", uiComponent);
            writer.endElement("br");
            writer.startElement("a", uiComponent);
            writer.writeAttribute("href", (Object)srcAttribute, null);
            writer.writeText((Object)audio.getLinkLabel(), null);
            writer.endElement("a");
        }
    }

    private String writeCommonAttributes(ResponseWriter writer, Audio audio, FacesContext facesContext, String clientId) throws IOException {
        String name;
        String mimeType;
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, (UIComponent)audio, audio.getAttributesNames());
        if (audio.isControls()) {
            writer.writeAttribute("controls", (Object)"controls", null);
        }
        if (null == (mimeType = audio.getType())) {
            mimeType = "audio/mpeg";
        }
        writer.writeAttribute("type", (Object)mimeType, null);
        String scope = audio.getScope().toLowerCase().trim();
        if (!(scope.equals("flash") || scope.equals("window") || scope.equals("application") || scope.equals("request") || scope.equals("view"))) {
            scope = "session";
        }
        if (null == (name = audio.getName()) || name.equals("")) {
            name = "audio" + clientId;
        }
        Object audioObject = audio.getValue();
        String srcAttribute = "null";
        if (null != audioObject) {
            srcAttribute = this.processSrcAttribute(facesContext, audioObject, name, mimeType, scope, audio.getUrl());
        }
        writer.writeAttribute("src", (Object)srcAttribute, null);
        return srcAttribute;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("span");
    }
}

