/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.button;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.icefaces.mobi.component.button.CommandButton;
import org.icefaces.mobi.renderkit.CoreRenderer;
import org.icefaces.mobi.utils.Utils;

public class CommandButtonRenderer
extends CoreRenderer {
    private static Logger logger = Logger.getLogger(CommandButtonRenderer.class.getName());
    List<UIParameter> uiParamChildren;

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        CommandButton commandButton = (CommandButton)uiComponent;
        String source = String.valueOf(requestParameterMap.get("ice.event.captured"));
        String clientId = commandButton.getClientId();
        if (clientId.equals(source)) {
            try {
                if (!commandButton.isDisabled()) {
                    uiComponent.queueEvent((FacesEvent)new ActionEvent(uiComponent));
                }
            }
            catch (Exception e) {
                logger.warning("Error queuing CommandButton event");
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String type;
        String styleClass;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        CommandButton commandButton = (CommandButton)uiComponent;
        this.uiParamChildren = Utils.captureParameters((UIComponent)commandButton);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        StringBuilder baseClass = new StringBuilder("mobi-button");
        String buttonType = commandButton.getButtonType();
        if ("default".equals(buttonType)) {
            baseClass.append(" mobi-button-default");
        } else if ("back".equals(buttonType)) {
            baseClass.append(" mobi-button-back");
        } else if ("attention".equals(buttonType)) {
            baseClass.append(" mobi-button-attention");
        } else if ("important".equals(buttonType)) {
            baseClass.append(" mobi-button-important");
        } else if (logger.isLoggable(Level.FINER)) {
            baseClass.append(" mobi-button-default");
        }
        if (commandButton.isSelected()) {
            baseClass.append(" mobi-button-selected");
        }
        if (commandButton.isDisabled()) {
            baseClass.append(" ").append("mobi-button-dis");
        }
        if ((styleClass = commandButton.getStyleClass()) != null) {
            baseClass.append(" ").append(styleClass);
        }
        writer.writeAttribute("class", (Object)baseClass.toString(), null);
        String style = commandButton.getStyle();
        if (style != null && style.trim().length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if ((type = commandButton.getType()) == null) {
            type = "button";
        }
        writer.writeAttribute("type", (Object)type, null);
        writer.writeAttribute("name", (Object)clientId, null);
        String value = type;
        Object oVal = commandButton.getValue();
        if (null != oVal) {
            value = oVal.toString();
        }
        writer.writeAttribute("value", (Object)value, "value");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ClientBehaviorHolder cbh;
        boolean hasBehaviors;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        CommandButton commandButton = (CommandButton)uiComponent;
        boolean singleSubmit = commandButton.isSingleSubmit();
        String params = "'" + clientId + "'";
        if (this.uiParamChildren != null) {
            params = params + "," + Utils.asParameterString(this.uiParamChildren);
        }
        boolean bl = hasBehaviors = !(cbh = (ClientBehaviorHolder)uiComponent).getClientBehaviors().isEmpty();
        if (commandButton.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        } else {
            StringBuilder builder = new StringBuilder(255);
            if (hasBehaviors) {
                String cbhCall = this.buildAjaxRequest(facesContext, cbh, commandButton.getDefaultEventName());
                builder.append(cbhCall);
            } else if (singleSubmit) {
                builder.append("ice.se(event, ").append(params).append(");");
            } else {
                builder.append("ice.s(event, ").append(params).append(");");
            }
            writer.writeAttribute("onclick", (Object)builder.toString(), null);
        }
        writer.endElement("input");
    }
}

