/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.microphone;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.render.Renderer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.icefaces.impl.application.AuxUploadResourceHandler;
import org.icefaces.mobi.component.microphone.Microphone;
import org.icefaces.mobi.utils.Utils;
import org.icefaces.util.EnvUtils;

public class MicrophoneRenderer
extends Renderer {
    private static Logger logger = Logger.getLogger(MicrophoneRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Microphone microphone = (Microphone)uiComponent;
        String clientId = microphone.getClientId();
        if (microphone.isDisabled()) {
            return;
        }
        try {
            HashMap map = new HashMap();
            boolean valid = this.extractAudio(facesContext, map, clientId);
            if (valid && map != null) {
                microphone.setValue(map);
                uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, null, map));
            }
        }
        catch (Exception e) {
            logger.warning("Exception decoding audio stream: " + e);
        }
    }

    public boolean extractAudio(FacesContext facesContext, Map map, String clientId) throws IOException {
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        boolean isValid = false;
        String partUploadName = clientId;
        if (EnvUtils.isEnhancedBrowser((FacesContext)facesContext)) {
            partUploadName = partUploadName + "_mic-file";
        }
        if (EnvUtils.isAuxUploadBrowser((FacesContext)facesContext)) {
            partUploadName = partUploadName + "_mic-file";
        }
        Part part = null;
        try {
            part = request.getPart(partUploadName);
        }
        catch (ServletException e) {
            // empty catch block
        }
        if (null == part) {
            Map auxMap = AuxUploadResourceHandler.getAuxRequestMap();
            part = (Part)auxMap.get(partUploadName);
        }
        if (part != null) {
            String contentType = part.getContentType();
            String fileName = UUID.randomUUID().toString();
            isValid = part.getSize() > 0L;
            fileName = "audio/wav".equals(contentType) || "audio/x-wav".equals(contentType) ? fileName + ".wav" : (contentType.endsWith("mp4") ? fileName + ".mp4" : ("audio/x-m4a".equals(contentType) ? fileName + ".m4a" : ("audio/mpeg".equals(contentType) ? fileName + ".mp3" : ("audio/amr".equals(contentType) ? fileName + ".amr" : fileName + ".oth"))));
            Utils.createMapOfFile(map, request, part, fileName, contentType, facesContext);
        }
        return isValid;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        Microphone microphone = (Microphone)uiComponent;
        boolean disabled = microphone.isDisabled();
        boolean isEnhanced = EnvUtils.isEnhancedBrowser((FacesContext)facesContext);
        boolean isAuxUpload = EnvUtils.isAuxUploadBrowser((FacesContext)facesContext);
        if (!isEnhanced && !isAuxUpload) {
            writer.startElement("span", uiComponent);
            writer.startElement("input", uiComponent);
            writer.writeAttribute("type", (Object)"file", null);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("name", (Object)clientId, null);
            writer.endElement("input");
            return;
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        int maxtime = microphone.getMaxtime();
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("id", (Object)(clientId + "_mic"), null);
        Utils.writeConcatenatedStyleClasses(writer, "mobi-button mobi-button-default", microphone.getStyleClass());
        writer.writeAttribute("style", (Object)microphone.getStyle(), "style");
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        String script = isAuxUpload ? Utils.getICEmobileSXScript("microphone", clientId + "_mic") : this.writeJSCall(clientId, maxtime).toString();
        writer.writeAttribute("onclick", (Object)script, null);
        writer.writeAttribute("value", (Object)"record", null);
        writer.endElement("input");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        Microphone microphone = (Microphone)uiComponent;
        writer.endElement("span");
    }

    private StringBuilder writeJSCall(String clientId, int maxtime) {
        StringBuilder script = new StringBuilder();
        script.append("if(this.value=='stop'){this.className='mobi-button mobi-button-default'; this.value='record';}");
        script.append("else{this.className='mobi-button mobi-button-default mobi-mic-stop'; this.value='stop';}");
        if (maxtime != Integer.MIN_VALUE) {
            script.append("ice.microphone( '").append(clientId).append("_mic','maxtime=").append(maxtime).append("');");
        } else {
            script.append("ice.microphone( '").append(clientId).append("_mic');");
        }
        return script;
    }
}

