/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.thumbnail;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.icefaces.mobi.component.thumbnail.Thumbnail;
import org.icefaces.mobi.utils.Utils;

public class ThumbnailRenderer
extends Renderer {
    private static final Logger logger = Logger.getLogger(ThumbnailRenderer.class.toString());

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Thumbnail thumbnail = (Thumbnail)uiComponent;
        String cameraId = thumbnail.getFor();
        if (cameraId == null && (facesContext.isProjectStage(ProjectStage.Development) || logger.isLoggable(Level.FINER))) {
            logger.warning("'for' attribute cannot be null");
        }
        UIComponent cameraComp = thumbnail.findComponent(cameraId);
        String thumbId = cameraId + "-thumb";
        if (null != cameraComp) {
            thumbId = cameraComp.getClientId() + "-thumb";
        } else if (facesContext.isProjectStage(ProjectStage.Development) || logger.isLoggable(Level.FINER)) {
            logger.finer(" Cannot find camera component with id=" + cameraId);
        }
        writer.startElement("span", uiComponent);
        Utils.writeConcatenatedStyleClasses(writer, "mobi-thumb", thumbnail.getStyleClass());
        writer.writeAttribute("style", (Object)thumbnail.getStyle(), "style");
        writer.writeAttribute("id", (Object)"span-thumb", null);
        writer.startElement("img", uiComponent);
        writer.writeAttribute("id", (Object)thumbId, null);
        writer.writeAttribute("width", (Object)"64", null);
        writer.writeAttribute("height", (Object)"64", null);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("span");
        writer.endElement("img");
    }
}

