/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.timespinner;

import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.icefaces.mobi.component.timespinner.TimeSpinner;
import org.icefaces.mobi.renderkit.BaseInputRenderer;
import org.icefaces.mobi.utils.PassThruAttributeWriter;
import org.icefaces.mobi.utils.Utils;

public class TimeSpinnerRenderer
extends BaseInputRenderer {
    private static Logger logger = Logger.getLogger(TimeSpinnerRenderer.class.getName());
    private static final String JS_NAME = "timespinner.js";
    private static final String JS_MIN_NAME = "timespinner-min.js";
    private static final String JS_LIBRARY = "org.icefaces.component.timespinner";

    public void decode(FacesContext context, UIComponent component) {
        TimeSpinner timeSpinner = (TimeSpinner)component;
        String clientId = timeSpinner.getClientId(context);
        if (timeSpinner.isDisabled()) {
            return;
        }
        String inputField = clientId + "_input";
        if (this.shouldUseNative(timeSpinner)) {
            String inputValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
            String twelveHrString = this.convertToTwelve(inputValue);
            if (null != twelveHrString) {
                timeSpinner.setSubmittedValue(twelveHrString);
            }
        } else {
            String inputValue = (String)context.getExternalContext().getRequestParameterMap().get(inputField);
            if (!this.isValueBlank(inputValue)) {
                timeSpinner.setSubmittedValue(inputValue);
            }
        }
        this.decodeBehaviors(context, (UIComponent)timeSpinner);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TimeSpinner spinner = (TimeSpinner)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = spinner.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)component;
        boolean hasBehaviors = !cbh.getClientBehaviors().isEmpty();
        boolean singleSubmit = spinner.isSingleSubmit();
        String initialValue = TimeSpinnerRenderer.getStringValueToRender(context, component);
        if (this.shouldUseNative(spinner)) {
            writer.startElement("input", component);
            writer.writeAttribute("type", (Object)"time", "type");
            writer.writeAttribute("id", (Object)clientId, "id");
            writer.writeAttribute("name", (Object)clientId, "name");
            boolean disabled = spinner.isDisabled();
            boolean readonly = spinner.isReadonly();
            String defaultPattern = "HH:mm";
            SimpleDateFormat df2 = new SimpleDateFormat(defaultPattern);
            if (this.isValueBlank(initialValue)) {
                Date aDate = new Date();
                writer.writeAttribute("value", (Object)df2.format(aDate), "value");
            } else {
                writer.writeAttribute("value", (Object)initialValue, "value");
            }
            if (disabled) {
                writer.writeAttribute("disabled", (Object)component, "disabled");
            }
            if (readonly) {
                writer.writeAttribute("readonly", (Object)component, "readonly");
            }
            if (!readonly && !disabled && hasBehaviors) {
                String event = spinner.getDefaultEventName(context);
                String cbhCall = this.buildAjaxRequest(context, cbh, event);
                writer.writeAttribute("onblur", (Object)cbhCall, null);
            } else if (singleSubmit) {
                writer.writeAttribute("onblur", (Object)"ice.se(event, this);", null);
            }
            writer.endElement("input");
        } else {
            Map viewContextMap = context.getViewRoot().getViewMap();
            if (!viewContextMap.containsKey(JS_NAME)) {
                String jsFname = JS_NAME;
                if (context.isProjectStage(ProjectStage.Production)) {
                    jsFname = JS_MIN_NAME;
                }
                Resource jsFile = context.getApplication().getResourceHandler().createResource(jsFname, JS_LIBRARY);
                String src = jsFile.getRequestPath();
                writer.startElement("script", component);
                writer.writeAttribute("text", (Object)"text/javascript", null);
                writer.writeAttribute("src", (Object)src, null);
                writer.endElement("script");
                viewContextMap.put(JS_NAME, "true");
            }
            String value = this.encodeValue(spinner, initialValue);
            this.encodeMarkup(context, component, value, hasBehaviors);
            this.encodeScript(context, component);
        }
    }

    protected void encodeMarkup(FacesContext context, UIComponent uiComponent, String value, boolean hasBehaviors) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TimeSpinner timeEntry = (TimeSpinner)uiComponent;
        String clientId = timeEntry.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        String eventStr = "onclick";
        if (Utils.isTouchEventEnabled(context)) {
            eventStr = "ontouchstart";
        }
        boolean popup = true;
        StringBuilder popupBaseClass = new StringBuilder("mobi-time-container");
        if (popup) {
            popupBaseClass.append("-hide");
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("class", (Object)"mobi-time-wrapper", "class");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_input"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_input"), "name");
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, timeEntry.getCommonAttributeNames());
        StringBuilder classNames = new StringBuilder("mobi-input-text").append(" ").append(timeEntry.getStyleClass());
        writer.writeAttribute("class", (Object)classNames.toString(), null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.writeAttribute("type", (Object)"text", "type");
        if (timeEntry.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (timeEntry.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.endElement("span");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"", null);
        writer.writeAttribute("class", (Object)"mobi-time-popup-btn", null);
        if (timeEntry.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        } else {
            writer.writeAttribute("onclick", (Object)("mobi.timespinner.toggle('" + clientId + "');"), null);
        }
        writer.endElement("input");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_bg"), "id");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_popup"), "id");
        writer.writeAttribute("class", (Object)popupBaseClass.toString(), null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_title"), "id");
        writer.writeAttribute("class", (Object)"mobi-time-title-container", null);
        writer.write(value);
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-container", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-incr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-incr", null);
        writer.writeAttribute("id", (Object)(clientId + "_hrUpBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.hrUp('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_hrInt"), null);
        writer.write(String.valueOf(timeEntry.getHourInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-decr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-decr", null);
        writer.writeAttribute("id", (Object)(clientId + "_hrDnBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.hrDn('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-incr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-incr", null);
        writer.writeAttribute("id", (Object)(clientId + "_mUpBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.mUp('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_mInt"), null);
        writer.write(String.valueOf(timeEntry.getMinuteInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-decr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-decr", null);
        writer.writeAttribute("id", (Object)(clientId + "_mDnBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.mDn('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-incr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-incr", null);
        writer.writeAttribute("id", (Object)(clientId + "_ampmUpBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.ampmToggle('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_ampmInt"), null);
        String ampm = "AM";
        if (timeEntry.getAmpm() > 0) {
            ampm = "PM";
        }
        writer.write(ampm);
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-decr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-decr", null);
        writer.writeAttribute("id", (Object)(clientId + "_ampmBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.ampmToggle('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-submit-container", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button mobi-button-default", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Set", null);
        boolean singleSubmit = timeEntry.isSingleSubmit();
        StringBuilder builder = new StringBuilder(255);
        builder.append("mobi.timespinner.select('").append(clientId).append("',{ event: event,");
        builder.append("singleSubmit: ").append(singleSubmit);
        if (hasBehaviors) {
            String behaviors = this.encodeClientBehaviors(context, cbh, "change").toString();
            behaviors = behaviors.replace("\"", "'");
            builder.append(behaviors);
        }
        builder.append("});");
        String jsCall = builder.toString();
        if (!timeEntry.isDisabled() || !timeEntry.isReadonly()) {
            writer.writeAttribute("onclick", (Object)jsCall, null);
        }
        writer.endElement("input");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button mobi-button-default", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Cancel", null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.close('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TimeSpinner spinner = (TimeSpinner)uiComponent;
        String clientId = spinner.getClientId(context);
        int hourInt = spinner.getHourInt();
        int minuteInt = spinner.getMinuteInt();
        int ampm = spinner.getAmpm();
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_script"), "id");
        writer.startElement("script", null);
        writer.writeAttribute("text", (Object)"text/javascript", null);
        writer.write("mobi.timespinner.init('" + clientId + "'," + hourInt + "," + minuteInt + "," + ampm + ",'" + spinner.getPattern() + "');");
        writer.endElement("script");
        writer.endElement("span");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        TimeSpinner spinner = (TimeSpinner)component;
        String submittedValue = String.valueOf(value);
        Object objVal = null;
        Converter converter = spinner.getConverter();
        if (converter != null) {
            objVal = converter.getAsObject(context, (UIComponent)spinner, submittedValue);
            return objVal;
        }
        try {
            Locale locale = spinner.calculateLocale(context);
            SimpleDateFormat format = new SimpleDateFormat(spinner.getPattern(), locale);
            format.setTimeZone(spinner.calculateTimeZone());
            Date convertedValue = format.parse(submittedValue);
            return convertedValue;
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private void setIntValues(TimeSpinner spinner, Date aDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(aDate);
        int hourInt = cal.get(10);
        if (0 == hourInt) {
            hourInt = 12;
        }
        spinner.setHourInt(hourInt);
        spinner.setMinuteInt(cal.get(12));
        spinner.setAmpm(cal.get(9));
    }

    private String convertStringInput(String patternIn, String patternOut, String inString) {
        SimpleDateFormat df1 = new SimpleDateFormat(patternIn);
        SimpleDateFormat df2 = new SimpleDateFormat(patternOut);
        String returnString = inString;
        try {
            Date aDate = df1.parse(inString);
            returnString = df2.format(aDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnString;
    }

    private String encodeValue(TimeSpinner spinner, String initialValue) {
        String value = "";
        Date aDate = new Date();
        SimpleDateFormat df2 = new SimpleDateFormat(spinner.getPattern());
        if (!this.isValueBlank(initialValue)) {
            try {
                if (this.isFormattedDate(initialValue, spinner.getPattern())) {
                    value = initialValue;
                    aDate = df2.parse(value);
                } else if (this.isFormattedDate(initialValue, "EEE MMM dd hh:mm:ss zzz yyyy")) {
                    value = this.convertStringInput("EEE MMM dd hh:mm:ss zzz yyyy", spinner.getPattern(), initialValue);
                    aDate = df2.parse(value);
                }
            }
            catch (Exception e) {
                throw new ConverterException();
            }
        }
        this.setIntValues(spinner, aDate);
        return value;
    }

    private boolean isFormattedDate(String inStr, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(inStr, new ParsePosition(0)) != null;
    }

    private String convertToTwelve(String inputVal) {
        String delim = ":";
        String[] tmp = inputVal.split(delim);
        String hr = tmp[0];
        String min = tmp[1];
        if (min.length() == 1) {
            min = min + "0";
        }
        String retVal = null;
        try {
            int hour = Integer.parseInt(hr);
            int minute = Integer.parseInt(min);
            retVal = hour < 13 && minute <= 59 ? hr + ":" + min + " AM" : String.valueOf(hour - 12) + ":" + min + " PM";
        }
        catch (NumberFormatException nfe) {
            logger.info("not able to convert iOS5 input to 12 hour clock");
        }
        return retVal;
    }

    private boolean shouldUseNative(TimeSpinner component) {
        return component.isUseNative() && (Utils.isIOS5() || Utils.isBlackBerry());
    }
}

