/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.video;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.icefaces.impl.application.AuxUploadResourceHandler;
import org.icefaces.mobi.component.video.VideoCapture;
import org.icefaces.mobi.renderkit.BaseInputResourceRenderer;
import org.icefaces.mobi.utils.Utils;
import org.icefaces.util.EnvUtils;

public class VideoCaptureRenderer
extends BaseInputResourceRenderer {
    private static final Logger logger = Logger.getLogger(VideoCaptureRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        VideoCapture video = (VideoCapture)uiComponent;
        String clientId = video.getClientId();
        if (!video.isDisabled()) {
            try {
                HashMap map = new HashMap();
                boolean isValid = this.extractVideo(facesContext, map, clientId);
                if (isValid && map != null) {
                    video.setValue(map);
                    uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, null, map));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean extractVideo(FacesContext facesContext, Map map, String clientId) throws IOException {
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        boolean isValid = false;
        String partUploadName = clientId;
        if (EnvUtils.isEnhancedBrowser((FacesContext)facesContext)) {
            partUploadName = partUploadName + "-file";
        }
        if (EnvUtils.isAuxUploadBrowser((FacesContext)facesContext)) {
            partUploadName = partUploadName + "-file";
        }
        Part part = null;
        try {
            part = request.getPart(partUploadName);
        }
        catch (ServletException e) {
            // empty catch block
        }
        if (null == part) {
            Map auxMap = AuxUploadResourceHandler.getAuxRequestMap();
            part = (Part)auxMap.get(partUploadName);
        }
        if (part != null) {
            String contentType = part.getContentType();
            String fileName = UUID.randomUUID().toString();
            isValid = part.getSize() > 0L;
            fileName = "video/mp4".equals(contentType) ? fileName + ".mp4" : ("video/mpeg".equals(contentType) ? fileName + ".mp4" : ("video/mov".equals(contentType) ? fileName + ".mov" : ("video/3gpp".equals(contentType) ? fileName + ".3gp" : fileName + ".oth")));
            Utils.createMapOfFile(map, request, part, fileName, contentType, facesContext);
        }
        return isValid;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String script;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        VideoCapture video = (VideoCapture)uiComponent;
        boolean isEnhanced = EnvUtils.isEnhancedBrowser((FacesContext)facesContext);
        boolean isAuxUpload = EnvUtils.isAuxUploadBrowser((FacesContext)facesContext);
        boolean disabled = video.isDisabled();
        if (!isEnhanced && !isAuxUpload) {
            writer.startElement("span", uiComponent);
            writer.startElement("input", uiComponent);
            writer.writeAttribute("type", (Object)"file", null);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("name", (Object)clientId, null);
            writer.endElement("input");
            return;
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("id", (Object)(clientId + "_button"), null);
        writer.writeAttribute("name", (Object)(clientId + "_button"), null);
        writer.writeAttribute("value", (Object)"camcorder", null);
        Utils.writeConcatenatedStyleClasses(writer, "mobi-button mobi-button-default", video.getStyleClass());
        writer.writeAttribute("style", (Object)video.getStyle(), "style");
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        int width = video.getMaxwidth();
        int height = video.getMaxheight();
        int maxtime = video.getMaxtime();
        if (isAuxUpload) {
            script = Utils.getICEmobileSXScript("camcorder", clientId);
        } else {
            String params = "'" + clientId + "'";
            int unset = Integer.MIN_VALUE;
            int numParams = 0;
            String attributeSeparator = "&";
            if (maxtime != unset || width != unset || height != unset) {
                params = params + ",'";
            }
            if (maxtime != unset) {
                if (numParams > 0) {
                    params = params + attributeSeparator;
                }
                params = params + "maxtime=" + maxtime;
                ++numParams;
            }
            if (width != Integer.MIN_VALUE) {
                if (numParams > 0) {
                    params = params + attributeSeparator;
                }
                params = params + "maxwidth=" + width;
                ++numParams;
            }
            if (height != Integer.MIN_VALUE) {
                if (numParams > 0) {
                    params = params + attributeSeparator;
                }
                params = params + "maxheight=" + height;
                ++numParams;
            }
            if (numParams > 0) {
                params = params + "'";
            }
            script = "ice.camcorder(" + params + ");";
        }
        if (video.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.writeAttribute("onclick", (Object)script, null);
        writer.endElement("input");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("span");
    }
}

