/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.video;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.component.video.VideoPlayer;
import org.icefaces.mobi.renderkit.BaseResourceRenderer;
import org.icefaces.mobi.utils.PassThruAttributeWriter;
import org.icefaces.mobi.utils.Utils;

public class VideoPlayerRenderer
extends BaseResourceRenderer {
    private static Logger log = Logger.getLogger(VideoPlayerRenderer.class.getName());

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String name;
        String scope;
        String mimeType;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        VideoPlayer video = (VideoPlayer)uiComponent;
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        StringBuilder styleClass = new StringBuilder("mobi-video");
        if (video.getStyleClass() != null) {
            styleClass.append(" ").append(video.getStyleClass());
        }
        writer.writeAttribute("class", (Object)styleClass.toString(), null);
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, video.getSpanPassThruAttributes());
        writer.startElement("video", uiComponent);
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, video.getVideoPassThruAttributes());
        if (video.isControls()) {
            writer.writeAttribute("controls", (Object)"controls", null);
        }
        if (video.isLoop()) {
            writer.writeAttribute("loop", (Object)"loop", null);
        }
        if (null != (mimeType = video.getType())) {
            writer.writeAttribute("type", (Object)mimeType, null);
        }
        if (video.isPlaysinline()) {
            writer.writeAttribute("webkit-playsinline", (Object)"yes", null);
        }
        if (!((scope = video.getScope().toLowerCase().trim()).equals("flash") || scope.equals("window") || scope.equals("application") || scope.equals("request") || scope.equals("view"))) {
            scope = "session";
        }
        if (null == (name = video.getName()) || name.equals("")) {
            name = "video" + clientId;
        }
        Object videoObject = video.getValue();
        String srcAttribute = "null";
        if (null != videoObject) {
            srcAttribute = this.processSrcAttribute(facesContext, videoObject, name, mimeType, scope, video.getUrl());
        }
        writer.writeAttribute("src", (Object)srcAttribute, null);
        writer.endElement("video");
        if (!Utils.isIOS() && video.getLinkLabel() != null) {
            writer.startElement("br", uiComponent);
            writer.endElement("br");
            writer.startElement("a", uiComponent);
            writer.writeAttribute("href", (Object)srcAttribute, null);
            writer.writeText((Object)video.getLinkLabel(), null);
            writer.endElement("a");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("span");
    }
}

