/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.renderkit;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.icefaces.mobi.renderkit.CoreRenderer;

public class BaseInputRenderer
extends CoreRenderer {
    private static Logger logger = Logger.getLogger(BaseInputRenderer.class.getName());

    protected String getOptionAsString(FacesContext facesContext, UIInput uiComponent, Converter converter, Object value) {
        if (converter != null) {
            return converter.getAsString(facesContext, (UIComponent)uiComponent, value);
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    protected Converter getConverter(FacesContext facesContext, UIInput uiComponent) {
        Converter converter = uiComponent.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression ve = uiComponent.getValueExpression("value");
        if (ve != null) {
            Class valueType = ve.getType(facesContext.getELContext());
            return facesContext.getApplication().createConverter(valueType);
        }
        return null;
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        UIInput uiInput = (UIInput)uiComponent;
        String value = (String)submittedValue;
        Converter converter = uiInput.getConverter();
        if (converter != null) {
            return converter.getAsObject(facesContext, (UIComponent)uiInput, value);
        }
        ValueExpression ve = uiInput.getValueExpression("value");
        if (ve != null) {
            Class valueType = ve.getType(facesContext.getELContext());
            Converter converterForType = facesContext.getApplication().createConverter(valueType);
            if (converterForType != null) {
                return converterForType.getAsObject(facesContext, (UIComponent)uiInput, value);
            }
        }
        return value;
    }

    public static String getStringValueToRender(FacesContext facesContext, UIComponent component) {
        if (component instanceof ValueHolder) {
            Converter converterForType;
            Class valueType;
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            if (valueHolder.getConverter() != null) {
                return valueHolder.getConverter().getAsString(facesContext, component, value);
            }
            ValueExpression expr = component.getValueExpression("value");
            if (expr != null && (valueType = expr.getType(facesContext.getELContext())) != null && (converterForType = facesContext.getApplication().createConverter(valueType)) != null) {
                return converterForType.getAsString(facesContext, component, value);
            }
            return value.toString();
        }
        String value = component.toString();
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    protected void renderChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        for (UIComponent child : uiComponent.getChildren()) {
            this.renderChild(facesContext, child);
        }
    }

    protected void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            this.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    public void setSubmittedValue(UIComponent uiComponent, Object value) {
        if (uiComponent instanceof UIInput) {
            ((UIInput)uiComponent).setSubmittedValue(value);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Sets submitted value to" + value + " on component  " + uiComponent.getClientId());
            }
        }
    }

    protected Object getValue(UIComponent uiComponent) {
        if (uiComponent instanceof UIInput) {
            Object value = ((UIInput)uiComponent).getValue();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("component.getValue() = " + value + " for component=" + uiComponent.getClientId());
            }
            return value;
        }
        return null;
    }
}

