/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.renderkit;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpSession;
import org.icefaces.application.ResourceRegistry;
import org.icefaces.mobi.utils.IceOutputResource;
import org.icefaces.mobi.utils.Utils;

public class BaseResourceRenderer
extends Renderer {
    private static Logger logger = Logger.getLogger(BaseResourceRenderer.class.getName());

    private String registerAndGetPath(FacesContext facesContext, String scope, IceOutputResource iceResource) {
        HttpSession session;
        String registeredPath = "";
        if (scope.equals("flash")) {
            registeredPath = ResourceRegistry.addSessionResource((Resource)iceResource);
        } else if (scope.equals("application")) {
            registeredPath = ResourceRegistry.addApplicationResource((Resource)iceResource);
        } else if (scope.equals("window")) {
            registeredPath = ResourceRegistry.addWindowResource((Resource)iceResource);
        } else if (scope.equals("view")) {
            registeredPath = ResourceRegistry.addViewResource((Resource)iceResource);
        } else if (scope.equals("session")) {
            registeredPath = ResourceRegistry.addSessionResource((Resource)iceResource);
        }
        if (Utils.isAndroid() && null != (session = (HttpSession)facesContext.getExternalContext().getSession(false))) {
            registeredPath = registeredPath + ";jsessionid=" + session.getId();
        }
        return registeredPath;
    }

    protected String processStaticSrc(FacesContext facesContext, Object o, String url) {
        String value = String.valueOf(o);
        if (value == null) {
            value = url;
        }
        if (value != null) {
            return facesContext.getApplication().getViewHandler().getResourceURL(facesContext, value);
        }
        return "";
    }

    private ResourceRegistry lookupRegistry(FacesContext facesContext) {
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        if (applicationMap.containsKey(ResourceRegistry.class.getName())) {
            ResourceRegistry rr = (ResourceRegistry)applicationMap.get(ResourceRegistry.class.getName());
            return rr;
        }
        return null;
    }

    public String processSrcAttribute(FacesContext facesContext, Object o, String name, String mimeType, String scope, String url) {
        if (o instanceof IceOutputResource) {
            IceOutputResource iceResource = (IceOutputResource)o;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ALREADY have IceOutputResource so returning:-" + iceResource.getRequestPath());
            }
            return this.registerAndGetPath(facesContext, scope, iceResource);
        }
        if (o instanceof byte[]) {
            IceOutputResource ior = new IceOutputResource(name, o, mimeType);
            String registeredPath = this.registerAndGetPath(facesContext, scope, ior);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("instance of byte array returning path=" + registeredPath + " with mimeType=" + ior.getContentType());
            }
            return registeredPath;
        }
        return this.processStaticSrc(facesContext, o, url);
    }
}

