/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

public class MessageUtils {
    private static String DETAIL_SUFFIX = "_detail";
    private static int SUMMARY = 0;
    private static int DETAIL = 1;
    private static String ICE_MESSAGES_BUNDLE = "org.icefaces.mobi.component.resources.messages";

    public static FacesMessage getMessage(FacesContext facesContext, FacesMessage.Severity sev, String messageId, Object[] params) {
        String[] messageInfo = new String[2];
        Locale locale = facesContext.getViewRoot().getLocale();
        String bundleName = facesContext.getApplication().getMessageBundle();
        if (bundleName != null) {
            try {
                MessageUtils.loadMessageInfo(bundleName, locale, messageId, messageInfo);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (messageInfo[SUMMARY] == null && messageInfo[DETAIL] == null) {
            try {
                MessageUtils.loadMessageInfo(ICE_MESSAGES_BUNDLE, locale, messageId, messageInfo);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return MessageUtils.getMessage(locale, sev, messageInfo[SUMMARY], messageInfo[DETAIL], params);
    }

    public static FacesMessage getMessage(Locale locale, FacesMessage.Severity sev, String summary, String detail, Object[] params) {
        summary = MessageUtils.formatString(locale, summary, params);
        detail = MessageUtils.formatString(locale, detail, params);
        return new FacesMessage(sev, summary, detail);
    }

    private static void loadMessageInfo(String bundleName, Locale locale, String messageId, String[] messageInfo) {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, MessageUtils.getClassLoader(bundleName));
        try {
            messageInfo[MessageUtils.SUMMARY] = bundle.getString(messageId);
            messageInfo[MessageUtils.DETAIL] = bundle.getString(messageId + DETAIL_SUFFIX);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
    }

    private static String formatString(Locale locale, String pattern, Object[] params) {
        if (pattern != null && params != null) {
            MessageFormat format = new MessageFormat(pattern, locale);
            pattern = format.format(params);
        }
        return pattern;
    }

    public static ClassLoader getClassLoader(Object fallback) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = fallback.getClass().getClassLoader();
        }
        return classLoader;
    }
}

