/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.icefaces.impl.application.AuxUploadSetup;
import org.icefaces.impl.util.CoreUtils;
import org.icefaces.impl.util.DOMUtils;
import org.icefaces.mobi.utils.UserAgentInfo;
import org.icefaces.util.EnvUtils;
import org.icemobile.component.impl.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    static String TEMP_DIR = "javax.servlet.context.tmpdir";
    private static Logger logger = Logger.getLogger(Utils.class.getName());

    public static void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                Utils.renderChild(facesContext, child);
            }
        }
    }

    public static void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            Utils.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    public static UIComponent findNamingContainer(UIComponent uiComponent) {
        UIComponent parent;
        for (parent = uiComponent.getParent(); parent != null && !(parent instanceof NamingContainer); parent = parent.getParent()) {
        }
        return parent;
    }

    public static UIComponent findParentForm(UIComponent component) {
        UIComponent parent;
        for (parent = component; parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return parent;
    }

    public static void writeConcatenatedStyleClasses(ResponseWriter writer, String componentClass, String applicationClass) throws IOException {
        int applicationLen;
        int n;
        int componentLen;
        int n2;
        if (componentClass == null) {
            n2 = 0;
        } else {
            componentClass = componentClass.trim();
            n2 = componentLen = componentClass.length();
        }
        if (applicationClass == null) {
            n = 0;
        } else {
            applicationClass = applicationClass.trim();
            n = applicationLen = applicationClass.length();
        }
        if (componentLen > 0 && applicationLen == 0) {
            writer.writeAttribute("class", (Object)componentClass, "styleClass");
        } else if (componentLen == 0 && applicationLen > 0) {
            writer.writeAttribute("class", (Object)applicationClass, "styleClass");
        } else if (componentLen > 0 || applicationLen > 0) {
            int totalLen = componentLen + applicationLen;
            if (componentLen > 0 && applicationLen > 0) {
                ++totalLen;
            }
            StringBuilder sb = new StringBuilder(totalLen);
            if (componentLen > 0) {
                sb.append(componentClass);
            }
            if (applicationLen > 0) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(applicationClass);
            }
            writer.writeAttribute("class", (Object)sb.toString(), "styleClass");
        }
    }

    public static void writeConcatenatedStyleClasses(ResponseWriter writer, String componentClass, String applicationClass, boolean disabled) throws IOException {
        int applicationLen;
        int n;
        int componentLen;
        int n2;
        String disabledStr = "-disabled";
        if (componentClass == null) {
            n2 = 0;
        } else {
            componentClass = componentClass.trim();
            n2 = componentLen = componentClass.length();
        }
        if (applicationClass == null) {
            n = 0;
        } else {
            applicationClass = applicationClass.trim();
            n = applicationLen = applicationClass.length();
        }
        if (componentLen > 0 && applicationLen == 0) {
            if (disabled) {
                String styleClass = (componentClass + "-disabled").intern();
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            } else {
                writer.writeAttribute("class", (Object)componentClass, "styleClass");
            }
        } else if (componentLen == 0 && applicationLen > 0 && !disabled) {
            writer.writeAttribute("class", (Object)applicationClass, "styleClass");
        } else if (componentLen > 0 || applicationLen > 0) {
            int totalLen = componentLen + applicationLen;
            if (disabled && componentLen > 0) {
                totalLen += "-disabled".length();
            }
            if (disabled && applicationLen > 0) {
                totalLen += "-disabled".length();
            }
            if (componentLen > 0 && applicationLen > 0) {
                ++totalLen;
            }
            StringBuilder sb = new StringBuilder(totalLen);
            if (componentLen > 0) {
                sb.append(componentClass);
                if (disabled) {
                    sb.append("-disabled");
                }
            }
            if (applicationLen > 0) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(applicationClass);
                if (disabled) {
                    sb.append("-disabled");
                }
            }
            writer.writeAttribute("class", (Object)sb.toString(), "styleClass");
        }
    }

    public static void writeConcatenatedStyleClasses(ResponseWriter writer, String[] componentClasses, String applicationClass, boolean disabled) throws IOException {
        String disabledStr = "-disabled";
        int componentCount = componentClasses == null ? 0 : componentClasses.length;
        StringTokenizer st = new StringTokenizer(applicationClass, " ");
        int applicationCount = st.countTokens();
        if (componentCount == 1 && applicationCount == 0) {
            if (disabled) {
                String styleClass = (componentClasses[0].trim() + "-disabled").intern();
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            } else {
                writer.writeAttribute("class", (Object)componentClasses[0], "styleClass");
            }
        } else if (componentCount == 0 && applicationCount == 1 && !disabled) {
            writer.writeAttribute("class", (Object)applicationClass, "styleClass");
        } else if (componentCount > 0 || applicationCount > 0) {
            StringBuilder sb = new StringBuilder((componentCount + applicationCount) * 16);
            for (int i = 0; i < componentCount; ++i) {
                Utils.concatenateStyleClass(sb, componentClasses[i], disabled, "-disabled");
            }
            while (st.hasMoreTokens()) {
                Utils.concatenateStyleClass(sb, st.nextToken(), disabled, "-disabled");
            }
            sb.trimToSize();
            writer.writeAttribute("class", (Object)sb.toString(), "styleClass");
        }
    }

    private static void concatenateStyleClass(StringBuilder sb, String styleClass, boolean disabled, String disabledStr) {
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(styleClass);
        if (disabled) {
            sb.append(' ');
            sb.append(styleClass);
            sb.append(disabledStr);
        }
    }

    public static String findClientIds(FacesContext context, UIComponent component, String list) {
        if (list == null) {
            return "@none";
        }
        String[] ids = list.split("[,\\s]+");
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            String id;
            if (i != 0) {
                buffer.append(" ");
            }
            if ((id = ids[i].trim()).equals("@all") || id.equals("@none")) {
                buffer.append(id);
                continue;
            }
            if (id.equals("@this")) {
                buffer.append(component.getClientId(context));
                continue;
            }
            if (id.equals("@parent")) {
                buffer.append(component.getParent().getClientId(context));
                continue;
            }
            if (id.equals("@form")) {
                UIComponent form = Utils.findParentForm(component);
                if (form == null) {
                    throw new FacesException("Component " + component.getClientId(context) + " needs to be enclosed in a form");
                }
                buffer.append(form.getClientId(context));
                continue;
            }
            UIComponent comp = component.findComponent(id);
            if (comp != null) {
                buffer.append(comp.getClientId(context));
                continue;
            }
            if (context.getApplication().getProjectStage().equals((Object)ProjectStage.Development)) {
                logger.log(Level.INFO, "Cannot find component with identifier \"{0}\" in view.", id);
            }
            buffer.append(id);
        }
        return buffer.toString();
    }

    public static DeviceType getDeviceType(FacesContext context) {
        String userAgent = SessionContext.getSessionContext().getUserAgent();
        DeviceType device = Utils.checkUserAgentInfo(new UserAgentInfo(userAgent));
        return device;
    }

    public static boolean isTouchEventEnabled(FacesContext context) {
        String userAgent = SessionContext.getSessionContext().getUserAgent();
        UserAgentInfo uai = new UserAgentInfo(userAgent);
        if (uai.sniffAndroidTablet()) {
            return false;
        }
        return uai.sniffIphone() || uai.sniffAndroid() || uai.sniffIpad() || uai.sniffIpod();
    }

    public static boolean isAndroid() {
        String userAgent = SessionContext.getSessionContext().getUserAgent();
        UserAgentInfo uai = new UserAgentInfo(userAgent);
        return new UserAgentInfo(userAgent).sniffAndroid();
    }

    public static boolean isBlackBerry() {
        String userAgent = SessionContext.getSessionContext().getUserAgent();
        UserAgentInfo uai = new UserAgentInfo(userAgent);
        return new UserAgentInfo(userAgent).sniffBlackberry();
    }

    public static boolean isIE() {
        String userAgent = SessionContext.getSessionContext().getUserAgent();
        return userAgent.contains("MSIE");
    }

    public static boolean isIOS() {
        String userAgent = SessionContext.getSessionContext().getUserAgent();
        UserAgentInfo uai = new UserAgentInfo(userAgent);
        return new UserAgentInfo(userAgent).sniffIOS();
    }

    public static boolean isIOS5() {
        String userAgent = SessionContext.getSessionContext().getUserAgent();
        return new UserAgentInfo(userAgent).sniffIOS5();
    }

    public static boolean showSX() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        boolean isEnhanced = EnvUtils.isEnhancedBrowser((FacesContext)facesContext);
        boolean isAuxUpload = EnvUtils.isAuxUploadBrowser((FacesContext)facesContext);
        return Utils.isIOS() && !isEnhanced & !isAuxUpload;
    }

    private static DeviceType checkUserAgentInfo(UserAgentInfo uai) {
        if (uai.sniffIphone() || uai.sniffIpod()) {
            return DeviceType.iphone;
        }
        if (uai.sniffAndroidTablet()) {
            return DeviceType.honeycomb;
        }
        if (uai.sniffAndroid()) {
            return DeviceType.android;
        }
        if (uai.sniffBlackberry()) {
            return DeviceType.bberry;
        }
        if (uai.sniffIpad()) {
            return DeviceType.ipad;
        }
        return DeviceType.DEFAULT;
    }

    public static void createMapOfFile(Map map, HttpServletRequest request, Part part, String fileName, String contentType, FacesContext facesContext) throws IOException {
        String UPLOADS_FOLDER = "uploads";
        String FILE_SEPARATOR = System.getProperty("file.separator");
        String folder = CoreUtils.getRealPath((FacesContext)facesContext, (String)FILE_SEPARATOR);
        String sessionId = CoreUtils.getSessionId((FacesContext)facesContext);
        String relativePath = "";
        if (sessionId != null && sessionId.length() > 0) {
            relativePath = relativePath + FILE_SEPARATOR + "uploads" + FILE_SEPARATOR + sessionId + FILE_SEPARATOR + fileName;
            folder = folder + "uploads" + FILE_SEPARATOR + sessionId + FILE_SEPARATOR;
        } else {
            relativePath = relativePath + "uploads" + FILE_SEPARATOR + fileName;
            folder = folder + "uploads" + FILE_SEPARATOR;
        }
        File dirFile = new File(folder);
        File newFile = new File(dirFile, fileName);
        File tempDir = (File)request.getServletContext().getAttribute(TEMP_DIR);
        File tempFile = File.createTempFile("ice", ".tmp", tempDir);
        FileOutputStream tempStream = new FileOutputStream(tempFile);
        boolean success = false;
        if (!dirFile.exists()) {
            success = dirFile.mkdirs();
        }
        try {
            InputStream partStream = part.getInputStream();
            Utils.copyStream(partStream, tempStream);
            tempFile.renameTo(newFile);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error writing uploaded file to disk ", e);
        }
        map.put("file", newFile);
        map.put("contentType", contentType);
        map.put("relativePath", relativePath);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("wrote " + newFile.getAbsolutePath());
        }
    }

    public static void createMapOfByteArray(Map map, HttpServletRequest request, Part part, String contentType, FacesContext facesContext) throws IOException {
        int size = (int)part.getSize();
        int totalRead = 0;
        byte[] fileContents = new byte[size];
        try {
            int currentlyRead;
            InputStream is = part.getInputStream();
            while ((currentlyRead = is.read(fileContents, totalRead, size - totalRead)) >= 0 && (totalRead += currentlyRead) != size) {
            }
            map.put("fileInBytes", fileContents);
            map.put("contentType", contentType);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "ERROR creating byte array for component", e);
        }
    }

    public static List<UIParameter> captureParameters(UIComponent component) {
        List children = component.getChildren();
        ArrayList<UIParameter> returnVal = null;
        for (UIComponent child : children) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            if (returnVal == null) {
                returnVal = new ArrayList<UIParameter>();
            }
            returnVal.add(param);
        }
        return returnVal;
    }

    public static String asParameterString(List<UIParameter> children) {
        StringBuffer builder = new StringBuffer();
        builder.append("function(p){");
        for (UIParameter param : children) {
            builder.append("p('" + DOMUtils.escapeAnsi((String)param.getName()) + "'").append(",'").append(DOMUtils.escapeAnsi((String)((String)param.getValue())).replace(' ', '+')).append("');");
        }
        builder.append("}");
        return builder.toString();
    }

    public static String getICEmobileSXScript(String command, String id) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        AuxUploadSetup auxUpload = AuxUploadSetup.getInstance();
        String sessionID = EnvUtils.getSafeSession((FacesContext)facesContext).getId();
        String uploadURL = auxUpload.getUploadURL();
        String fullCommand = command + "?id=" + id;
        String script = "window.location='icemobile://c=" + URLEncoder.encode(fullCommand) + "&r='+escape(window.location)+'&" + "JSESSIONID=" + sessionID + "&u=" + URLEncoder.encode(uploadURL) + "'";
        return script;
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[1000];
        int l = 1;
        while (l > 0) {
            l = in.read(buf);
            if (l <= 0) continue;
            out.write(buf, 0, l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeviceType {
        android,
        honeycomb,
        bberry,
        iphone,
        ipad;

        public static final DeviceType DEFAULT;

        public boolean equals(String deviceName) {
            return this.name().equals(deviceName);
        }

        static {
            DEFAULT = ipad;
        }
    }
}

