/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.camera;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.render.Renderer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.icefaces.impl.application.AuxUploadResourceHandler;
import org.icefaces.mobi.component.camera.Camera;
import org.icefaces.mobi.utils.Utils;
import org.icefaces.util.EnvUtils;

public class CameraRenderer
extends Renderer {
    private static Logger logger = Logger.getLogger(CameraRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        Camera camera = (Camera)uiComponent;
        String source = String.valueOf(requestParameterMap.get("ice.event.captured"));
        String clientId = camera.getClientId();
        try {
            HashMap map;
            boolean valid;
            if (!camera.isDisabled() && (valid = this.extractImages(facesContext, map = new HashMap(), clientId)) && map != null) {
                camera.setValue(map);
                uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, null, map));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean extractImages(FacesContext facesContext, Map map, String clientId) throws IOException {
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        boolean isValid = false;
        String partUploadName = clientId;
        if (EnvUtils.isEnhancedBrowser((FacesContext)facesContext)) {
            partUploadName = partUploadName + "-file";
        }
        if (EnvUtils.isAuxUploadBrowser((FacesContext)facesContext)) {
            partUploadName = partUploadName + "-file";
        }
        Part part = null;
        try {
            part = request.getPart(partUploadName);
        }
        catch (ServletException e) {
            // empty catch block
        }
        if (null == part) {
            Map auxMap = AuxUploadResourceHandler.getAuxRequestMap();
            part = (Part)auxMap.get(partUploadName);
        }
        if (part != null) {
            String contentType = part.getContentType();
            String fileName = UUID.randomUUID().toString();
            isValid = part.getSize() > 0L;
            fileName = "image/jpeg".equals(contentType) || "image/jpg".equals(contentType) ? fileName + ".jpg" : ("image/png".equals(contentType) ? fileName + ".png" : fileName + ".oth");
            Utils.createMapOfFile(map, request, part, fileName, contentType, facesContext);
        }
        return isValid;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String script;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        Camera camera = (Camera)uiComponent;
        boolean isEnhanced = EnvUtils.isEnhancedBrowser((FacesContext)facesContext);
        boolean isAuxUpload = EnvUtils.isAuxUploadBrowser((FacesContext)facesContext);
        if (!isEnhanced && !isAuxUpload) {
            writer.startElement("span", uiComponent);
            writer.startElement("input", uiComponent);
            writer.writeAttribute("type", (Object)"file", null);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("name", (Object)clientId, null);
            writer.endElement("input");
            return;
        }
        boolean disabled = camera.isDisabled();
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("name", (Object)(clientId + "_button"), null);
        Utils.writeConcatenatedStyleClasses(writer, "mobi-button mobi-button-default", camera.getStyleClass());
        writer.writeAttribute("style", (Object)camera.getStyle(), "style");
        int width = camera.getMaxwidth();
        int height = camera.getMaxheight();
        if (isAuxUpload) {
            script = Utils.getICEmobileSXScript("camera", clientId);
        } else if (width != Integer.MIN_VALUE || height != Integer.MIN_VALUE) {
            String params = "'" + clientId + "','maxwidth=" + width + "&maxheight=" + height + "'";
            script = "ice.camera(" + params + ");";
        } else {
            script = "ice.camera( '" + clientId + "' );";
        }
        writer.writeAttribute("onclick", (Object)script, null);
        writer.writeText((Object)"camera", null);
        writer.endElement("button");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        Camera camera = (Camera)uiComponent;
        writer.endElement("span");
    }
}

