/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.carousel;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import org.icefaces.mobi.component.carousel.Carousel;
import org.icefaces.mobi.renderkit.BaseLayoutRenderer;

public class CarouselRenderer
extends BaseLayoutRenderer {
    private static Logger logger = Logger.getLogger(CarouselRenderer.class.getName());
    private static final String JS_NAME = "carousel";
    private static final String JS_LIBRARY = "org.icefaces.component.carousel";
    private static final String JS_ISCROLL = "iscroll";
    private static final String LIB_ISCROLL = "org.icefaces.component.util";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Carousel carousel;
        String clientId;
        String hiddenField;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(hiddenField = (clientId = (carousel = (Carousel)uiComponent).getClientId(facesContext)) + "_hidden")) {
            try {
                Integer selected = Integer.parseInt((String)params.get(hiddenField));
                int old = carousel.getSelectedItem();
                if (old != selected) {
                    carousel.setSelectedItem(selected);
                    uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, (Object)old, (Object)selected));
                    this.decodeBehaviors(facesContext, (UIComponent)carousel);
                }
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Error creating carousel value change event.", e);
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        Carousel carousel = (Carousel)uiComponent;
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_jscript"), "id");
        Map contextMap = facesContext.getViewRoot().getViewMap();
        if (!contextMap.containsKey(JS_ISCROLL)) {
            this.writeJSResource(JS_ISCROLL, LIB_ISCROLL, facesContext, uiComponent, writer);
        }
        if (!contextMap.containsKey(JS_NAME)) {
            this.writeJSResource(JS_NAME, JS_LIBRARY, facesContext, uiComponent, writer);
        }
        writer.endElement("span");
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "ui");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_carousel"), "id");
        String userDefinedClass = carousel.getStyleClass();
        String styleClass = "mobi-carousel ";
        if (userDefinedClass != null) {
            styleClass = styleClass + userDefinedClass;
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (carousel.getStyle() != null) {
            writer.writeAttribute("style", (Object)carousel.getStyle(), "style");
        }
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-carousel-scroller", null);
        writer.startElement("ul", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-carousel-list", null);
    }

    private void writeJSResource(String fname, String library, FacesContext facesContext, UIComponent uiComponent, ResponseWriter writer) throws IOException {
        Map contextMap = facesContext.getViewRoot().getViewMap();
        String jsFname = fname + ".js";
        if (facesContext.isProjectStage(ProjectStage.Production)) {
            jsFname = fname + "-min.js";
        }
        Resource jsFile = facesContext.getApplication().getResourceHandler().createResource(jsFname, library);
        String src = jsFile.getRequestPath();
        writer.startElement("script", uiComponent);
        writer.writeAttribute("text", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)src, null);
        writer.endElement("script");
        contextMap.put(fname, "true");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    private void encodeCarouselList(Carousel carousel, FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (carousel.getVar() != null) {
            carousel.setRowIndex(-1);
            for (int i = 0; i < carousel.getRowCount(); ++i) {
                carousel.setRowIndex(i);
                writer.startElement("li", null);
                this.renderChildren(facesContext, (UIComponent)carousel);
                writer.endElement("li");
            }
        } else if (facesContext.isProjectStage(ProjectStage.Development) || logger.isLoggable(Level.FINER)) {
            logger.finer("Carousel must define the var and value attributes");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        Carousel carousel = (Carousel)uiComponent;
        int selected = carousel.getSelectedItem();
        String savedId = carousel.getId();
        this.encodeCarouselList(carousel, facesContext);
        writer.endElement("ul");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_list"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_list"), "name");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-carousel-cursor ", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-carousel-cursor-center", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"mobi-carousel-cursor-list ", null);
        int size = carousel.getRowCount();
        if (selected > size - 1 || selected < 0) {
            selected = 0;
        }
        for (int i = 0; i < size; ++i) {
            writer.startElement("li", null);
            if (selected == i) {
                writer.writeAttribute("class", (Object)"active", null);
            }
            writer.write(String.valueOf(i + 1));
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("div");
        writer.endElement("div");
        this.encodeHiddenSelected(facesContext, clientId, selected);
        writer.endElement("div");
        writer.endElement("span");
        ((Carousel)uiComponent).setRowIndex(-1);
        this.renderScript(uiComponent, facesContext, clientId);
    }

    private void renderScript(UIComponent uiComponent, FacesContext facesContext, String clientId) throws IOException {
        boolean hasBehaviors;
        ResponseWriter writer = facesContext.getResponseWriter();
        Carousel carousel = (Carousel)uiComponent;
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        boolean singleSubmit = carousel.isSingleSubmit();
        writer.startElement("script", null);
        writer.writeAttribute("id", (Object)(clientId + "_script"), "id");
        writer.writeAttribute("text", (Object)"text/javascript", null);
        StringBuilder builder = new StringBuilder(255);
        builder.append(clientId).append("',{ singleSubmit: ").append(singleSubmit);
        boolean bl = hasBehaviors = !carousel.getClientBehaviors().isEmpty();
        if (hasBehaviors) {
            String behaviors = this.encodeClientBehaviors(facesContext, cbh, "change").toString();
            behaviors = behaviors.replace("\"", "'");
            builder.append(behaviors);
        }
        builder.append("});");
        writer.write("ice.onUnload(function(){mobi.carousel.unloaded('" + clientId + "');" + "});\n");
        writer.write("supportsOrientationChange = 'onorientationchange' in window,orientationEvent = supportsOrientationChange ? 'orientationchange' : 'resize';\n");
        writer.write("window.addEventListener(orientationEvent, function() {  setTimeout(function () {        mobi.carousel.refresh('" + builder.toString() + "  \n}, 100); " + " }, false);\n");
        writer.write("mobi.carousel.loaded('" + builder.toString());
        writer.endElement("script");
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void encodeHiddenSelected(FacesContext facesContext, String id, int selectedIndex) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(id + "_hidden"), null);
        writer.writeAttribute("name", (Object)(id + "_hidden"), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)String.valueOf(selectedIndex), null);
        writer.endElement("input");
    }
}

