/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.datespinner;

import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.icefaces.mobi.component.datespinner.DateSpinner;
import org.icefaces.mobi.renderkit.BaseInputRenderer;
import org.icefaces.mobi.utils.PassThruAttributeWriter;
import org.icefaces.mobi.utils.Utils;

public class DateSpinnerRenderer
extends BaseInputRenderer {
    private static Logger logger = Logger.getLogger(DateSpinnerRenderer.class.getName());
    private static final String JS_NAME = "datespinner.js";
    private static final String JS_MIN_NAME = "datespinner-min.js";
    private static final String JS_LIBRARY = "org.icefaces.component.datespinner";

    public void decode(FacesContext context, UIComponent component) {
        DateSpinner dateSpinner = (DateSpinner)component;
        String clientId = dateSpinner.getClientId(context);
        if (dateSpinner.isDisabled()) {
            return;
        }
        String inputField = clientId + "_input";
        if (this.shouldUseNative(dateSpinner)) {
            inputField = clientId;
        }
        String inputValue = (String)context.getExternalContext().getRequestParameterMap().get(inputField);
        String hiddenValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_hidden");
        if (!this.isValueBlank(inputValue)) {
            dateSpinner.setSubmittedValue(inputValue);
        } else if (!this.isValueBlank(hiddenValue)) {
            dateSpinner.setSubmittedValue(hiddenValue);
        }
        this.decodeBehaviors(context, (UIComponent)dateSpinner);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DateSpinner spinner = (DateSpinner)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = spinner.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)component;
        boolean hasBehaviors = !cbh.getClientBehaviors().isEmpty();
        boolean singleSubmit = spinner.isSingleSubmit();
        String initialValue = DateSpinnerRenderer.getStringValueToRender(context, component);
        if (this.shouldUseNative(spinner)) {
            writer.startElement("input", component);
            writer.writeAttribute("type", (Object)"date", "type");
            writer.writeAttribute("id", (Object)clientId, "id");
            writer.writeAttribute("name", (Object)clientId, "name");
            boolean disabled = spinner.isDisabled();
            boolean readonly = spinner.isReadonly();
            if (this.isValueBlank(initialValue)) {
                SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
                Date aDate = new Date();
                writer.writeAttribute("value", (Object)df2.format(aDate), "value");
            } else {
                writer.writeAttribute("value", (Object)initialValue, "value");
            }
            if (disabled) {
                writer.writeAttribute("disabled", (Object)component, "disabled");
            }
            if (readonly) {
                writer.writeAttribute("readonly", (Object)component, "readonly");
            }
            if (!readonly && !disabled && hasBehaviors) {
                String event = spinner.getDefaultEventName(context);
                String cbhCall = this.buildAjaxRequest(context, cbh, event);
                writer.writeAttribute("onblur", (Object)cbhCall, null);
            } else if (singleSubmit) {
                writer.writeAttribute("onblur", (Object)"ice.se(event, this);", null);
            }
            writer.endElement("input");
        } else {
            Map viewContextMap = context.getViewRoot().getViewMap();
            if (!viewContextMap.containsKey(JS_NAME)) {
                String jsFname = JS_NAME;
                if (context.isProjectStage(ProjectStage.Production)) {
                    jsFname = JS_MIN_NAME;
                }
                Resource jsFile = context.getApplication().getResourceHandler().createResource(jsFname, JS_LIBRARY);
                String src = jsFile.getRequestPath();
                writer.startElement("script", component);
                writer.writeAttribute("text", (Object)"text/javascript", null);
                writer.writeAttribute("src", (Object)src, null);
                writer.endElement("script");
                viewContextMap.put(JS_NAME, "true");
            }
            String value = this.encodeValue(spinner, initialValue);
            this.encodeMarkup(context, component, value, hasBehaviors);
            this.encodeScript(context, component);
        }
    }

    protected void encodeMarkup(FacesContext context, UIComponent uiComponent, String value, boolean hasBehaviors) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        DateSpinner dateEntry = (DateSpinner)uiComponent;
        String clientId = dateEntry.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        String eventStr = "onclick";
        if (Utils.isTouchEventEnabled(context)) {
            eventStr = "ontouchstart";
        }
        boolean popup = true;
        int yMin = dateEntry.getYearStart();
        int yMax = dateEntry.getYearEnd();
        StringBuilder popupBaseClass = new StringBuilder("mobi-date-container");
        if (popup) {
            popupBaseClass.append("-hide");
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("class", (Object)"mobi-date-wrapper", "class");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_input"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_input"), "name");
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, dateEntry.getCommonAttributeNames());
        StringBuilder classNames = new StringBuilder("mobi-input-text");
        String checker = dateEntry.getStyleClass();
        if (null != checker) {
            classNames.append(" ").append(dateEntry.getStyleClass());
        }
        writer.writeAttribute("class", (Object)classNames.toString(), null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.writeAttribute("type", (Object)"text", "type");
        if (dateEntry.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (dateEntry.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)(clientId + "_hidden"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_hidden"), "name");
        writer.endElement("input");
        writer.endElement("span");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"", null);
        writer.writeAttribute("class", (Object)"mobi-date-popup-btn", null);
        if (dateEntry.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        } else {
            writer.writeAttribute("onclick", (Object)("mobi.datespinner.toggle('" + clientId + "');"), null);
        }
        writer.endElement("input");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_bg"), "id");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_popup"), "id");
        writer.writeAttribute("class", (Object)popupBaseClass.toString(), null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_title"), "id");
        writer.writeAttribute("class", (Object)"mobi-date-title-container", null);
        writer.write(value);
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-container", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-incr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-incr", null);
        writer.writeAttribute("id", (Object)(clientId + "_dUpBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.dUp('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_dInt"), null);
        writer.write(String.valueOf(dateEntry.getDayInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-decr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-decr", null);
        writer.writeAttribute("id", (Object)(clientId + "_dDnBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.dDn('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-incr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-incr", null);
        writer.writeAttribute("id", (Object)(clientId + "_mUpBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.mUp('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_mInt"), null);
        writer.write(String.valueOf(dateEntry.getMonthInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-decr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-decr", null);
        writer.writeAttribute("id", (Object)(clientId + "_mDnBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.mDn('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-incr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-incr", null);
        writer.writeAttribute("id", (Object)(clientId + "_yUpBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.yUp('" + clientId + "'," + yMin + "," + yMax + ");"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_yInt"), null);
        writer.write(String.valueOf(dateEntry.getYearInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-decr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-decr", null);
        writer.writeAttribute("id", (Object)(clientId + "_yDnBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.yDn('" + clientId + "'," + yMin + "," + yMax + ");"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-submit-container", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button mobi-button-default", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Set", null);
        boolean singleSubmit = dateEntry.isSingleSubmit();
        StringBuilder builder = new StringBuilder(255);
        builder.append("mobi.datespinner.select('").append(clientId).append("',{ event: event,");
        builder.append("singleSubmit: ").append(singleSubmit);
        if (hasBehaviors) {
            String behaviors = this.encodeClientBehaviors(context, cbh, "change").toString();
            behaviors = behaviors.replace("\"", "'");
            builder.append(behaviors);
        }
        builder.append("});");
        String jsCall = builder.toString();
        if (!dateEntry.isDisabled() && !dateEntry.isReadonly()) {
            writer.writeAttribute("onclick", (Object)jsCall, null);
        }
        writer.endElement("input");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button mobi-button-default", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Cancel", null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.close('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        DateSpinner spinner = (DateSpinner)uiComponent;
        String clientId = spinner.getClientId(context);
        int yrInt = spinner.getYearInt();
        int mnthInt = spinner.getMonthInt();
        int dateInt = spinner.getDayInt();
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_script"), "id");
        writer.startElement("script", null);
        writer.writeAttribute("text", (Object)"text/javascript", null);
        writer.write("mobi.datespinner.init('" + clientId + "'," + yrInt + "," + mnthInt + "," + dateInt + ",'" + spinner.getPattern() + "');");
        writer.endElement("script");
        writer.endElement("span");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        DateSpinner spinner = (DateSpinner)component;
        String submittedValue = String.valueOf(value);
        Object objVal = null;
        Converter converter = spinner.getConverter();
        if (converter != null) {
            objVal = converter.getAsObject(context, (UIComponent)spinner, submittedValue);
            return objVal;
        }
        try {
            Locale locale = spinner.calculateLocale(context);
            SimpleDateFormat format = new SimpleDateFormat(spinner.getPattern(), locale);
            format.setTimeZone(spinner.calculateTimeZone());
            Date convertedValue = format.parse(submittedValue);
            return convertedValue;
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private void setIntValues(DateSpinner spinner, Date aDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(aDate);
        spinner.setYearInt(cal.get(1));
        spinner.setMonthInt(cal.get(2) + 1);
        spinner.setDayInt(cal.get(5));
    }

    private String convertStringInput(String patternIn, String patternOut, String inString) {
        SimpleDateFormat df1 = new SimpleDateFormat(patternIn);
        SimpleDateFormat df2 = new SimpleDateFormat(patternOut);
        String returnString = inString;
        try {
            Date aDate = df1.parse(inString);
            returnString = df2.format(aDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnString;
    }

    private String encodeValue(DateSpinner spinner, String initialValue) {
        String value = "";
        Date aDate = new Date();
        SimpleDateFormat df2 = new SimpleDateFormat(spinner.getPattern());
        if (!this.isValueBlank(initialValue)) {
            try {
                if (this.isFormattedDate(initialValue, spinner.getPattern())) {
                    value = initialValue;
                    aDate = df2.parse(value);
                } else if (this.isFormattedDate(initialValue, "EEE MMM dd hh:mm:ss zzz yyyy")) {
                    value = this.convertStringInput("EEE MMM dd hh:mm:ss zzz yyyy", spinner.getPattern(), initialValue);
                    aDate = df2.parse(value);
                }
            }
            catch (Exception e) {
                throw new ConverterException();
            }
        }
        this.setIntValues(spinner, aDate);
        return value;
    }

    private boolean isFormattedDate(String inStr, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(inStr, new ParsePosition(0)) != null;
    }

    private boolean shouldUseNative(DateSpinner component) {
        return component.isUseNative() && (Utils.isIOS5() || Utils.isBlackBerry());
    }
}

