/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.flipswitch;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.icefaces.mobi.component.flipswitch.FlipSwitch;
import org.icefaces.mobi.renderkit.CoreRenderer;
import org.icefaces.mobi.utils.PassThruAttributeWriter;

public class FlipSwitchRenderer
extends CoreRenderer {
    private static final Logger logger = Logger.getLogger(FlipSwitchRenderer.class.getName());
    private static final String JS_NAME = "flipswitch.js";
    private static final String JS_MIN_NAME = "flipswitch-min.js";
    private static final String JS_LIBRARY = "org.icefaces.component.flipswitch";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = uiComponent.getClientId(facesContext);
        FlipSwitch flipswitch = (FlipSwitch)uiComponent;
        if (flipswitch.isDisabled()) {
            return;
        }
        String submittedString = String.valueOf(requestParameterMap.get(clientId + "_hidden"));
        if (submittedString != null) {
            boolean submittedValue = this.isChecked(submittedString);
            flipswitch.setSubmittedValue(submittedValue);
        }
        this.decodeBehaviors(facesContext, (UIComponent)flipswitch);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        FlipSwitch flipswitch = (FlipSwitch)uiComponent;
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        boolean hasBehaviors = !cbh.getClientBehaviors().isEmpty();
        this.writeJavascriptResource(facesContext, uiComponent, writer);
        writer.startElement("a", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        String styleClass = "mobi-flip-switch mobi-flip-switch-off ";
        String switchValue = String.valueOf(flipswitch.getValue());
        boolean isChecked = this.isChecked(switchValue);
        if (isChecked) {
            styleClass = "mobi-flip-switch mobi-flip-switch-on ";
        }
        writer.writeAttribute("class", (Object)styleClass, "class");
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, flipswitch.getAttributesNames());
        PassThruAttributeWriter.renderBooleanAttributes(writer, uiComponent, flipswitch.getBooleanAttNames());
        String labelOn = flipswitch.getLabelOn();
        String labelOff = flipswitch.getLabelOff();
        boolean disabled = flipswitch.isDisabled();
        boolean readonly = flipswitch.isReadonly();
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        StringBuilder builder = new StringBuilder(255);
        builder.append("mobi.flipswitch.init('").append(clientId).append("',{ event: event,elVal: this,");
        builder.append("singleSubmit: ").append(flipswitch.isSingleSubmit());
        if (hasBehaviors) {
            String behaviors = this.encodeClientBehaviors(facesContext, cbh, "click").toString();
            behaviors = behaviors.replace("\"", "'");
            builder.append(behaviors);
        }
        builder.append("});");
        String jsCall = builder.toString();
        if (!disabled | !readonly) {
            writer.writeAttribute("onclick", (Object)jsCall, null);
        }
        writer.writeAttribute("class", (Object)styleClass, "class");
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-flip-switch-txt", null);
        writer.write(labelOn);
        writer.endElement("span");
        boolean switchVal = (Boolean)flipswitch.getValue();
        this.writeHiddenField(uiComponent, clientId, writer, switchVal);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-flip-switch-txt", null);
        writer.write(labelOff);
        writer.endElement("span");
        writer.endElement("a");
    }

    private void writeJavascriptResource(FacesContext facesContext, UIComponent uiComponent, ResponseWriter writer) throws IOException {
        Map contextMap = facesContext.getViewRoot().getViewMap();
        if (!contextMap.containsKey(JS_NAME)) {
            String jsFname = JS_NAME;
            if (facesContext.isProjectStage(ProjectStage.Production)) {
                jsFname = JS_MIN_NAME;
            }
            Resource jsFile = facesContext.getApplication().getResourceHandler().createResource(jsFname, JS_LIBRARY);
            String src = jsFile.getRequestPath();
            writer.startElement("script", uiComponent);
            writer.writeAttribute("text", (Object)"text/javascript", null);
            writer.writeAttribute("src", (Object)src, null);
            writer.endElement("script");
            contextMap.put(JS_NAME, "true");
        }
    }

    private void writeHiddenField(UIComponent uiComponent, String clientId, ResponseWriter writer, boolean switchValue) throws IOException {
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)(clientId + "_hidden"), null);
        writer.writeAttribute("id", (Object)(clientId + "_hidden"), null);
        writer.writeAttribute("value", (Object)switchValue, null);
        writer.endElement("input");
    }

    private boolean isChecked(String hiddenValue) {
        return hiddenValue.equalsIgnoreCase("on") || hiddenValue.equalsIgnoreCase("yes") || hiddenValue.equalsIgnoreCase("true");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        if (submittedValue instanceof Boolean) {
            return submittedValue;
        }
        return Boolean.valueOf(submittedValue.toString());
    }

    public boolean getRendersChildren() {
        return true;
    }
}

