/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.geolocation;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.component.geolocation.Geolocation;
import org.icefaces.mobi.renderkit.CoreRenderer;

public class GeolocationRenderer
extends CoreRenderer {
    private static Logger log = Logger.getLogger(GeolocationRenderer.class.getName());
    private static final String JS_NAME = "geolocation.js";
    private static final String JS_MIN_NAME = "geolocation-min.js";
    private static final String JS_LIBRARY = "org.icefaces.component.geolocation";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        block8: {
            Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
            Geolocation geolocation = (Geolocation)uiComponent;
            String clientId = geolocation.getClientId();
            try {
                String longString;
                String[] params;
                int numberOfParams;
                String nameHidden;
                String locationString;
                if (geolocation.isDisabled() || null == (locationString = String.valueOf(requestParameterMap.get(nameHidden = clientId + "_field"))) && "null".equals(locationString) || (numberOfParams = (params = locationString.split(",\\s*")).length) <= 1) break block8;
                String latString = params[0];
                if (null != latString) {
                    try {
                        Double latitude = Double.parseDouble(latString);
                        geolocation.setLatitude(latitude);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "ERROR  parsing latitude value, defaulting to zero", e);
                        geolocation.setLatitude(0.0);
                    }
                }
                if (null != (longString = params[1])) {
                    try {
                        Double longitude = Double.parseDouble(longString);
                        geolocation.setLongitude(longitude);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "ERROR  parsing longitude value, defaulting to zero", e);
                        geolocation.setLongitude(0.0);
                    }
                }
                this.decodeBehaviors(facesContext, (UIComponent)geolocation);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error decoding geo-location request paramaters.", e);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        Geolocation locator = (Geolocation)uiComponent;
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        boolean hasBehaviors = !cbh.getClientBehaviors().isEmpty();
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)(clientId + "_locHidden"), null);
        writer.writeAttribute("name", (Object)(clientId + "_field"), null);
        boolean disabled = locator.isDisabled();
        boolean singleSubmit = locator.isSingleSubmit();
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        if (!disabled) {
            StringBuilder sb = new StringBuilder(255);
            String fnCall = "document.getElementById(\"" + clientId + "_locHidden\").value=pos.coords.latitude+\",\"+pos.coords.longitude;";
            sb.append(fnCall);
            if (hasBehaviors) {
                sb.append(this.buildAjaxRequest(facesContext, cbh, "activate"));
            } else if (singleSubmit) {
                String ssCall = "ice.se(null, '" + clientId + "');";
                sb.append(ssCall);
            }
            String finalScript = "navigator.geolocation.getCurrentPosition(function(pos) { " + sb.toString() + "} );";
            writer.startElement("script", uiComponent);
            writer.writeAttribute("id", (Object)(clientId + "_script"), "id");
            writer.write(finalScript);
            writer.endElement("script");
        }
        writer.endElement("span");
    }
}

