/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.graphicimage;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.icefaces.mobi.component.graphicimage.GraphicImage;
import org.icefaces.mobi.utils.PassThruAttributeWriter;

public class GraphicImageRenderer
extends Renderer {
    private static final Logger logger = Logger.getLogger(GraphicImageRenderer.class.toString());

    public void decode(FacesContext context, UIComponent component) {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String name;
        String scope;
        String mimeType;
        ResponseWriter writer = facesContext.getResponseWriter();
        assert (null != facesContext);
        assert (null != writer);
        assert (null != uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        GraphicImage uiGraphic = (GraphicImage)uiComponent;
        if (logger.isLoggable(Level.FINER)) {
            this.checkAttributes(uiGraphic);
        }
        writer.startElement("img", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        if (writer.getContentType().equals("application/xhtml+xml") && null == uiComponent.getAttributes().get("alt")) {
            writer.writeAttribute("alt", (Object)"", "alt");
        }
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, uiGraphic.getAttributesNames());
        PassThruAttributeWriter.renderBooleanAttributes(writer, uiComponent, uiGraphic.getBooleanAttNames());
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (null == (mimeType = uiGraphic.getMimeType())) {
            mimeType = "image/jpeg";
        }
        if (!((scope = uiGraphic.getScope().toLowerCase().trim()).equals("flash") || scope.equals("window") || scope.equals("application") || scope.equals("request") || scope.equals("view"))) {
            scope = "session";
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("setting scope to session for addition of resrouce");
            }
        }
        if (null == (name = uiGraphic.getName()) || name.equals("")) {
            name = "image" + clientId;
        }
        Object value = uiGraphic.getValue();
        String srcAttribute = uiGraphic.processSrcAttribute(facesContext, value, name, mimeType, scope);
        writer.writeAttribute("src", (Object)srcAttribute, null);
        writer.endElement("img");
    }

    private void checkAttributes(GraphicImage uiGraphic) {
        Map tempMap = uiGraphic.getAttributes();
        for (Map.Entry entry : tempMap.entrySet()) {
            logger.finer(" attribute entry is " + (String)entry.getKey() + " value is " + entry.getValue());
        }
    }
}

