/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.inputText;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.component.inputText.InputText;
import org.icefaces.mobi.renderkit.BaseInputRenderer;
import org.icefaces.mobi.utils.PassThruAttributeWriter;

public class InputTextRenderer
extends BaseInputRenderer {
    private static final Logger logger = Logger.getLogger(InputTextRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = uiComponent.getClientId(facesContext);
        InputText inputText = (InputText)uiComponent;
        if (inputText.isDisabled() || inputText.isReadonly()) {
            return;
        }
        if (requestParameterMap.containsKey(clientId)) {
            String submittedString = String.valueOf(requestParameterMap.get(clientId));
            if (submittedString == null) {
                return;
            }
            this.setSubmittedValue((UIComponent)inputText, submittedString);
        }
        this.decodeBehaviors(facesContext, (UIComponent)inputText);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        boolean hasBehaviors;
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        InputText inputText = (InputText)uiComponent;
        String type = inputText.validateType(inputText.getType());
        String componentType = "input";
        if (type.equals("textarea")) {
            componentType = "textarea";
        }
        boolean isNumberType = type.equals("number");
        boolean isDateType = type.equals("date");
        String compId = clientId;
        writer.startElement(componentType, uiComponent);
        writer.writeAttribute("id", (Object)compId, "id");
        writer.writeAttribute("name", (Object)compId, null);
        StringBuilder baseClass = new StringBuilder("mobi-input-text");
        String styleClass = inputText.getStyleClass();
        if (styleClass != null) {
            baseClass.append(" ").append(styleClass);
        }
        writer.writeAttribute("class", (Object)baseClass.toString(), null);
        String valueToRender = InputTextRenderer.getStringValueToRender(facesContext, (UIComponent)inputText);
        if (valueToRender == null && isDateType) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
            Date aDate = new Date();
            valueToRender = sdf.format(aDate);
        }
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, inputText.getCommonInputAttributeNames());
        PassThruAttributeWriter.renderBooleanAttributes(writer, uiComponent, inputText.getBooleanAttNames());
        if (type.equals("textarea")) {
            PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, inputText.getTextAreaAttributeNames());
        } else if (isNumberType) {
            PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, inputText.getNumberAttributeNames());
        } else {
            PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, inputText.getInputtextAttributeNames());
        }
        if (!isDateType) {
            writer.writeAttribute("autocorrect", (Object)"off", null);
        } else {
            writer.writeAttribute("autocorrect", (Object)"on", null);
        }
        writer.writeAttribute("autocapitalize", (Object)"off", null);
        boolean readOnly = inputText.isReadonly();
        boolean disabled = inputText.isDisabled();
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (readOnly) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (!componentType.equals("textarea")) {
            writer.writeAttribute("value", (Object)valueToRender, "value");
        } else {
            writer.write(valueToRender);
        }
        String event = inputText.getDefaultEventName(facesContext);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        boolean bl = hasBehaviors = !cbh.getClientBehaviors().isEmpty();
        if (!disabled && !readOnly && hasBehaviors) {
            String cbhCall = this.buildAjaxRequest(facesContext, cbh, event);
            writer.writeAttribute(event, (Object)cbhCall, null);
        } else if (inputText.isSingleSubmit()) {
            String jsCall = "ice.se(event, '" + clientId + "');";
            writer.writeAttribute(event, (Object)jsCall, null);
        }
        writer.endElement(componentType);
    }
}

