/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.list;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.component.list.OutputListItems;
import org.icefaces.mobi.renderkit.BaseLayoutRenderer;

public class OutputListItemsRenderer
extends BaseLayoutRenderer {
    private static Logger logger = Logger.getLogger(OutputListItemsRenderer.class.getName());

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.encodeList(facesContext, uiComponent);
    }

    public void encodeList(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        OutputListItems list = (OutputListItems)uiComponent;
        if (list.getVar() != null) {
            list.setRowIndex(-1);
            for (int i = 0; i < list.getRowCount(); ++i) {
                list.setRowIndex(i);
                writer.startElement("li", null);
                writer.writeAttribute("id", (Object)clientId, "id");
                String userDefinedClass = list.getStyleClass();
                String styleClass = "mobi-list-item";
                if (userDefinedClass != null) {
                    styleClass = styleClass + " " + userDefinedClass;
                }
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
                writer.startElement("div", uiComponent);
                writer.writeAttribute("class", (Object)"mobi-list-item-default ", null);
                this.renderChildren(facesContext, (UIComponent)list);
                writer.endElement("div");
                writer.endElement("li");
            }
            list.setRowIndex(-1);
        } else if (facesContext.isProjectStage(ProjectStage.Development) || logger.isLoggable(Level.FINER)) {
            logger.finer("OUtputListItems must define the var and value attributes");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }
}

