/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.qrcode.generator;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import org.icefaces.mobi.component.qrcode.generator.zxing.BarcodeFormat;
import org.icefaces.mobi.component.qrcode.generator.zxing.common.BitMatrix;
import org.icefaces.mobi.component.qrcode.generator.zxing.qrcode.QRCodeWriter;
import org.icefaces.util.EnvUtils;

public class QRCodeResourceHandler
extends ResourceHandlerWrapper {
    private static Logger log = Logger.getLogger(QRCodeResourceHandler.class.getName());
    private static final String RESOURCE_KEY = "javax.faces.resource";
    private static String RESOURCE_PREFIX = "/javax.faces.resource/";
    private static String QR_PREFIX = "qrcode:";
    private ResourceHandler wrapped;

    public QRCodeResourceHandler(ResourceHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        String key = QRCodeResourceHandler.extractResourceId(facesContext);
        if (null == key) {
            this.wrapped.handleResourceRequest(facesContext);
            return;
        }
        if (key.startsWith(QR_PREFIX)) {
            String encoded = key.substring(QR_PREFIX.length());
            String data = URLDecoder.decode(encoded);
            externalContext.setResponseContentType("image/png");
            OutputStream out = externalContext.getResponseOutputStream();
            QRCodeResourceHandler.writeQR(data, out);
        } else {
            this.wrapped.handleResourceRequest(facesContext);
        }
    }

    public static String getQRImageURL(String data) {
        String[] pathTemplate = EnvUtils.getPathTemplate();
        String key = QR_PREFIX + URLEncoder.encode(URLEncoder.encode(data));
        String result = pathTemplate[0] + key + pathTemplate[1];
        return result;
    }

    private static String extractResourceId(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String path = externalContext.getRequestServletPath();
        int markerStart = path.indexOf(RESOURCE_PREFIX);
        if (-1 == markerStart) {
            path = externalContext.getRequestPathInfo();
            markerStart = path.indexOf(RESOURCE_PREFIX);
        }
        if (-1 == markerStart) {
            return null;
        }
        try {
            String key = path.substring(markerStart + RESOURCE_PREFIX.length(), path.length() - EnvUtils.getPathTemplate()[1].length());
            return key;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void writeQR(String data, OutputStream out) {
        try {
            int bigEnough = 80;
            QRCodeWriter writer = new QRCodeWriter();
            BitMatrix matrix = writer.encode(data, BarcodeFormat.QR_CODE, bigEnough, bigEnough, null);
            int width = 160;
            int height = 160;
            BufferedImage bi = new BufferedImage(width, height, 2);
            Graphics2D ig2 = bi.createGraphics();
            ig2.setColor(Color.WHITE);
            ig2.fillRect(0, 0, width, height);
            ig2.setColor(Color.BLACK);
            int d = width / bigEnough;
            int bitWidth = matrix.getWidth();
            int bitHeight = matrix.getHeight();
            for (int i = 0; i < bitHeight; ++i) {
                for (int j = 0; j < bitWidth; ++j) {
                    boolean isSet = matrix.get(j, i);
                    if (!isSet) continue;
                    ig2.fillRect(d * j, d * i, d, d);
                }
            }
            ImageIO.write((RenderedImage)bi, "PNG", out);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error create QR Code image", e);
        }
    }
}

