/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.scan;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.impl.application.AuxUploadResourceHandler;
import org.icefaces.mobi.component.scan.Scan;
import org.icefaces.mobi.renderkit.BaseInputRenderer;
import org.icefaces.mobi.utils.Utils;
import org.icefaces.util.EnvUtils;

public class ScanRenderer
extends BaseInputRenderer {
    private static Logger logger = Logger.getLogger(ScanRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String submittedString;
        String valueId;
        Scan scan = (Scan)uiComponent;
        String clientId = scan.getClientId();
        if (scan.isDisabled()) {
            return;
        }
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        Object submitted = requestParameterMap.get(valueId = clientId + "-text");
        if (null == submitted) {
            Map auxMap = AuxUploadResourceHandler.getAuxRequestMap();
            submitted = auxMap.get(valueId);
        }
        if (null != submitted && (submittedString = String.valueOf(submitted)) != null) {
            Object convertedValue = this.getConvertedValue(facesContext, uiComponent, submittedString);
            this.setSubmittedValue((UIComponent)scan, convertedValue);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        Scan scan = (Scan)uiComponent;
        boolean disabled = scan.isDisabled();
        boolean isEnhanced = EnvUtils.isEnhancedBrowser((FacesContext)facesContext);
        boolean isAuxUpload = EnvUtils.isAuxUploadBrowser((FacesContext)facesContext);
        if (!isEnhanced && !isAuxUpload) {
            writer.startElement("span", uiComponent);
            writer.startElement("input", uiComponent);
            writer.writeAttribute("type", (Object)"text", null);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("name", (Object)clientId, null);
            writer.endElement("input");
            return;
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("id", (Object)(clientId + "-button"), null);
        writer.writeAttribute("value", (Object)"Scan QR Code", null);
        Utils.writeConcatenatedStyleClasses(writer, "mobi-button mobi-button-default", scan.getStyleClass());
        writer.writeAttribute("style", (Object)scan.getStyle(), "style");
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        String script = isAuxUpload ? Utils.getICEmobileSXScript("scan", clientId) : "ice.scan('" + clientId + "');";
        writer.writeAttribute("onclick", (Object)script, null);
        writer.endElement("input");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("span");
    }
}

