/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.stylesheet;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.Renderer;
import org.icefaces.mobi.component.stylesheet.DeviceStyleSheet;
import org.icefaces.mobi.utils.PassThruAttributeWriter;
import org.icefaces.mobi.utils.Utils;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class DeviceStyleSheetRenderer
extends Renderer
implements ComponentSystemEventListener {
    private static Logger log = Logger.getLogger(DeviceStyleSheetRenderer.class.getName());
    public static final String EMPTY_STRING = "";
    private static final String CSS_EXT = ".css";
    public static final String CSS_COMPRESSION_POSTFIX = "-min";
    public static final String IPHONE_CSS = Utils.DeviceType.iphone.name() + ".css";
    public static final String IPAD_CSS = Utils.DeviceType.ipad.name() + ".css";
    public static final String ANDROID_CSS = Utils.DeviceType.android.name() + ".css";
    public static final String HONEYCOMB_CSS = Utils.DeviceType.honeycomb.name() + ".css";
    public static final String BBERRY_CSS = Utils.DeviceType.bberry.name() + ".css";
    public static final String VIEW_TYPE = "view";
    public static final String VIEW_TYPE_SMALL = "small";
    public static final String VIEW_TYPE_LARGE = "large";
    private static final String DEFAULT_LIBRARY = "org.icefaces.component.skins";
    public static final String RESOURCE_URL_ERROR = "RES_NOT_FOUND";
    public static final String MOBILE_DEVICE_TYPE_KEY = "mobile_device_type";

    protected void startElement(ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("style", component);
        writer.writeAttribute("type", (Object)"text/css", "type");
    }

    public void encodeEnd(FacesContext context, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map contextMap = context.getAttributes();
        Map attributes = uiComponent.getAttributes();
        DeviceStyleSheet stylesheet = (DeviceStyleSheet)uiComponent;
        String name = (String)attributes.get("name");
        String library = (String)attributes.get("library");
        String view = (String)attributes.get(VIEW_TYPE);
        String string = name = name != null && name.equals(EMPTY_STRING) ? null : name;
        if (name == null && library == null) {
            if (contextMap.containsKey(MOBILE_DEVICE_TYPE_KEY)) {
                name = (String)contextMap.get(MOBILE_DEVICE_TYPE_KEY);
            } else if (view != null) {
                name = Utils.getDeviceType(context).name();
                if (view.equalsIgnoreCase(VIEW_TYPE_SMALL)) {
                    if (name.equals(Utils.DeviceType.ipad.name())) {
                        name = Utils.DeviceType.iphone.name();
                    } else if (name.equals(Utils.DeviceType.honeycomb.name())) {
                        name = Utils.DeviceType.android.name();
                    }
                } else if (view.equalsIgnoreCase(VIEW_TYPE_LARGE)) {
                    if (name.equals(Utils.DeviceType.iphone.name())) {
                        name = Utils.DeviceType.ipad.name();
                    } else if (name.equals(Utils.DeviceType.android.name())) {
                        name = Utils.DeviceType.honeycomb.name();
                    }
                } else {
                    log.warning("View type " + view + " is not a recognized view type");
                }
            } else {
                name = Utils.getDeviceType(context).name();
            }
            if (context.isProjectStage(ProjectStage.Production)) {
                name = name.concat(CSS_COMPRESSION_POSTFIX);
            }
            name = name.concat(CSS_EXT);
            library = DEFAULT_LIBRARY;
            contextMap.put(MOBILE_DEVICE_TYPE_KEY, name);
        } else if (name != null && library == null) {
            library = DEFAULT_LIBRARY;
        }
        Resource resource = context.getApplication().getResourceHandler().createResource(name, library);
        String resourceUrl = RESOURCE_URL_ERROR;
        if (resource != null) {
            resourceUrl = context.getExternalContext().encodeResourceURL(resource.getRequestPath());
        } else if (log.isLoggable(Level.WARNING)) {
            log.warning("Warning could not load resource " + library + "/" + name);
        }
        writer.startElement("link", uiComponent);
        writer.writeAttribute("type", (Object)"text/css", "type");
        writer.writeAttribute("rel", (Object)"stylesheet", "rel");
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, stylesheet.getPASS_THOUGH_ATTRIBUTES());
        writer.writeURIAttribute("href", (Object)resourceUrl, "href");
        writer.endElement("link");
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        FacesContext context = FacesContext.getCurrentInstance();
        if (log.isLoggable(Level.FINER)) {
            log.finer("processEvent for component = " + component.getClass().getName());
        }
        context.getViewRoot().addComponentResource(context, component, "head");
    }
}

