/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.renderkit;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseInputResourceRenderer
extends Renderer {
    private static Logger logger = Logger.getLogger(BaseInputResourceRenderer.class.getName());

    protected String getOptionAsString(FacesContext facesContext, UIInput uiComponent, Converter converter, Object value) {
        if (converter != null) {
            return converter.getAsString(facesContext, (UIComponent)uiComponent, value);
        }
        if (value == null) {
            return "";
        }
        HashMap map = (HashMap)value;
        if (map.containsKey("absolutePath")) {
            return (String)this.getPropertyFromMap(map, "absolutePath");
        }
        return "";
    }

    protected Converter getConverter(FacesContext facesContext, UIInput uiComponent) {
        Converter converter = uiComponent.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression ve = uiComponent.getValueExpression("value");
        if (ve != null) {
            Class valueType = ve.getType(facesContext.getELContext());
            return facesContext.getApplication().createConverter(valueType);
        }
        return null;
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        UIInput uiInput = (UIInput)uiComponent;
        HashMap valueMap = (HashMap)submittedValue;
        Converter converter = uiInput.getConverter();
        String value = (String)this.getPropertyFromMap(valueMap, "absolutePath");
        if (converter != null) {
            return converter.getAsObject(facesContext, (UIComponent)uiInput, value);
        }
        return submittedValue;
    }

    public static String getStringValueToRender(FacesContext facesContext, UIComponent component) {
        String value = null;
        if (component instanceof ValueHolder) {
            if (component instanceof EditableValueHolder) {
                HashMap map;
                Object submittedValue = ((EditableValueHolder)component).getSubmittedValue();
                if (submittedValue != null && (map = (HashMap)submittedValue).containsKey("absolutePath")) {
                    value = (String)map.get("absolutePath");
                }
                return value;
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object valueObj = valueHolder.getValue();
            if (valueObj == null) {
                return "";
            }
            if (valueHolder.getConverter() != null) {
                return valueHolder.getConverter().getAsString(facesContext, component, valueObj);
            }
            return "";
        }
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    public void setSubmittedValue(UIComponent uiComponent, Object value) {
        if (uiComponent instanceof UIInput) {
            ((UIInput)uiComponent).setSubmittedValue(value);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Sets submitted value to" + value + " on component  " + uiComponent.getClientId());
            }
        }
    }

    protected Object getValue(UIComponent uiComponent) {
        if (uiComponent instanceof UIInput) {
            Object value = ((UIInput)uiComponent).getValue();
            return value;
        }
        return null;
    }

    public Object getPropertyFromMap(Map<String, Object> componentMap, String key) {
        if (componentMap.containsKey(key)) {
            return componentMap.get(key);
        }
        return null;
    }

    private boolean containsKey(Map<String, Object> componentMap, String key) {
        return componentMap.containsKey(key);
    }
}

