/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.renderkit;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class CoreRenderer
extends Renderer {
    protected String buildAjaxRequest(FacesContext context, ClientBehaviorHolder component, String inEvent) {
        Map behaviorEvents = component.getClientBehaviors();
        if (behaviorEvents.isEmpty()) {
            return null;
        }
        String clientId = ((UIComponent)component).getClientId(context);
        StringBuilder req = new StringBuilder();
        List params = Collections.emptyList();
        Iterator eventIterator = behaviorEvents.keySet().iterator();
        while (eventIterator.hasNext()) {
            String event;
            String domEvent = event = (String)eventIterator.next();
            if (null != inEvent) {
                domEvent = inEvent;
            } else if (event.equalsIgnoreCase("valueChange")) {
                domEvent = "change";
            } else if (event.equalsIgnoreCase("action")) {
                domEvent = "click";
            }
            for (ClientBehavior behavior : (List)behaviorEvents.get(event)) {
                ClientBehaviorContext cbc;
                String script = behavior.getScript(cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)event, (String)clientId, params));
                if (script == null) continue;
                req.append(script);
            }
            if (!eventIterator.hasNext()) continue;
            req.append(",");
        }
        return req.toString();
    }

    public boolean isValueEmpty(String value) {
        return value == null || "".equals(value);
    }

    public boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    protected StringBuilder encodeClientBehaviors(FacesContext context, ClientBehaviorHolder component, String eventDef) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StringBuilder sb = new StringBuilder(255);
        Map behaviorEvents = component.getClientBehaviors();
        if (!behaviorEvents.isEmpty()) {
            String clientId = ((UIComponent)component).getClientId(context);
            List params = Collections.emptyList();
            sb.append(",behaviors:{");
            Iterator eventIterator = behaviorEvents.keySet().iterator();
            while (eventIterator.hasNext()) {
                String event;
                String domEvent = event = (String)eventIterator.next();
                if (null == event) {
                    event = eventDef;
                }
                if (event.equalsIgnoreCase("valueChange")) {
                    domEvent = "change";
                } else if (event.equalsIgnoreCase("action")) {
                    domEvent = "click";
                }
                sb.append(domEvent + ":");
                sb.append("function() {");
                ClientBehaviorContext cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)event, (String)clientId, params);
                for (ClientBehavior behavior : (List)behaviorEvents.get(event)) {
                    String script = behavior.getScript(cbc);
                    if (script == null) continue;
                    sb.append(script);
                }
                sb.append("}");
                if (!eventIterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
        }
        return sb;
    }

    protected void decodeBehaviors(FacesContext context, UIComponent component) {
        if (!(component instanceof ClientBehaviorHolder)) {
            return;
        }
        Map behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (null != behaviorEvent) {
            List behaviorsForEvent = (List)behaviors.get(behaviorEvent);
            if (behaviors.size() > 0) {
                String behaviorSource = (String)params.get("javax.faces.source");
                String clientId = component.getClientId();
                if (behaviorSource != null && behaviorSource.startsWith(clientId)) {
                    for (ClientBehavior behavior : behaviorsForEvent) {
                        behavior.decode(context, component);
                    }
                }
            }
        }
    }
}

