/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IceOutputResource
extends Resource
implements Serializable {
    private static final Logger logger = Logger.getLogger(IceOutputResource.class.getName());
    protected String compId;
    public static final String ICE_COMPS_LIBRARY = "javax.faces.resource";
    protected static final Map<String, String> supportedMimeTypes = new HashMap<String, String>();
    private static final String LAST_MODIFIED_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    protected String name;
    protected String libraryName;
    protected String scope;
    private Object content;

    public IceOutputResource(String compId, Object o, String mimeType) {
        this.name = compId;
        super.setResourceName(this.name);
        this.content = o;
        this.libraryName = ICE_COMPS_LIBRARY;
        super.setLibraryName(this.libraryName);
        super.setContentType(mimeType);
    }

    public InputStream getInputStream() throws IOException {
        InputStream inStream = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.fine("for name=" + super.getResourceName() + ".......getINputStream with type=" + super.getContentType());
        }
        if (null != this.content) {
            if (this.content instanceof byte[]) {
                inStream = new ByteArrayInputStream((byte[])this.content);
            } else if (this.content instanceof InputStream) {
                inStream = (InputStream)this.content;
            } else {
                try {
                    inStream = new ByteArrayInputStream(this.content.toString().getBytes());
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Unable to service request due to unsupported data type", ex);
                }
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.finer("Content stream request was null");
        }
        return inStream;
    }

    public String getRequestPath() {
        StringBuilder buf = new StringBuilder(FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath());
        ExternalContext ec = FacesContext.getCurrentInstance().getExternalContext();
        buf.append("/").append(super.getResourceName()).append(".faces?ln=").append(this.libraryName);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Request path for program resource " + this.toString() + " : '" + buf.toString() + "'");
        }
        return buf.toString();
    }

    public Map<String, String> getResponseHeaders() {
        logger.finer("getRESPONSEHEADERS MIMEType=" + super.getContentType());
        HashMap<String, String> result = new HashMap<String, String>(6, 1.0f);
        SimpleDateFormat format = new SimpleDateFormat(LAST_MODIFIED_PATTERN);
        result.put("Last-Modified", format.format(new Date()));
        result.put("Content-Type", super.getContentType());
        if (this.content instanceof byte[]) {
            result.put("Content-Length", Integer.toString(((byte[])this.content).length));
        }
        return result;
    }

    public URL getURL() {
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        StringBuilder buff = new StringBuilder(context.getRequestScheme());
        buff.append(context.getRequestServerName());
        if (context.getRequestServerPort() != 80 && context.getRequestServerPort() != 443) {
            buff.append(":").append(context.getRequestServerPort());
        }
        buff.append(this.getRequestPath());
        URL url = null;
        try {
            url = new URL(buff.toString());
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error creating IceOutputResource URL", e);
        }
        return url;
    }

    public boolean userAgentNeedsUpdate(FacesContext arg0) {
        return true;
    }

    public String toString() {
        return String.format("%s { name=%s libraryName=%s }", this.getClass().getName(), this.name, this.libraryName);
    }

    static {
        supportedMimeTypes.put("abs", "audio/x-mpeg");
        supportedMimeTypes.put("mp3", "audio/x-mpeg");
        supportedMimeTypes.put("mp3", "audio/x-mpeg");
        supportedMimeTypes.put("wav", "audio/x-wav");
        supportedMimeTypes.put("gif", "image/gif");
        supportedMimeTypes.put("tif", "image/tiff");
        supportedMimeTypes.put("jpg", "image/jpg");
        supportedMimeTypes.put("jpeg", "image/jpeg");
        supportedMimeTypes.put("png", "image/png");
    }
}

