/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.utils.Attribute;

public class PassThruAttributeWriter {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static List passThruAttributeNames = new ArrayList();
    private static List booleanPassThruAttributeNames = new ArrayList();

    public static void renderOnFocus(ResponseWriter writer) throws IOException {
        writer.writeAttribute("onfocus", (Object)"setFocus(this.id);", "onfocus");
    }

    public static void renderOnBlur(ResponseWriter writer) throws IOException {
        writer.writeAttribute("onfocus", (Object)"setFocus('');", "onfocus");
    }

    public static void renderBooleanAttributes(ResponseWriter writer, UIComponent uiComponent, Attribute[] includedAttributes) throws IOException {
        if (writer == null) {
            throw new FacesException("Null pointer exception for writer");
        }
        if (uiComponent == null) {
            throw new FacesException("Null pointer exception for uiComponent");
        }
        List<Attribute> includedAttributesList = null;
        if (includedAttributes != null && includedAttributes.length > 0) {
            includedAttributesList = Arrays.asList(includedAttributes);
        }
        Object nextPassThruAttributeValue = null;
        for (Object nextPassThruAttributeName : booleanPassThruAttributeNames) {
            boolean primitiveAttributeValue;
            if (includedAttributesList != null && includedAttributesList.contains(nextPassThruAttributeName) || (nextPassThruAttributeValue = (Object)uiComponent.getAttributes().get(nextPassThruAttributeName)) == null) continue;
            if (nextPassThruAttributeValue instanceof Boolean) {
                primitiveAttributeValue = (Boolean)nextPassThruAttributeValue;
            } else {
                if (!(nextPassThruAttributeValue instanceof String)) {
                    nextPassThruAttributeValue = nextPassThruAttributeValue.toString();
                }
                primitiveAttributeValue = new Boolean((String)nextPassThruAttributeValue);
            }
            if (!primitiveAttributeValue) continue;
            writer.writeAttribute(nextPassThruAttributeName.toString(), nextPassThruAttributeValue, nextPassThruAttributeName.toString());
        }
    }

    public static void renderNonBooleanAttributes(ResponseWriter writer, UIComponent uiComponent, Attribute[] includedAttributes) throws IOException {
        if (writer == null) {
            throw new FacesException("Null pointer exception for writer");
        }
        if (uiComponent == null) {
            throw new FacesException("Component instance is null for uiComponent");
        }
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors();
        }
        List<Attribute> includedAttributesList = null;
        if (includedAttributes != null && includedAttributes.length > 0) {
            includedAttributesList = Arrays.asList(includedAttributes);
        }
        String nextPassThruAttributeName = null;
        Object nextPassThruAttributeValue = null;
        Iterator<Attribute> passThruNameIterator = includedAttributesList.iterator();
        while (passThruNameIterator.hasNext()) {
            nextPassThruAttributeName = passThruNameIterator.next().getName();
            nextPassThruAttributeValue = uiComponent.getAttributes().get(nextPassThruAttributeName);
            if (nextPassThruAttributeValue == null || PassThruAttributeWriter.attributeValueIsSentinel(nextPassThruAttributeValue)) continue;
            writer.writeAttribute(nextPassThruAttributeName.toString(), nextPassThruAttributeValue, nextPassThruAttributeValue.toString());
        }
    }

    public static boolean passThruAttributeExists(UIComponent uiComponent) {
        if (uiComponent == null) {
            return false;
        }
        Map componentAttributes = uiComponent.getAttributes();
        if (componentAttributes.size() <= 0) {
            return false;
        }
        if (PassThruAttributeWriter.componentAttributesIncludePassThruAttribute(componentAttributes, passThruAttributeNames)) {
            return true;
        }
        return PassThruAttributeWriter.componentAttributesIncludePassThruAttribute(componentAttributes, booleanPassThruAttributeNames);
    }

    private static boolean attributeValueIsSentinel(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return (Integer)value == Integer.MIN_VALUE;
            }
            if (value instanceof Long) {
                return (Long)value == Long.MIN_VALUE;
            }
            if (value instanceof Short) {
                return (Short)value == Short.MIN_VALUE;
            }
            if (value instanceof Float) {
                return ((Float)value).floatValue() == Float.MIN_VALUE;
            }
            if (value instanceof Double) {
                return (Double)value == Double.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return (Byte)value == -128;
            }
        }
        if (value instanceof Character) {
            return ((Character)value).charValue() == '\u0000';
        }
        return false;
    }

    private static boolean componentAttributesIncludePassThruAttribute(Map componentAttributes, List passThru) {
        for (Object componentAttributeKey : componentAttributes.keySet()) {
            Object componentAttributeValue;
            if (!passThru.contains(componentAttributeKey) || (componentAttributeValue = componentAttributes.get(componentAttributeKey)) == null || componentAttributeValue == "") continue;
            return true;
        }
        return false;
    }

    static final List getpassThruAttributeNames() {
        return passThruAttributeNames;
    }

    public static void renderHtmlAttributes(ResponseWriter writer, UIComponent uiComponent, String[] htmlAttributes) throws IOException {
        if (writer == null) {
            throw new FacesException("Null pointer exception");
        }
        if (uiComponent == null) {
            throw new FacesException("Component instance is null");
        }
        List attributesThatAreSet = (List)uiComponent.getAttributes().get("javax.faces.component.UIComponentBase.attrbiutesThatAreSet");
        if (attributesThatAreSet.size() > 0) {
            String nextPassThruAttributeName = null;
            Object nextPassThruAttributeValue = null;
            for (int i = 0; i < htmlAttributes.length; ++i) {
                nextPassThruAttributeName = htmlAttributes[i];
                if (!attributesThatAreSet.contains(nextPassThruAttributeName) || (nextPassThruAttributeValue = (Object)uiComponent.getAttributes().get(nextPassThruAttributeName)) == null || PassThruAttributeWriter.valueIsIntegerSentinelValue(nextPassThruAttributeValue)) continue;
                writer.writeAttribute(nextPassThruAttributeName, nextPassThruAttributeValue, nextPassThruAttributeValue.toString());
            }
        }
    }

    private static boolean valueIsIntegerSentinelValue(Object value) {
        if (value instanceof String) {
            return false;
        }
        if (value instanceof Number && value instanceof Integer) {
            return (Integer)value == Integer.MIN_VALUE;
        }
        return false;
    }

    static {
        passThruAttributeNames.add("accept");
        passThruAttributeNames.add("accesskey");
        passThruAttributeNames.add("alt");
        passThruAttributeNames.add("bgcolor");
        passThruAttributeNames.add("border");
        passThruAttributeNames.add("cellpadding");
        passThruAttributeNames.add("cellspacing");
        passThruAttributeNames.add("charset");
        passThruAttributeNames.add("cols");
        passThruAttributeNames.add("coords");
        passThruAttributeNames.add("dir");
        passThruAttributeNames.add("enctype");
        passThruAttributeNames.add("frame");
        passThruAttributeNames.add("height");
        passThruAttributeNames.add("hreflang");
        passThruAttributeNames.add("lang");
        passThruAttributeNames.add("longdesc");
        passThruAttributeNames.add("maxlength");
        passThruAttributeNames.add("onblur");
        passThruAttributeNames.add("onchange");
        passThruAttributeNames.add("onclick");
        passThruAttributeNames.add("ondblclick");
        passThruAttributeNames.add("onfocus");
        passThruAttributeNames.add("onkeydown");
        passThruAttributeNames.add("onkeypress");
        passThruAttributeNames.add("onkeyup");
        passThruAttributeNames.add("onload");
        passThruAttributeNames.add("onmousedown");
        passThruAttributeNames.add("onmousemove");
        passThruAttributeNames.add("onmouseout");
        passThruAttributeNames.add("onmouseover");
        passThruAttributeNames.add("onmouseup");
        passThruAttributeNames.add("onreset");
        passThruAttributeNames.add("onselect");
        passThruAttributeNames.add("onsubmit");
        passThruAttributeNames.add("onunload");
        passThruAttributeNames.add("rel");
        passThruAttributeNames.add("rev");
        passThruAttributeNames.add("rows");
        passThruAttributeNames.add("rules");
        passThruAttributeNames.add("shape");
        passThruAttributeNames.add("size");
        passThruAttributeNames.add("style");
        passThruAttributeNames.add("summary");
        passThruAttributeNames.add("tabindex");
        passThruAttributeNames.add("target");
        passThruAttributeNames.add("title");
        passThruAttributeNames.add("usemap");
        passThruAttributeNames.add("width");
        passThruAttributeNames.add("autocomplete");
        booleanPassThruAttributeNames.add("disabled");
        booleanPassThruAttributeNames.add("readonly");
        booleanPassThruAttributeNames.add("ismap");
    }
}

