/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.utils;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ScriptWriter {
    private final ResponseWriter writer;
    private final UIComponent component;

    public static void insertScript(FacesContext context, UIComponent component, String script) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ScriptWriter.writeScriptStart(writer, component);
        writer.write(script);
        ScriptWriter.writeScriptEnd(writer);
    }

    public static void insertScript(FacesContext context, UIComponent component, String script, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ScriptWriter.writeScriptStart(writer, component, id);
        writer.write(script);
        ScriptWriter.writeScriptEnd(writer);
    }

    public static ScriptWriter insertScript(FacesContext context, UIComponent component) throws IOException {
        return new ScriptWriter(context.getResponseWriter(), component);
    }

    public ScriptWriter(ResponseWriter writer, UIComponent component) {
        this.writer = writer;
        this.component = component;
    }

    public void startScript() throws IOException {
        ScriptWriter.writeScriptStart(this.writer, this.component);
    }

    public void write(String val) throws IOException {
        this.writer.write(val);
    }

    public void write(int val) throws IOException {
        this.writer.write(Integer.toString(val));
    }

    public void write(long val) throws IOException {
        this.writer.write(Long.toString(val));
    }

    public void write(double val) throws IOException {
        this.writer.write(Double.toString(val));
    }

    public void write(float val) throws IOException {
        this.writer.write(Float.toString(val));
    }

    public void write(boolean val) throws IOException {
        this.writer.write(Boolean.toString(val));
    }

    public void write(char val) throws IOException {
        this.writer.write((int)val);
    }

    public void write(Object val) throws IOException {
        this.writer.write(String.valueOf(val));
    }

    public void endScript() throws IOException {
        ScriptWriter.writeScriptEnd(this.writer);
    }

    private static void writeScriptStart(ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("span", component);
        writer.writeAttribute("id", (Object)(component.getClientId() + "_script"), null);
        writer.startElement("script", component);
    }

    private static void writeScriptStart(ResponseWriter writer, UIComponent component, String id) throws IOException {
        writer.startElement("span", component);
        writer.writeAttribute("id", (Object)id, null);
        writer.startElement("script", component);
    }

    private static void writeScriptEnd(ResponseWriter writer) throws IOException {
        writer.endElement("script");
        writer.endElement("span");
    }
}

