/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.utils;

import java.util.logging.Level;
import java.util.logging.Logger;

public class UserAgentInfo {
    private static Logger log = Logger.getLogger(UserAgentInfo.class.getName());
    private String userAgentString;
    private String httpAccepted;
    public static final String deviceIphone = "iphone";
    public static final String deviceIpad = "ipad";
    public static final String deviceIpod = "ipod";
    public static final String deviceMac = "macintosh";
    public static final String deviceAndroid = "android";
    public static final String deviceHoneyComb = "android 3.";
    public static final String deviceBlackB = "blackberry";
    public static final String deviceBBCurve = "blackberry89";
    public static final String deviceBBTorch = "blackberry 98";
    public static final String vndRIM = "vnd.rim";
    public static final String deviceIOS5 = " os 5_0";

    public UserAgentInfo(String userAgent, String httpAcc) {
        if (userAgent != null) {
            this.userAgentString = userAgent.toLowerCase();
        }
        if (httpAcc != null) {
            this.httpAccepted = httpAcc.toLowerCase();
        }
    }

    public UserAgentInfo(String userAgent) {
        if (userAgent != null) {
            this.userAgentString = userAgent.toLowerCase();
        }
        this.httpAccepted = "*/*";
    }

    public boolean sniffIpod() {
        boolean result = this.userAgentString.indexOf(deviceIpod) != -1;
        this.logSniff(result, "iPod", this.userAgentString);
        return result;
    }

    public boolean sniffIphone() {
        boolean result = this.userAgentString.indexOf(deviceIphone) != -1 && !this.sniffIpod() && !this.sniffIpad();
        this.logSniff(result, "iPod", this.userAgentString);
        return result;
    }

    public boolean sniffIOS() {
        boolean result = this.sniffIphone() || this.sniffIpod() || this.sniffIpad();
        this.logSniff(result, "iOS", this.userAgentString);
        return result;
    }

    public boolean sniffIOS5() {
        boolean result = this.userAgentString.indexOf(deviceIOS5) != -1;
        this.logSniff(result, "iOS5", this.userAgentString);
        return result;
    }

    public boolean sniffIpad() {
        boolean result = this.userAgentString.indexOf(deviceIpad) != -1;
        this.logSniff(result, "iPad", this.userAgentString);
        return result;
    }

    public boolean sniffAndroid() {
        boolean foundAndroid = this.userAgentString.contains(deviceAndroid);
        this.logSniff(foundAndroid, "Android Mobile", this.userAgentString);
        return foundAndroid;
    }

    public boolean sniffAndroidTablet() {
        boolean result = this.userAgentString.contains(deviceHoneyComb) || this.userAgentString.contains(deviceAndroid) && !this.userAgentString.contains("mobile safari");
        this.logSniff(result, "Android Tablet", this.userAgentString);
        return result;
    }

    public boolean sniffBlackberry() {
        boolean result = this.userAgentString.contains(deviceBlackB) || this.httpAccepted.contains(vndRIM);
        this.logSniff(result, "BlackBerry", this.userAgentString);
        return result;
    }

    private void logSniff(boolean result, String device, String userAgent) {
        if (log.isLoggable(Level.FINEST) && result) {
            log.finest("Detected " + device + " " + this.userAgentString);
        }
    }
}

