/*
 * Copyright 2004-2012 ICEsoft Technologies Canada Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */


if (!window['mobi']) {
    window.mobi = {};
}
mobi.BEHAVIOR_EVENT_PARAM = "javax.faces.behavior.event";
mobi.PARTIAL_EVENT_PARAM = "javax.faces.partial.event";
mobi.findForm = function(sourceId){
     var node = document.getElementById(sourceId);
     while (node.nodeName != "FORM" && node.parentNode){
         node=node.parentNode;
     }
    ice.log.debug(ice.log, 'parent form node ='+node.name);
    return node;
};
mobi.AjaxRequest = function(cfg) {

    if(cfg.onstart && !cfg.onstart.call(this)) {
       return;//cancel request
    }
    ice.log.debug(ice.log, 'creating ajax request');
    var form = mobi.findForm(cfg.source);
    if (form){
        ice.log.debug(ice.log, 'found form with name='+form.name);
        ice.log.debug(ice.log, ' length of forms ='+form.length);
    }

    var source = (typeof cfg.source == 'string') ? document.getElementById(cfg.source) : cfg.source;
    var jsfExecute = cfg.execute || '@all';
    var jsfRender = cfg.render || '@all';

    ice.fullSubmit(jsfExecute, jsfRender, null, source || form[0], function(parameter) {
        if(cfg.event) {
            parameter(mobi.BEHAVIOR_EVENT_PARAM, cfg.event);

            var domEvent = cfg.event;
            if(cfg.event == 'valueChange') {
                domEvent = 'change';
            } else if (cfg.event == 'action') {
                domEvent = 'click';
            }

            parameter(mobi.PARTIAL_EVENT_PARAM, domEvent);
        } else {
            parameter(cfg.source, cfg.source);
        }

        if(cfg.params) {
            var cfgParams = cfg.params;
            for(var p in cfgParams) {
                parameter(p, cfgParams[p]);
            }
        }
    }, function(onBeforeSubmit, onBeforeUpdate, onAfterUpdate, onNetworkError, onServerError) {
        var context = {};
        onAfterUpdate(function(responseXML) {
            if (cfg.onsuccess && !cfg.onsuccess.call(context, responseXML, null /*status*/, null /*xhr*/)) {
                return;
            }
            mobi.AjaxResponse.call(context, responseXML);
        });
        if (cfg.oncomplete) {
            onAfterUpdate(function(responseXML) {
                cfg.oncomplete.call(context, null /*xhr*/, null /*status*/, context.args);
            });
        }
        if (cfg.onerror) {
            onNetworkError(function(responseCode, errorDescription) {
                cfg.onerror.call(context, null /*xhr*/, responseCode /*status*/, errorDescription /*error description*/)
            });
            onServerError(function(responseCode, responseText) {
                cfg.onerror.call(context, null /*xhr*/, responseCode /*status*/, responseText /*error description*/)
            });
        }
    });
};

mobi.AjaxResponse = function(responseXML) {
    var xmlDoc = responseXML.documentElement;
    var extensions = xmlDoc.getElementsByTagName("extension");
    //can't do this unless the browser has JSON support ECMAScript 5
    if (! (typeof(JSON) === 'object' &&
            typeof(JSON.parse) === 'function')) {
          // Native JSON parsing is not available.
        ice.log.debug(ice.log,' do not have JSON support for parsing the response update');
    }
    this.args = {};
    for(var i = 0, l = extensions.length; i < l; i++) {
        var extension = extensions[i];
        if (extension.getAttributeNode('aceCallbackParam')) {
           // var jsonObj = ice.ace.jq.parseJSON(extension.firstChild.data);
            //no jquery available so assuming ECMAScript 5 JSON
            var jsonObj = JSON.parse(extension.firstChild.data);
            for(var paramName in jsonObj) {
                if(paramName) {
                    this.args[paramName] = jsonObj[paramName];
                }
            }
        }
    }
};

mobi.registerAuxUpload = function(sessionid, uploadURL)  {
    var auxiframe = document.getElementById('auxiframe');
    if (null == auxiframe)  {
        auxiframe = document.createElement('iframe');
        auxiframe.setAttribute("id", "auxiframe");
        auxiframe.setAttribute("style", "width:0px; height:0px; border: 0px");
        auxiframe.setAttribute("src", 
            "icemobile://c=register&r=" +
                escape(window.location) + "&JSESSIONID=" + sessionid +
                "&u=" + escape(uploadURL)
        );
        document.body.appendChild(auxiframe);
    }
};

function html5getViewState(form) {
    if (!form) {
        throw new Error("jsf.getViewState:  form must be set");
    }
    var els = form.elements;
    var len = els.length;
    var qString = [];
    var addField = function(name, value) {
        var tmpStr = "";
        if (qString.length > 0) {
            tmpStr = "&";
        }
        tmpStr += encodeURIComponent(name) + "=" + encodeURIComponent(value);
        qString.push(tmpStr);
    };
    for (var i = 0; i < len; i++) {
        var el = els[i];
        if (!el.disabled) {
            switch (el.type) {
                case 'submit':
                case 'button':
                    break;
                case 'text':
                case 'password':
                case 'hidden':
                case 'textarea':
                    addField(el.name, el.value);
                    break;
                case 'select-one':
                    if (el.selectedIndex >= 0) {
                        addField(el.name, el.options[el.selectedIndex].value);
                    }
                    break;
                case 'select-multiple':
                    for (var j = 0; j < el.options.length; j++) {
                        if (el.options[j].selected) {
                            addField(el.name, el.options[j].value);
                        }
                    }
                    break;
                case 'checkbox':
                case 'radio':
                    if (el.checked) {
                        addField(el.name, el.value);
                    }
                    break;
                default:
                    addField(el.name, el.value);
            }
        }
    }
    // concatenate the array
    return qString.join("");
};

function html5handleResponse(context, data)  {
    if (null == context.sourceid)  {
        //was not a jsf upload
        return;
    }

    var jsfResponse = {};
    var parser = new DOMParser();
    var xmlDoc = parser.parseFromString(data, "text/xml");

    jsfResponse.responseXML = xmlDoc;
    jsf.ajax.response(jsfResponse, context);

}


function html5submitFunction(element, event, options) {
    var source = event ? event.target : element;
    var form = element;
    while ((null != form) && ("form" != form.tagName.toLowerCase()))  {
        form = form.parentNode;
    }
    var formData = new FormData(form);
    var formId = form.id;
    var sourceId = element ? element.id : event.target.id;

    if ("@this" === options.execute)  {
        options.execute = sourceId;
    } else if ("@form" === options.execute)  {
        options.execute = formId;
    }
    if ("@this" === options.render)  {
        options.render = sourceId;
    } else if ("@form" === options.render)  {
        options.render = formId;
    }
    if (!options.execute)  {
        options.execute = "@all";
    }
    if (!options.render)  {
        options.render = "@all";
    }

    formData.append("javax.faces.source", sourceId);
    formData.append(source.name, source.value);
    formData.append("javax.faces.partial.execute", options.execute);
    formData.append("javax.faces.partial.render", options.render);
    formData.append("javax.faces.partial.ajax", "true");

    if (event) {
        formData.append("javax.faces.partial.event", event.type);
    }

    if (options) {
        for (var p in options) {
            if ("function" != typeof(options[p]))  {
                formData.append(p, options[p]);
            }
        }
    }

    var context = {
        sourceid: sourceId,
        formid: formId,
        onevent: null,
        onerror: function(param)  {
            alert("JSF error " + param.source + " " + param.description);
        }
    }

    var xhr = new XMLHttpRequest();  
    xhr.open("POST", form.getAttribute("action"));
    xhr.setRequestHeader("Faces-Request", "partial/ajax");
    xhr.onreadystatechange = function() {
        if ( (4 == xhr.readyState) && (200 == xhr.status) )  {
            html5handleResponse(context, xhr.responseText);
        }
    };
    xhr.send(formData);
}

if (window.addEventListener)  {
    window.addEventListener( "load",
    function() {
        jsf.getViewState = html5getViewState;
        if ( (undefined !== window.FormData) && 
             (undefined === window.ice.mobile) &&
             ((undefined === window.clientInformation) || ("BlackBerry" !== window.clientInformation.platform)) &&
             (undefined !== window.Worker) )  {
            ice.submitFunction = html5submitFunction;
        }
    }, false );

    window.addEventListener("pagehide", function() { 
        if (ice.push)  {
            ice.push.connection.pauseConnection(); 
        }
    }, false); 
    
    window.addEventListener("pageshow", function() { 
        if (ice.push)  {
            ice.push.connection.resumeConnection(); 
        }
    }, false); 
}
/*
 * Copyright 2004-2012 ICEsoft Technologies Canada Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

(function() {
    var m = Math,
            vendor = (/webkit/i).test(navigator.appVersion) ? 'webkit' :
                    (/firefox/i).test(navigator.userAgent) ? 'Moz' :
                            'opera' in window ? 'O' : '',

        // Browser capabilities
            has3d = 'WebKitCSSMatrix' in window && 'm11' in new WebKitCSSMatrix(),
            hasTouch = 'ontouchstart' in window,
            hasTransform = vendor + 'Transform' in document.documentElement.style,
            isAndroid = (/android/gi).test(navigator.appVersion),
            isIDevice = (/iphone|ipad/gi).test(navigator.appVersion),
            isPlaybook = (/playbook/gi).test(navigator.appVersion),
            hasTransitionEnd = isIDevice || isPlaybook,
            nextFrame = (function() {
                return window.requestAnimationFrame
                        || window.webkitRequestAnimationFrame
                        || window.mozRequestAnimationFrame
                        || window.oRequestAnimationFrame
                        || window.msRequestAnimationFrame
                        || function(callback) {
                    return setTimeout(callback, 1);
                }
            })(),
            cancelFrame = (function () {
                return window.cancelRequestAnimationFrame
                        || window.webkitCancelRequestAnimationFrame
                        || window.mozCancelRequestAnimationFrame
                        || window.oCancelRequestAnimationFrame
                        || window.msCancelRequestAnimationFrame
                        || clearTimeout
            })(),

        // Events
            RESIZE_EV = 'onorientationchange' in window ? 'orientationchange' : 'resize',
            START_EV = hasTouch ? 'touchstart' : 'mousedown',
            MOVE_EV = hasTouch ? 'touchmove' : 'mousemove',
            END_EV = hasTouch ? 'touchend' : 'mouseup',
            CANCEL_EV = hasTouch ? 'touchcancel' : 'mouseup',
            WHEEL_EV = vendor == 'Moz' ? 'DOMMouseScroll' : 'mousewheel',

        // Helpers
            trnOpen = 'translate' + (has3d ? '3d(' : '('),
            trnClose = has3d ? ',0)' : ')',

        // Constructor
            iScroll = function (el, options) {
                var that = this,
                        doc = document,
                        i;

                that.wrapper = typeof el == 'object' ? el : doc.getElementById(el);
                that.wrapper.style.overflow = 'hidden';
                that.scroller = that.wrapper.children[0];

                // Default options
                that.options = {
                    hScroll: true,
                    vScroll: true,
                    bounce: true,
                    bounceLock: false,
                    momentum: true,
                    lockDirection: true,
                    useTransform: true,
                    useTransition: false,
                    topOffset: 0,
                    checkDOMChanges: false,        // Experimental

                    // Scrollbar
                    hScrollbar: true,
                    vScrollbar: true,
                    fixedScrollbar: isAndroid,
                    hideScrollbar: isIDevice,
                    fadeScrollbar: isIDevice && has3d,
                    scrollbarClass: '',

                    // Zoom
                    zoom: false,
                    zoomMin: 1,
                    zoomMax: 4,
                    doubleTapZoom: 2,
                    wheelAction: 'scroll',

                    // Snap
                    snap: false,
                    snapThreshold: 1,

                    // Events
                    onRefresh: null,
                    onBeforeScrollStart: function (e) {
                        e.preventDefault();
                    },
                    onScrollStart: null,
                    onBeforeScrollMove: null,
                    onScrollMove: null,
                    onBeforeScrollEnd: null,
                    onScrollEnd: null,
                    onTouchEnd: null,
                    onDestroy: null,
                    onZoomStart: null,
                    onZoom: null,
                    onZoomEnd: null
                };

                // User defined options
                for (i in options) that.options[i] = options[i];

                // Normalize options
                that.options.useTransform = hasTransform ? that.options.useTransform : false;
                that.options.hScrollbar = that.options.hScroll && that.options.hScrollbar;
                that.options.vScrollbar = that.options.vScroll && that.options.vScrollbar;
                that.options.zoom = that.options.useTransform && that.options.zoom;
                that.options.useTransition = hasTransitionEnd && that.options.useTransition;

                // Set some default styles
                that.scroller.style[vendor + 'TransitionProperty'] = that.options.useTransform ? '-' + vendor.toLowerCase() + '-transform' : 'top left';
                that.scroller.style[vendor + 'TransitionDuration'] = '0';
                that.scroller.style[vendor + 'TransformOrigin'] = '0 0';
                if (that.options.useTransition) that.scroller.style[vendor + 'TransitionTimingFunction'] = 'cubic-bezier(0.33,0.66,0.66,1)';

                if (that.options.useTransform) that.scroller.style[vendor + 'Transform'] = trnOpen + '0,0' + trnClose;
                else that.scroller.style.cssText += ';position:absolute;top:0;left:0';

                if (that.options.useTransition) that.options.fixedScrollbar = true;

                that.refresh();

                that._bind(RESIZE_EV, window);
                that._bind(START_EV);
                if (!hasTouch) {
                    that._bind('mouseout', that.wrapper);
                    that._bind(WHEEL_EV);
                }

                if (that.options.checkDOMChanges) that.checkDOMTime = setInterval(function () {
                    that._checkDOMChanges();
                }, 500);
            };

// Prototype
    iScroll.prototype = {
        enabled: true,
        x: 0,
        y: 0,
        steps: [],
        scale: 1,
        currPageX: 0, currPageY: 0,
        pagesX: [], pagesY: [],
        aniTime: null,
        wheelZoomCount: 0,

        handleEvent: function (e) {
            var that = this;
            switch (e.type) {
                case START_EV:
                    if (!hasTouch && e.button !== 0) return;
                    that._start(e);
                    break;
                case MOVE_EV:
                    that._move(e);
                    break;
                case END_EV:
                case CANCEL_EV:
                    that._end(e);
                    break;
                case RESIZE_EV:
                    that._resize();
                    break;
                case WHEEL_EV:
                    that._wheel(e);
                    break;
                case 'mouseout':
                    that._mouseout(e);
                    break;
                case 'webkitTransitionEnd':
                    that._transitionEnd(e);
                    break;
            }
        },

        _checkDOMChanges: function () {
            if (this.moved || this.zoomed || this.animating ||
                    (this.scrollerW == this.scroller.offsetWidth * this.scale && this.scrollerH == this.scroller.offsetHeight * this.scale)) return;

            this.refresh();
        },

        _scrollbar: function (dir) {
            var that = this,
                    doc = document,
                    bar;

            if (!that[dir + 'Scrollbar']) {
                if (that[dir + 'ScrollbarWrapper']) {
                    if (hasTransform) that[dir + 'ScrollbarIndicator'].style[vendor + 'Transform'] = '';
                    that[dir + 'ScrollbarWrapper'].parentNode.removeChild(that[dir + 'ScrollbarWrapper']);
                    that[dir + 'ScrollbarWrapper'] = null;
                    that[dir + 'ScrollbarIndicator'] = null;
                }

                return;
            }

            if (!that[dir + 'ScrollbarWrapper']) {
                // Create the scrollbar wrapper
                bar = doc.createElement('div');

                if (that.options.scrollbarClass) bar.className = that.options.scrollbarClass + dir.toUpperCase();
                else bar.style.cssText = 'position:absolute;z-index:100;' + (dir == 'h' ? 'height:7px;bottom:1px;left:2px;right:' + (that.vScrollbar ? '7' : '2') + 'px' : 'width:7px;bottom:' + (that.hScrollbar ? '7' : '2') + 'px;top:2px;right:1px');

                bar.style.cssText += ';pointer-events:none;-' + vendor + '-transition-property:opacity;-' + vendor + '-transition-duration:' + (that.options.fadeScrollbar ? '350ms' : '0') + ';overflow:hidden;opacity:' + (that.options.hideScrollbar ? '0' : '1');

                that.wrapper.appendChild(bar);
                that[dir + 'ScrollbarWrapper'] = bar;

                // Create the scrollbar indicator
                bar = doc.createElement('div');
                if (!that.options.scrollbarClass) {
                    bar.style.cssText = 'position:absolute;z-index:100;background:rgba(0,0,0,0.5);border:1px solid rgba(255,255,255,0.9);-' + vendor + '-background-clip:padding-box;-' + vendor + '-box-sizing:border-box;' + (dir == 'h' ? 'height:100%' : 'width:100%') + ';-' + vendor + '-border-radius:3px;border-radius:3px';
                }
                bar.style.cssText += ';pointer-events:none;-' + vendor + '-transition-property:-' + vendor + '-transform;-' + vendor + '-transition-timing-function:cubic-bezier(0.33,0.66,0.66,1);-' + vendor + '-transition-duration:0;-' + vendor + '-transform:' + trnOpen + '0,0' + trnClose;
                if (that.options.useTransition) bar.style.cssText += ';-' + vendor + '-transition-timing-function:cubic-bezier(0.33,0.66,0.66,1)';

                that[dir + 'ScrollbarWrapper'].appendChild(bar);
                that[dir + 'ScrollbarIndicator'] = bar;
            }

            if (dir == 'h') {
                that.hScrollbarSize = that.hScrollbarWrapper.clientWidth;
                that.hScrollbarIndicatorSize = m.max(m.round(that.hScrollbarSize * that.hScrollbarSize / that.scrollerW), 8);
                that.hScrollbarIndicator.style.width = that.hScrollbarIndicatorSize + 'px';
                that.hScrollbarMaxScroll = that.hScrollbarSize - that.hScrollbarIndicatorSize;
                that.hScrollbarProp = that.hScrollbarMaxScroll / that.maxScrollX;
            } else {
                that.vScrollbarSize = that.vScrollbarWrapper.clientHeight;
                that.vScrollbarIndicatorSize = m.max(m.round(that.vScrollbarSize * that.vScrollbarSize / that.scrollerH), 8);
                that.vScrollbarIndicator.style.height = that.vScrollbarIndicatorSize + 'px';
                that.vScrollbarMaxScroll = that.vScrollbarSize - that.vScrollbarIndicatorSize;
                that.vScrollbarProp = that.vScrollbarMaxScroll / that.maxScrollY;
            }

            // Reset position
            that._scrollbarPos(dir, true);
        },

        _resize: function () {
            var that = this;
            setTimeout(function () {
                that.refresh();
            }, isAndroid ? 200 : 0);
        },

        _pos: function (x, y) {
            x = this.hScroll ? x : 0;
            y = this.vScroll ? y : 0;

            if (this.options.useTransform) {
                this.scroller.style[vendor + 'Transform'] = trnOpen + x + 'px,' + y + 'px' + trnClose + ' scale(' + this.scale + ')';
            } else {
                x = m.round(x);
                y = m.round(y);
                this.scroller.style.left = x + 'px';
                this.scroller.style.top = y + 'px';
            }

            this.x = x;
            this.y = y;

            this._scrollbarPos('h');
            this._scrollbarPos('v');
        },

        _scrollbarPos: function (dir, hidden) {
            var that = this,
                    pos = dir == 'h' ? that.x : that.y,
                    size;

            if (!that[dir + 'Scrollbar']) return;

            pos = that[dir + 'ScrollbarProp'] * pos;

            if (pos < 0) {
                if (!that.options.fixedScrollbar) {
                    size = that[dir + 'ScrollbarIndicatorSize'] + m.round(pos * 3);
                    if (size < 8) size = 8;
                    that[dir + 'ScrollbarIndicator'].style[dir == 'h' ? 'width' : 'height'] = size + 'px';
                }
                pos = 0;
            } else if (pos > that[dir + 'ScrollbarMaxScroll']) {
                if (!that.options.fixedScrollbar) {
                    size = that[dir + 'ScrollbarIndicatorSize'] - m.round((pos - that[dir + 'ScrollbarMaxScroll']) * 3);
                    if (size < 8) size = 8;
                    that[dir + 'ScrollbarIndicator'].style[dir == 'h' ? 'width' : 'height'] = size + 'px';
                    pos = that[dir + 'ScrollbarMaxScroll'] + (that[dir + 'ScrollbarIndicatorSize'] - size);
                } else {
                    pos = that[dir + 'ScrollbarMaxScroll'];
                }
            }

            that[dir + 'ScrollbarWrapper'].style[vendor + 'TransitionDelay'] = '0';
            that[dir + 'ScrollbarWrapper'].style.opacity = hidden && that.options.hideScrollbar ? '0' : '1';
            that[dir + 'ScrollbarIndicator'].style[vendor + 'Transform'] = trnOpen + (dir == 'h' ? pos + 'px,0' : '0,' + pos + 'px') + trnClose;
        },

        _start: function (e) {
            var that = this,
                    point = hasTouch ? e.touches[0] : e,
                    matrix, x, y,
                    c1, c2;

            if (!that.enabled) return;

            if (that.options.onBeforeScrollStart) that.options.onBeforeScrollStart.call(that, e);

            if (that.options.useTransition || that.options.zoom) that._transitionTime(0);

            that.moved = false;
            that.animating = false;
            that.zoomed = false;
            that.distX = 0;
            that.distY = 0;
            that.absDistX = 0;
            that.absDistY = 0;
            that.dirX = 0;
            that.dirY = 0;

            // Gesture start
            if (that.options.zoom && hasTouch && e.touches.length > 1) {
                c1 = m.abs(e.touches[0].pageX - e.touches[1].pageX);
                c2 = m.abs(e.touches[0].pageY - e.touches[1].pageY);
                that.touchesDistStart = m.sqrt(c1 * c1 + c2 * c2);

                that.originX = m.abs(e.touches[0].pageX + e.touches[1].pageX - that.wrapperOffsetLeft * 2) / 2 - that.x;
                that.originY = m.abs(e.touches[0].pageY + e.touches[1].pageY - that.wrapperOffsetTop * 2) / 2 - that.y;

                if (that.options.onZoomStart) that.options.onZoomStart.call(that, e);
            }

            if (that.options.momentum) {
                if (that.options.useTransform) {
                    // Very lame general purpose alternative to CSSMatrix
                    matrix = getComputedStyle(that.scroller, null)[vendor + 'Transform'].replace(/[^0-9-.,]/g, '').split(',');
                    x = matrix[4] * 1;
                    y = matrix[5] * 1;
                } else {
                    x = getComputedStyle(that.scroller, null).left.replace(/[^0-9-]/g, '') * 1;
                    y = getComputedStyle(that.scroller, null).top.replace(/[^0-9-]/g, '') * 1;
                }

                if (x != that.x || y != that.y) {
                    if (that.options.useTransition) that._unbind('webkitTransitionEnd');
                    else cancelFrame(that.aniTime);
                    that.steps = [];
                    that._pos(x, y);
                }
            }

            that.absStartX = that.x;	// Needed by snap threshold
            that.absStartY = that.y;

            that.startX = that.x;
            that.startY = that.y;
            that.pointX = point.pageX;
            that.pointY = point.pageY;

            that.startTime = e.timeStamp || (new Date()).getTime();

            if (that.options.onScrollStart) that.options.onScrollStart.call(that, e);

            that._bind(MOVE_EV);
            that._bind(END_EV);
            that._bind(CANCEL_EV);
        },

        _move: function (e) {
            var that = this,
                    point = hasTouch ? e.touches[0] : e,
                    deltaX = point.pageX - that.pointX,
                    deltaY = point.pageY - that.pointY,
                    newX = that.x + deltaX,
                    newY = that.y + deltaY,
                    c1, c2, scale,
                    timestamp = e.timeStamp || (new Date()).getTime();

            if (that.options.onBeforeScrollMove) that.options.onBeforeScrollMove.call(that, e);

            // Zoom
            if (that.options.zoom && hasTouch && e.touches.length > 1) {
                c1 = m.abs(e.touches[0].pageX - e.touches[1].pageX);
                c2 = m.abs(e.touches[0].pageY - e.touches[1].pageY);
                that.touchesDist = m.sqrt(c1 * c1 + c2 * c2);

                that.zoomed = true;

                scale = 1 / that.touchesDistStart * that.touchesDist * this.scale;

                if (scale < that.options.zoomMin) scale = 0.5 * that.options.zoomMin * Math.pow(2.0, scale / that.options.zoomMin);
                else if (scale > that.options.zoomMax) scale = 2.0 * that.options.zoomMax * Math.pow(0.5, that.options.zoomMax / scale);

                that.lastScale = scale / this.scale;

                newX = this.originX - this.originX * that.lastScale + this.x,
                        newY = this.originY - this.originY * that.lastScale + this.y;

                this.scroller.style[vendor + 'Transform'] = trnOpen + newX + 'px,' + newY + 'px' + trnClose + ' scale(' + scale + ')';

                if (that.options.onZoom) that.options.onZoom.call(that, e);
                return;
            }

            that.pointX = point.pageX;
            that.pointY = point.pageY;

            // Slow down if outside of the boundaries
            if (newX > 0 || newX < that.maxScrollX) {
                newX = that.options.bounce ? that.x + (deltaX / 2) : newX >= 0 || that.maxScrollX >= 0 ? 0 : that.maxScrollX;
            }
            if (newY > that.minScrollY || newY < that.maxScrollY) {
                newY = that.options.bounce ? that.y + (deltaY / 2) : newY >= that.minScrollY || that.maxScrollY >= 0 ? that.minScrollY : that.maxScrollY;
            }

            if (that.absDistX < 6 && that.absDistY < 6) {
                that.distX += deltaX;
                that.distY += deltaY;
                that.absDistX = m.abs(that.distX);
                that.absDistY = m.abs(that.distY);

                return;
            }

            // Lock direction
            if (that.options.lockDirection) {
                if (that.absDistX > that.absDistY + 5) {
                    newY = that.y;
                    deltaY = 0;
                } else if (that.absDistY > that.absDistX + 5) {
                    newX = that.x;
                    deltaX = 0;
                }
            }

            that.moved = true;
            that._pos(newX, newY);
            that.dirX = deltaX > 0 ? -1 : deltaX < 0 ? 1 : 0;
            that.dirY = deltaY > 0 ? -1 : deltaY < 0 ? 1 : 0;

            if (timestamp - that.startTime > 300) {
                that.startTime = timestamp;
                that.startX = that.x;
                that.startY = that.y;
            }

            if (that.options.onScrollMove) that.options.onScrollMove.call(that, e);
        },

        _end: function (e) {
            if (hasTouch && e.touches.length != 0) return;

            var that = this,
                    point = hasTouch ? e.changedTouches[0] : e,
                    target, ev,
                    momentumX = { dist:0, time:0 },
                    momentumY = { dist:0, time:0 },
                    duration = (e.timeStamp || (new Date()).getTime()) - that.startTime,
                    newPosX = that.x,
                    newPosY = that.y,
                    distX, distY,
                    newDuration,
                    scale;

            that._unbind(MOVE_EV);
            that._unbind(END_EV);
            that._unbind(CANCEL_EV);

            if (that.options.onBeforeScrollEnd) that.options.onBeforeScrollEnd.call(that, e);

            if (that.zoomed) {
                scale = that.scale * that.lastScale;
                scale = Math.max(that.options.zoomMin, scale);
                scale = Math.min(that.options.zoomMax, scale);
                that.lastScale = scale / that.scale;
                that.scale = scale;

                that.x = that.originX - that.originX * that.lastScale + that.x;
                that.y = that.originY - that.originY * that.lastScale + that.y;

                that.scroller.style[vendor + 'TransitionDuration'] = '200ms';
                that.scroller.style[vendor + 'Transform'] = trnOpen + that.x + 'px,' + that.y + 'px' + trnClose + ' scale(' + that.scale + ')';

                that.zoomed = false;
                that.refresh();

                if (that.options.onZoomEnd) that.options.onZoomEnd.call(that, e);
                return;
            }

            if (!that.moved) {
                if (hasTouch) {
                    if (that.doubleTapTimer && that.options.zoom) {
                        // Double tapped
                        clearTimeout(that.doubleTapTimer);
                        that.doubleTapTimer = null;
                        if (that.options.onZoomStart) that.options.onZoomStart.call(that, e);
                        that.zoom(that.pointX, that.pointY, that.scale == 1 ? that.options.doubleTapZoom : 1);
                    } else {
                        that.doubleTapTimer = setTimeout(function () {
                            that.doubleTapTimer = null;

                            // Find the last touched element
                            target = point.target;
                            while (target.nodeType != 1) target = target.parentNode;

                            if (target.tagName != 'SELECT' && target.tagName != 'INPUT' && target.tagName != 'TEXTAREA') {
                                ev = document.createEvent('MouseEvents');
                                ev.initMouseEvent('click', true, true, e.view, 1,
                                        point.screenX, point.screenY, point.clientX, point.clientY,
                                        e.ctrlKey, e.altKey, e.shiftKey, e.metaKey,
                                        0, null);
                                ev._fake = true;
                                target.dispatchEvent(ev);
                            }
                        }, that.options.zoom ? 250 : 0);
                    }
                }

                that._resetPos(200);

                if (that.options.onTouchEnd) that.options.onTouchEnd.call(that, e);
                return;
            }

            if (duration < 300 && that.options.momentum) {
                momentumX = newPosX ? that._momentum(newPosX - that.startX, duration, -that.x, that.scrollerW - that.wrapperW + that.x, that.options.bounce ? that.wrapperW : 0) : momentumX;
                momentumY = newPosY ? that._momentum(newPosY - that.startY, duration, -that.y, (that.maxScrollY < 0 ? that.scrollerH - that.wrapperH + that.y - that.minScrollY : 0), that.options.bounce ? that.wrapperH : 0) : momentumY;

                newPosX = that.x + momentumX.dist;
                newPosY = that.y + momentumY.dist;

                if ((that.x > 0 && newPosX > 0) || (that.x < that.maxScrollX && newPosX < that.maxScrollX)) momentumX = { dist:0, time:0 };
                if ((that.y > that.minScrollY && newPosY > that.minScrollY) || (that.y < that.maxScrollY && newPosY < that.maxScrollY)) momentumY = { dist:0, time:0 };
            }

            if (momentumX.dist || momentumY.dist) {
                newDuration = m.max(m.max(momentumX.time, momentumY.time), 10);

                // Do we need to snap?
                if (that.options.snap) {
                    distX = newPosX - that.absStartX;
                    distY = newPosY - that.absStartY;
                    if (m.abs(distX) < that.options.snapThreshold && m.abs(distY) < that.options.snapThreshold) {
                        that.scrollTo(that.absStartX, that.absStartY, 200);
                    }
                    else {
                        snap = that._snap(newPosX, newPosY);
                        newPosX = snap.x;
                        newPosY = snap.y;
                        newDuration = m.max(snap.time, newDuration);
                    }
                }

                that.scrollTo(newPosX, newPosY, newDuration);

                if (that.options.onTouchEnd) that.options.onTouchEnd.call(that, e);
                return;
            }

            // Do we need to snap?
            if (that.options.snap) {
                distX = newPosX - that.absStartX;
                distY = newPosY - that.absStartY;
                if (m.abs(distX) < that.options.snapThreshold && m.abs(distY) < that.options.snapThreshold) that.scrollTo(that.absStartX, that.absStartY, 200);
                else {
                    snap = that._snap(that.x, that.y);
                    if (snap.x != that.x || snap.y != that.y) that.scrollTo(snap.x, snap.y, snap.time);
                }

                if (that.options.onTouchEnd) that.options.onTouchEnd.call(that, e);
                return;
            }

            that._resetPos(200);
            if (that.options.onTouchEnd) that.options.onTouchEnd.call(that, e);
        },

        _resetPos: function (time) {
            var that = this,
                    resetX = that.x >= 0 ? 0 : that.x < that.maxScrollX ? that.maxScrollX : that.x,
                    resetY = that.y >= that.minScrollY || that.maxScrollY > 0 ? that.minScrollY : that.y < that.maxScrollY ? that.maxScrollY : that.y;

            if (resetX == that.x && resetY == that.y) {
                if (that.moved) {
                    that.moved = false;
                    if (that.options.onScrollEnd) that.options.onScrollEnd.call(that);		// Execute custom code on scroll end
                }

                if (that.hScrollbar && that.options.hideScrollbar) {
                    if (vendor == 'webkit') that.hScrollbarWrapper.style[vendor + 'TransitionDelay'] = '300ms';
                    that.hScrollbarWrapper.style.opacity = '0';
                }
                if (that.vScrollbar && that.options.hideScrollbar) {
                    if (vendor == 'webkit') that.vScrollbarWrapper.style[vendor + 'TransitionDelay'] = '300ms';
                    that.vScrollbarWrapper.style.opacity = '0';
                }

                return;
            }

            that.scrollTo(resetX, resetY, time || 0);
        },

        _wheel: function (e) {
            var that = this,
                    wheelDeltaX, wheelDeltaY,
                    deltaX, deltaY,
                    deltaScale;

            if ('wheelDeltaX' in e) {
                wheelDeltaX = e.wheelDeltaX / 12;
                wheelDeltaY = e.wheelDeltaY / 12;
            } else if ('detail' in e) {
                wheelDeltaX = wheelDeltaY = -e.detail * 3;
            } else {
                wheelDeltaX = wheelDeltaY = -e.wheelDelta;
            }

            if (that.options.wheelAction == 'zoom') {
                deltaScale = that.scale * Math.pow(2, 1 / 3 * (wheelDeltaY ? wheelDeltaY / Math.abs(wheelDeltaY) : 0));
                if (wheelDeltaY < that.options.zoomMin) wheelDeltaY = that.options.zoomMin;
                if (wheelDeltaY > that.options.zoomMax) wheelDeltaY = that.options.zoomMax;

                if (wheelDeltaY != that.scale) {
                    if (!that.wheelZoomCount && that.options.onZoomStart) that.options.onZoomStart.call(that, e);
                    that.wheelZoomCount++;

                    that.zoom(e.pageX, e.pageY, wheelDeltaY, 400);

                    setTimeout(function() {
                        that.wheelZoomCount--;
                        if (!that.wheelZoomCount && that.options.onZoomEnd) that.options.onZoomEnd.call(that, e);
                    }, 400);
                }

                return;
            }

            deltaX = that.x + wheelDeltaX;
            deltaY = that.y + wheelDeltaY;

            if (deltaX > 0) deltaX = 0;
            else if (deltaX < that.maxScrollX) deltaX = that.maxScrollX;

            if (deltaY > that.minScrollY) deltaY = that.minScrollY;
            else if (deltaY < that.maxScrollY) deltaY = that.maxScrollY;

            that.scrollTo(deltaX, deltaY, 0);
        },

        _mouseout: function (e) {
            var t = e.relatedTarget;

            if (!t) {
                this._end(e);
                return;
            }

            while (t = t.parentNode) if (t == this.wrapper) return;

            this._end(e);
        },

        _transitionEnd: function (e) {
            var that = this;

            if (e.target != that.scroller) return;

            that._unbind('webkitTransitionEnd');

            that._startAni();
        },


        /**
         *
         * Utilities
         *
         */
        _startAni: function () {
            var that = this,
                    startX = that.x, startY = that.y,
                    startTime = (new Date).getTime(),
                    step, easeOut;

            if (that.animating) return;

            if (!that.steps.length) {
                that._resetPos(400);
                return;
            }

            step = that.steps.shift();

            if (step.x == startX && step.y == startY) step.time = 0;

            that.animating = true;
            that.moved = true;

            if (that.options.useTransition) {
                that._transitionTime(step.time);
                that._pos(step.x, step.y);
                that.animating = false;
                if (step.time) that._bind('webkitTransitionEnd');
                else that._resetPos(0);
                return;
            }

            (function animate() {
                var now = (new Date).getTime(),
                        newX, newY;

                if (now >= startTime + step.time) {
                    that._pos(step.x, step.y);
                    that.animating = false;
                    if (that.options.onAnimationEnd) that.options.onAnimationEnd.call(that);			// Execute custom code on animation end
                    that._startAni();
                    return;
                }

                now = (now - startTime) / step.time - 1;
                easeOut = m.sqrt(1 - now * now);
                newX = (step.x - startX) * easeOut + startX;
                newY = (step.y - startY) * easeOut + startY;
                that._pos(newX, newY);
                if (that.animating) that.aniTime = nextFrame(animate);
            })();
        },

        _transitionTime: function (time) {
            time += 'ms';
            this.scroller.style[vendor + 'TransitionDuration'] = time;
            if (this.hScrollbar) this.hScrollbarIndicator.style[vendor + 'TransitionDuration'] = time;
            if (this.vScrollbar) this.vScrollbarIndicator.style[vendor + 'TransitionDuration'] = time;
        },

        _momentum: function (dist, time, maxDistUpper, maxDistLower, size) {
            var deceleration = 0.0006,
                    speed = m.abs(dist) / time,
                    newDist = (speed * speed) / (2 * deceleration),
                    newTime = 0, outsideDist = 0;

            // Proportinally reduce speed if we are outside of the boundaries
            if (dist > 0 && newDist > maxDistUpper) {
                outsideDist = size / (6 / (newDist / speed * deceleration));
                maxDistUpper = maxDistUpper + outsideDist;
                speed = speed * maxDistUpper / newDist;
                newDist = maxDistUpper;
            } else if (dist < 0 && newDist > maxDistLower) {
                outsideDist = size / (6 / (newDist / speed * deceleration));
                maxDistLower = maxDistLower + outsideDist;
                speed = speed * maxDistLower / newDist;
                newDist = maxDistLower;
            }

            newDist = newDist * (dist < 0 ? -1 : 1);
            newTime = speed / deceleration;

            return { dist: newDist, time: m.round(newTime) };
        },

        _offset: function (el) {
            var left = -el.offsetLeft,
                    top = -el.offsetTop;

            while (el = el.offsetParent) {
                left -= el.offsetLeft;
                top -= el.offsetTop;
            }

            if (el != this.wrapper) {
                left *= this.scale;
                top *= this.scale;
            }

            return { left: left, top: top };
        },

        _snap: function (x, y) {
            var that = this,
                    i, l,
                    page, time,
                    sizeX, sizeY;

            // Check page X
            page = that.pagesX.length - 1;
            for (i = 0,l = that.pagesX.length; i < l; i++) {
                if (x >= that.pagesX[i]) {
                    page = i;
                    break;
                }
            }
            if (page == that.currPageX && page > 0 && that.dirX < 0) page--;
            x = that.pagesX[page];
            sizeX = m.abs(x - that.pagesX[that.currPageX]);
            sizeX = sizeX ? m.abs(that.x - x) / sizeX * 500 : 0;
            that.currPageX = page;

            // Check page Y
            page = that.pagesY.length - 1;
            for (i = 0; i < page; i++) {
                if (y >= that.pagesY[i]) {
                    page = i;
                    break;
                }
            }
            if (page == that.currPageY && page > 0 && that.dirY < 0) page--;
            y = that.pagesY[page];
            sizeY = m.abs(y - that.pagesY[that.currPageY]);
            sizeY = sizeY ? m.abs(that.y - y) / sizeY * 500 : 0;
            that.currPageY = page;

            // Snap with constant speed (proportional duration)
            time = m.round(m.max(sizeX, sizeY)) || 200;

            return { x: x, y: y, time: time };
        },

        _bind: function (type, el, bubble) {
            (el || this.scroller).addEventListener(type, this, !!bubble);
        },

        _unbind: function (type, el, bubble) {
            (el || this.scroller).removeEventListener(type, this, !!bubble);
        },


        /**
         *
         * Public methods
         *
         */
        destroy: function () {
            var that = this;

            that.scroller.style[vendor + 'Transform'] = '';

            // Remove the scrollbars
            that.hScrollbar = false;
            that.vScrollbar = false;
            that._scrollbar('h');
            that._scrollbar('v');

            // Remove the event listeners
            that._unbind(RESIZE_EV, window);
            that._unbind(START_EV);
            that._unbind(MOVE_EV);
            that._unbind(END_EV);
            that._unbind(CANCEL_EV);

            if (that.options.hasTouch) {
                that._unbind('mouseout', that.wrapper);
                that._unbind(WHEEL_EV);
            }

            if (that.options.useTransition) that._unbind('webkitTransitionEnd');

            if (that.options.checkDOMChanges) clearInterval(that.checkDOMTime);

            if (that.options.onDestroy) that.options.onDestroy.call(that);
        },

        refresh: function () {
            var that = this,
                    offset,
                    pos = 0,
                    page = 0;

            if (that.scale < that.options.zoomMin) that.scale = that.options.zoomMin;
            that.wrapperW = that.wrapper.clientWidth || 1;
            that.wrapperH = that.wrapper.clientHeight || 1;

            that.minScrollY = -that.options.topOffset || 0;
            that.scrollerW = m.round(that.scroller.offsetWidth * that.scale);
            that.scrollerH = m.round((that.scroller.offsetHeight + that.minScrollY) * that.scale);
            that.maxScrollX = that.wrapperW - that.scrollerW;
            that.maxScrollY = that.wrapperH - that.scrollerH + that.minScrollY;
            that.dirX = 0;
            that.dirY = 0;

            if (that.options.onRefresh) that.options.onRefresh.call(that);

            that.hScroll = that.options.hScroll && that.maxScrollX < 0;
            that.vScroll = that.options.vScroll && (!that.options.bounceLock && !that.hScroll || that.scrollerH > that.wrapperH);

            that.hScrollbar = that.hScroll && that.options.hScrollbar;
            that.vScrollbar = that.vScroll && that.options.vScrollbar && that.scrollerH > that.wrapperH;

            offset = that._offset(that.wrapper);
            that.wrapperOffsetLeft = -offset.left;
            that.wrapperOffsetTop = -offset.top;

            // Prepare snap
            if (typeof that.options.snap == 'string') {
                that.pagesX = [];
                that.pagesY = [];
                els = that.scroller.querySelectorAll(that.options.snap);
                for (i = 0,l = els.length; i < l; i++) {
                    pos = that._offset(els[i]);
                    pos.left += that.wrapperOffsetLeft;
                    pos.top += that.wrapperOffsetTop;
                    that.pagesX[i] = pos.left < that.maxScrollX ? that.maxScrollX : pos.left * that.scale;
                    that.pagesY[i] = pos.top < that.maxScrollY ? that.maxScrollY : pos.top * that.scale;
                }
            } else if (that.options.snap) {
                that.pagesX = [];
                while (pos >= that.maxScrollX) {
                    that.pagesX[page] = pos;
                    pos = pos - that.wrapperW;
                    page++;
                }
                if (that.maxScrollX % that.wrapperW) that.pagesX[that.pagesX.length] = that.maxScrollX - that.pagesX[that.pagesX.length - 1] + that.pagesX[that.pagesX.length - 1];

                pos = 0;
                page = 0;
                that.pagesY = [];
                while (pos >= that.maxScrollY) {
                    that.pagesY[page] = pos;
                    pos = pos - that.wrapperH;
                    page++;
                }
                if (that.maxScrollY % that.wrapperH) that.pagesY[that.pagesY.length] = that.maxScrollY - that.pagesY[that.pagesY.length - 1] + that.pagesY[that.pagesY.length - 1];
            }

            // Prepare the scrollbars
            that._scrollbar('h');
            that._scrollbar('v');

            if (!that.zoomed) {
                that.scroller.style[vendor + 'TransitionDuration'] = '0';
                that._resetPos(200);
            }
        },

        scrollTo: function (x, y, time, relative) {
            var that = this,
                    step = x,
                    i, l;

            that.stop();

            if (!step.length) step = [
                { x: x, y: y, time: time, relative: relative }
            ];

            for (i = 0,l = step.length; i < l; i++) {
                if (step[i].relative) {
                    step[i].x = that.x - step[i].x;
                    step[i].y = that.y - step[i].y;
                }
                that.steps.push({ x: step[i].x, y: step[i].y, time: step[i].time || 0 });
            }

            that._startAni();
        },

        scrollToElement: function (el, time) {
            var that = this, pos;
            el = el.nodeType ? el : that.scroller.querySelector(el);
            if (!el) return;

            pos = that._offset(el);
            pos.left += that.wrapperOffsetLeft;
            pos.top += that.wrapperOffsetTop;

            pos.left = pos.left > 0 ? 0 : pos.left < that.maxScrollX ? that.maxScrollX : pos.left;
            pos.top = pos.top > that.minScrollY ? that.minScrollY : pos.top < that.maxScrollY ? that.maxScrollY : pos.top;
            time = time === undefined ? m.max(m.abs(pos.left) * 2, m.abs(pos.top) * 2) : time;

            that.scrollTo(pos.left, pos.top, time);
        },

        scrollToPage: function (pageX, pageY, time) {
            var that = this, x, y;

            if (that.options.snap) {
                pageX = pageX == 'next' ? that.currPageX + 1 : pageX == 'prev' ? that.currPageX - 1 : pageX;
                pageY = pageY == 'next' ? that.currPageY + 1 : pageY == 'prev' ? that.currPageY - 1 : pageY;

                pageX = pageX < 0 ? 0 : pageX > that.pagesX.length - 1 ? that.pagesX.length - 1 : pageX;
                pageY = pageY < 0 ? 0 : pageY > that.pagesY.length - 1 ? that.pagesY.length - 1 : pageY;

                that.currPageX = pageX;
                that.currPageY = pageY;
                x = that.pagesX[pageX];
                y = that.pagesY[pageY];
            } else {
                x = -that.wrapperW * pageX;
                y = -that.wrapperH * pageY;
                if (x < that.maxScrollX) x = that.maxScrollX;
                if (y < that.maxScrollY) y = that.maxScrollY;
            }

            that.scrollTo(x, y, time || 400);
        },

        disable: function () {
            this.stop();
            this._resetPos(0);
            this.enabled = false;

            // If disabled after touchstart we make sure that there are no left over events
            this._unbind(MOVE_EV);
            this._unbind(END_EV);
            this._unbind(CANCEL_EV);
        },

        enable: function () {
            this.enabled = true;
        },

        stop: function () {
            if (this.options.useTransition) this._unbind('webkitTransitionEnd');
            else cancelFrame(this.aniTime);
            this.steps = [];
            this.moved = false;
            this.animating = false;
        },

        zoom: function (x, y, scale, time) {
            var that = this,
                    relScale = scale / that.scale;

            if (!that.options.useTransform) return;

            that.zoomed = true;
            time = time === undefined ? 200 : time;
            x = x - that.wrapperOffsetLeft - that.x;
            y = y - that.wrapperOffsetTop - that.y;
            that.x = x - x * relScale + that.x;
            that.y = y - y * relScale + that.y;

            that.scale = scale;
            that.refresh();

            that.x = that.x > 0 ? 0 : that.x < that.maxScrollX ? that.maxScrollX : that.x;
            that.y = that.y > that.minScrollY ? that.minScrollY : that.y < that.maxScrollY ? that.maxScrollY : that.y;

            that.scroller.style[vendor + 'TransitionDuration'] = time + 'ms';
            that.scroller.style[vendor + 'Transform'] = trnOpen + that.x + 'px,' + that.y + 'px' + trnClose + ' scale(' + scale + ')';
            that.zoomed = false;
        },

        isReady: function () {
            return !this.moved && !this.zoomed && !this.animating;
        }
    };

    if (typeof exports !== 'undefined') exports.iScroll = iScroll;
    else window.iScroll = iScroll;

})();
/*
 * Copyright 2004-2012 ICEsoft Technologies Canada Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

if (!window['mobi']) {
    window.mobi = {};
}
mobi.carousel = {
	  acarousel: null,
	  loaded: function(clientId, cfg){
	            var carouselId = clientId+'_carousel';
	            //carousel iscroll loading
	        //    ice.log.debug(ice.log, 'in the carouselLoaded method clientId is '+clientId);
	            setTimeout(function () {
	                if (this.acarousel) {
	                 //   ice.log.debug(ice.log, 'REFRESH existing carousel='+this.acarousel);
	                    mobi.carousel.refresh(clientId, singleSubmit);
	                }
	                else {
	                    ice.log.debug(ice.log, 'CREATE onload carousel');
	                    this.acarousels = new iScroll(carouselId, {
	                    snap: 'li',
	                    momentum: false,
	                    hScrollbar: false, 
	                    onScrollEnd: function () {
                            mobi.carousel.scrollUpdate(clientId, this.currPageX, cfg);
    	                }
	                 });
	                }
	              }, 100);
	               ice.log.debug(ice.log,"after setTimeout function");
	   },
	   unloaded: function(clientId){
	       if (this.acarousel!=null){
      //        ice.log.debug(ice.log, 'DESTROY carousel with id='+clientId);
	           this.acarousel.destroy();
	           this.acarousel = null;
	       }
	   }, 
	   scrollUpdate: function(clientId, pageVal, cfg){
            //only update if different than last one.
  //         ice.log.debug(ice.log, 'scrollUpdate and current page is='+pageVal);
           var hidden = document.getElementById(clientId+'_hidden');
           var changedVal = false;
           if (hidden){
               var temp = hidden.value;
               if (temp!=pageVal){
                    changedVal = true;
                    hidden.value=pageVal;
                    ice.log.debug(ice.log, 'old hidden='+temp+ ' updated to hidden.value = '+hidden.value);
                    document.querySelector('.mobi-carousel-cursor-list > li.active').className = '';
                    document.querySelector('.mobi-carousel-cursor-list > li:nth-child(' + (pageVal + 1) + ')').className = 'active';
               }
           }
           if (changedVal){
               var behaviors = cfg.behaviors;
               var hasBehaviors = false;
                if (behaviors){
                    hasBehaviors = true;
                }
               var singleSubmit = cfg.singleSubmit;
               if (hasBehaviors){
                   ice.log.debug(ice.log, ' HAS BEHAVIORS');
                  if (behaviors.change){
                        behaviors.change();
                    }
                }
                if (!hasBehaviors && singleSubmit){
                    ice.se(null, clientId);
                }
           }
	   },
	   refresh: function(clientId, cfg){
		   if (this.acarousel){
               ice.log.debug(ice.log, "  have a carousel to refresh from hidden value");
			   var currPageX = 0;
			   var hidden = document.getElementById(clientId+"_hidden");
			   if (hidden){
				   currPageX = hidden.value;
				   ice.log.debug(ice.log, 'in refresh and currPageX ='+this.currPageX+' hiddenVal is ='+hidden.value);
			   }
		 	   //if this.current is different from hidden, then scroll to hidden value.
			   this.acarousel.scrollToPage(currPageX);
               document.querySelector('.mobi-carousel-cursor-list > li.active').className = '';
               document.querySelector('.mobi-carousel-cursor-list > li:nth-child(' + (this.currPageX + 1) + ')').className = 'active';
			   setTimeout(function(){
			      this.acarousel.refresh();

			   },0);

		   }
           if (!this.acarousel){
           //    ice.log.debug(ice.log, "REFRESH HAS NO OBJECT FOR CAROUSEL clientId="+clientId+' ss -'+singleSubmit);
               this.acarousel=null;
               this.loaded(clientId, cfg);
           }

	   }

}
/*
 * Copyright 2004-2012 ICEsoft Technologies Canada Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

if (!window['mobi']) {
    window.mobi = {};
}
mobi.datespinner = {
      pattern: {}, //supported formats are dd/MM/yyyy, MM-dd-yyyy, dd-MM-yyyy, yyyy-MM-dd, yyyy-dd-MM
      opened: {},
	  init: function(clientId, yrSel, mSel, dSel, format ){
          var idPanel = clientId+"_bg";
          if (!document.getElementById(idPanel).className ){
             document.getElementById(idPanel).className = 'mobi-date-bg-inv';
          }
          var intDt = parseInt(dSel);
          var intMth = parseInt(mSel);
          var intYr= parseInt(yrSel);
          if (format){
              this.pattern[clientId] = format;
   //           ice.log.debug(ice.log, ' pattern changed to ='+this.pattern);
          }
          this.opened[clientId]= false;
          //have to set the value controls to the correct integer
          var mnthEl = document.getElementById(clientId+"_mInt");
          var yrEl = document.getElementById(clientId+"_yInt");
          var dateEl = document.getElementById(clientId+"_dInt");
          if (mnthEl){
              mnthEl.innerHTML = intMth;
          }
          if (yrEl){
              yrEl.innerHTML=intYr;
          }
          if (dateEl){
              dateEl.innerHTML=intDt;
          }
          this.updateDate(clientId);
	   },
	   mUp: function(clientId){
          var mId = clientId+'_mInt';
	       var mnthEl = document.getElementById(mId);
           if (mnthEl){
               var mInt = this.getIntValue(mId);
               if (mInt == 12){
                   mnthEl.innerHTML = 1;
               }
               else {
                   mnthEl.innerHTML =mInt+ 1;
               }
           }
            this.updateDate(clientId);
	   },
       mDn: function(clientId){
           var mId = clientId+'_mInt';
	       var mnthEl = document.getElementById(mId);
           if (mnthEl){
               var mInt = this.getIntValue(mId);
               if (mInt == 1){
                   mnthEl.innerHTML = 12;
               }
               else {
                   mnthEl.innerHTML =mInt -1;
               }
           }
           this.updateDate(clientId);
	   },
        yUp: function(clientId, yrMin, yrMax){
           var yId = clientId+'_yInt';
           var yrEl = document.getElementById(yId);
            if (yrEl){
                var yInt = this.getIntValue(yId);
                if ( yInt ==yrMax){
                    //nothing
                }
                else {
                    yrEl.innerHTML = yInt+1;
                }
            }
            this.updateDate(clientId);
        },
        yDn: function(clientId, yrMin, yrMax){
            var yrEl = document.getElementById(clientId+'_yInt');
            if (yrEl){
                yInt = this.getIntValue(clientId+'_yInt');
                if (yInt == yrMin){
                    //nothing
                }
                else {
                    yrEl.innerHTML = yInt-1;
                }
            }
            this.updateDate(clientId);
        },
        dUp: function(clientId){
            var dId = clientId+'_dInt';
            var dEl = document.getElementById(dId);
            var mInt = this.getIntValue(clientId+"_mInt");
            var yInt = this.getIntValue(clientId+"_yInt");
            var dInt = this.getIntValue(dId);
            var numDaysInMonth = this.daysInMonth(mInt, yInt);
            if (dEl){
               if (dInt >= numDaysInMonth ){
                       dEl.innerHTML = 1;
               }
               else {
                    dEl.innerHTML = dInt+1;
               }
            }
            this.updateDate(clientId);
         },
         dDn: function(clientId){
            var dId = clientId+'_dInt';
            var dEl = document.getElementById(dId);
            var mInt = this.getIntValue(clientId+"_mInt");
            var yInt = this.getIntValue(clientId+"_yInt");
            var dInt = this.getIntValue(dId);
            var numDaysInMonth = this.daysInMonth(mInt, yInt);
            if (dEl){
                 if (dInt == 1 || dInt > numDaysInMonth){
                    dEl.innerHTML = numDaysInMonth;
                 }
                 else {
                    dEl.innerHTML = dInt-1;
                 }
             }
             this.updateDate(clientId);
        },
        updateDate: function(clientId){
            var dId = clientId+"_dInt";
            var dEl = document.getElementById(dId);
            var mInt = this.getIntValue(clientId+"_mInt");
            var yInt = this.getIntValue(clientId+"_yInt");
            var dInt = this.getIntValue(dId);
            var upDate = this.validate(yInt, mInt, dInt);
            if (!upDate){
                dInt = this.daysInMonth(mInt, yInt);
                dEl.innerHTML = dInt;
            }
            this.writeTitle(clientId, dInt, mInt, yInt);
        },

        writeTitle: function(clientId, iD, iM, iY){
            var date = new Date();
            date.setDate(iD);
            date.setMonth(iM-1);
            date.setYear(iY);
            var titleEl = document.getElementById(clientId+'_title');
            titleEl.innerHTML = date.toDateString();
        },

        daysInMonth: function(iMnth, iYr){
            var aDate = new Date(iYr, iMnth, 0);
            return aDate.getDate();
        },

        validate: function(iY, iM, iD){
            if (iY != parseInt(iY,10) || iM != parseInt(iM, 10) || iD != parseInt(iD, 10)) return false;
            iM --;
            var newDate = new Date (iY, iM, iD);
            if ((iY==newDate.getFullYear()) && (iM == newDate.getMonth()) && (iD=newDate.getDate())) {
                return newDate;
            }
            else return false;
        },

        getIntValue: function(id){
            var element = document.getElementById(id);
            if (element){
                var stringEl = element.innerHTML;
                return parseInt(stringEl);
            } else return 1;
        },
        select: function(clientId, cfg){
            this.cfg = cfg;
            var singleSubmit = this.cfg.singleSubmit;
            var event = this.cfg.event;
            var hasBehaviors = false;
            var behaviors =this.cfg.behaviors;
            if (behaviors){
                hasBehaviors = true;
            }
      //
            var inputEl = document.getElementById(clientId+'_input');
            var hiddenEl = document.getElementById(clientId+'_hidden');
            var dInt = this.getIntValue(clientId+"_dInt");
            var mInt = this.getIntValue(clientId+"_mInt");
            var yInt = this.getIntValue(clientId+"_yInt");
            var dStr= dInt;
            var mStr = mInt
            if (dInt < 10){
                dStr = '0'+dInt;
            }
            if (mInt < 10){
               mStr = '0'+mInt;
            }
            //default pattern
            var dateStr = dStr +'/'+mStr+'/'+yInt;
            var myPattern = this.pattern[clientId];
            if (myPattern=='MM-dd-yyyy'){
               dateStr= mStr+'-'+dStr+'-'+yInt;
            }
            if (myPattern == 'yyyy-MM-dd'){
                dateStr = yInt + "-" + mStr + "-" + dStr;
            }
            if (myPattern == 'yyyy-dd-MM'){
                dateStr = yInt + "-" + dStr + "-" + mStr;
            }
            if (myPattern == 'dd-MM-yyyy'){
                dateStr = dStr+'-'+mStr+'-'+yInt;
            }
            hiddenEl.value = dateStr;
            inputEl.value = dateStr;
            if (hasBehaviors){
                if (behaviors.change){
                    behaviors.change();
                }
            }
            if (!hasBehaviors && singleSubmit){
                ice.se(event, clientId);
            }
            this.close(clientId);
        },
        toggle: function(clientId){
            if (this.opened[clientId]==false){
                this.open(clientId);
            }  else {
                this.close(clientId);
            }
        },
        open: function(clientId){
            var idPanel = clientId+"_bg";
            document.getElementById(idPanel).className = "mobi-date-bg";
            document.getElementById(clientId+"_popup").className = "mobi-date-container";
            this.opened[clientId]= true;
        },
        close: function(clientId){
            var idPanel = clientId+"_bg" ;
            document.getElementById(idPanel).className = "mobi-date";
            document.getElementById(clientId+"_popup").className = "mobi-date-container-hide";
            this.opened[clientId]= false;
        },
        unload: function(clientId){
           /* var titleEl = document.getElementById(clientId+'_title');
            titleEl.innerHTML = "";  */
            this.pattern[clientId] = null;
            this.opened[clientId] = null;
        }

}
/*
 * Copyright 2004-2012 ICEsoft Technologies Canada Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */


if (!window['mobi']) {
    window.mobi = {};
}

mobi.flipswitch = {
    init: function(clientId, cfg){
        this.id = clientId;
        this.cfg = cfg;
        this.flipperEl = cfg.elVal;
        this.singleSubmit = cfg.singleSubmit;
        this.event = cfg.event;
        var hasBehaviors = false;
        if (this.cfg.behaviors){
           hasBehaviors = true;
        }
        if (this.flipperEl){
            var oldClass = this.flipperEl.className;
            var value = "off";
            if (oldClass.indexOf('-off ')>0){
            	this.flipperEl.className='mobi-flip-switch mobi-flip-switch-on ';
                value = true;
            }else{
             	this.flipperEl.className='mobi-flip-switch mobi-flip-switch-off ';
               	value = false;
            }
            var hidden = this.id+"_hidden";
            var thisEl = document.getElementById(hidden);
            if (thisEl){
               thisEl.value=value.toString();
            }
            if (this.singleSubmit){
                    ice.se(this.event, this.id);
                }
            if (hasBehaviors){
                if (this.cfg.behaviors.activate){
                    this.cfg.behaviors.activate();
                }
            }
         }
    }
};

/*
 * Copyright 2004-2012 ICEsoft Technologies Canada Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

if (!window['mobi']) {
    window.mobi = {};
}
mobi.timespinner = {
      pattern: {}, //only supports 'hh:mm a' at this time.
      opened: {},
	  init: function(clientId, hrSel, mSel, aSel, format ){
          var idPanel = clientId+"_bg";
          if (!document.getElementById(idPanel).className ){
             document.getElementById(idPanel).className = 'mobi-date-bg-inv';
          }
          var intAmPm = parseInt(aSel);
          var intMinute = parseInt(mSel);
          var intHr= parseInt(hrSel);
          if (format){
              this.pattern[clientId] = format;
              ice.log.debug(ice.log, ' pattern change not yet implemented ='+this.pattern);
          }
          this.opened[clientId]= false;
          //have to set the value controls to the correct integer
          var hrEl = document.getElementById(clientId+"_hrInt");
          var minEl = document.getElementById(clientId+"_mInt");
          var ampmEl = document.getElementById(clientId+"_ampmInt");
          if (minEl){
              minEl.innerHTML = intMinute;
          }
          if (hrEl){
              hrEl.innerHTML=intHr;
          }
          var ampm = 'AM';
          if (intAmPm >0){
            ampm = 'PM';
          }
   //       ice.log.debug(ice.log, 'val of intAmpm ='+intAmPm + ' ampm = '+ampm);
          if (ampmEl){
              ampmEl.innerHTML=ampm;
          }
          this.updateTime(clientId);
	   },
	   mUp: function(clientId){
          var mId = clientId+'_mInt';
	       var minEl = document.getElementById(mId);
           if (minEl){
               var mInt = this.getIntValue(mId);
               if (mInt == 59){
                   minEl.innerHTML = 0;
               }
               else {
                   minEl.innerHTML =mInt+ 1;
               }
           }
            this.updateTime(clientId);
	   },
       mDn: function(clientId){
           var mId = clientId+'_mInt';
	       var minEl = document.getElementById(mId);
           if (minEl){
               var mInt = this.getIntValue(mId);
               if (mInt == 0){
                   minEl.innerHTML = 59;
               }
               else {
                   minEl.innerHTML =mInt -1;
               }
           }
           this.updateTime(clientId);
	   },
       hrUp: function(clientId){
           var hrId = clientId+'_hrInt';
           var hrEl = document.getElementById(hrId);
           if (hrEl){
                var hrInt = this.getIntValue(hrId);
                if ( hrInt == 12){
                    hrEl.innerHTML = 1;
                }
                else {
                    hrEl.innerHTML = hrInt+1;
                }
            }
            this.updateTime(clientId);
        },
        hrDn: function(clientId){
            var hrEl = document.getElementById(clientId+'_hrInt');
            if (hrEl){
                var hrInt = this.getIntValue(clientId+'_hrInt');
                if (hrInt == 1){
                    hrEl.innerHTML = 12;
                }
                else {
                    hrEl.innerHTML = hrInt-1;
                }
            }
            this.updateTime(clientId);
       },
       ampmToggle: function(clientId){
            var aId = clientId+'_ampmInt';
            var aEl = document.getElementById(aId);
            if (aEl.innerHTML == "AM"){
                aEl.innerHTML = 'PM';
            }
            else {
                aEl.innerHTML = 'AM';
            }
            this.updateTime(clientId);
        },
        updateTime: function(clientId){
            var ampm = clientId+"_ampmInt";
            var ampmEl = document.getElementById(ampm);
            var mInt = this.getIntValue(clientId+"_mInt");
            var hrInt = this.getIntValue(clientId+"_hrInt");
            this.writeTitle(clientId, hrInt, mInt, ampmEl.innerHTML);
        },

        writeTitle: function(clientId, hr , min, ampm){
            if (hr < 10){
                hr = '0'+hr;
            }
            if (min < 10){
                min = '0'+min;
            }
            var time = hr+':'+min+' '+ampm;
            var titleEl = document.getElementById(clientId+'_title');
            titleEl.innerHTML = time;
        },

        getIntValue: function(id){
            var element = document.getElementById(id);
            if (element){
                var stringEl = element.innerHTML;
                return parseInt(stringEl);
            } else return 1;
        },
        select: function(clientId, cfg){
            this.cfg = cfg;
            var singleSubmit = this.cfg.singleSubmit;
            var event = this.cfg.event;
            var hasBehaviors = false;
            var behaviors =this.cfg.behaviors;
            if (behaviors){
                hasBehaviors = true;
            }
            var inputEl = document.getElementById(clientId+'_input');
            var titleEl = document.getElementById(clientId+'_title');
            inputEl.value = titleEl.innerHTML;
            if (hasBehaviors){
                if (behaviors.change){
                    behaviors.change();
                }
            }
            if (!hasBehaviors && singleSubmit){
                ice.se(event, clientId);
            }
            this.close(clientId);
        },
        toggle: function(clientId){
            if (this.opened[clientId]==false){
                this.open(clientId);
            }  else {
                this.close(clientId);
            }
        },
        open: function(clientId){
            document.getElementById(clientId+'_bg').className = "mobi-time-bg";
            document.getElementById(clientId+"_popup").className = "mobi-time-container";
            this.opened[clientId]= true;
        },
        close: function(clientId){
            document.getElementById(clientId+'_bg').className = "mobi-time";
            document.getElementById(clientId+"_popup").className = "mobi-time-container-hide";
            this.opened[clientId]= false;
        },
        unload: function(clientId){
            alert("unloading for clientId");
           /* var titleEl = document.getElementById(clientId+'_title');
            titleEl.innerHTML = "";  */
            this.pattern[clientId] = null;
            this.opened[clientId] = null;
        }

}
