/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.camera;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.render.Renderer;
import org.icefaces.mobi.component.camera.Camera;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.util.MobiJSFUtils;
import org.icefaces.util.ClientDescriptor;

public class CameraRenderer
extends Renderer {
    private static final Logger logger = Logger.getLogger(CameraRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Camera camera = (Camera)uiComponent;
        String clientId = camera.getClientId();
        try {
            HashMap map;
            boolean valid;
            if (!camera.isDisabled() && (valid = this.extractImages(facesContext, map = new HashMap(), clientId)) && map != null) {
                camera.setValue(map);
                uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, null, map));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean extractImages(FacesContext facesContext, Map map, String clientId) throws IOException {
        return MobiJSFUtils.decodeComponentFile(facesContext, clientId, map);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        int maxheight;
        String styleClass;
        String style;
        Camera camera = (Camera)uiComponent;
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        String clientId = camera.getClientId();
        writer.startElement("span", camera);
        writer.writeAttribute("id", clientId);
        String oldLabel = camera.getButtonLabel();
        if (MobiJSFUtils.uploadInProgress((UIComponent)camera)) {
            camera.setButtonLabel(camera.getCaptureMessageLabel());
        }
        ClientDescriptor cd = camera.getClient();
        writer.startElement("button", camera);
        writer.writeAttribute("id", clientId + "_button");
        writer.writeAttribute("name", clientId + "_button");
        writer.writeAttribute("type", "button");
        if (camera.isDisabled()) {
            writer.writeAttribute("disabled", "disabled");
        }
        if ((style = camera.getStyle()) != null) {
            writer.writeAttribute("style", style);
        }
        if ((styleClass = camera.getStyleClass()) != null) {
            writer.writeAttribute("class", styleClass);
        }
        writer.writeAttribute("tabindex", camera.getTabindex());
        String script = "bridgeit.camera('" + clientId + "', 'callback" + clientId + "', {postURL:'" + camera.getPostURL() + "', ";
        script = script + "cookies:{'JSESSIONID':'" + MobiJSFUtils.getSessionIdCookie(facesContext) + "'}";
        int maxwidth = camera.getMaxwidth();
        if (maxwidth > 0) {
            script = script + ", maxwidth: " + maxwidth;
        }
        if ((maxheight = camera.getMaxheight()) > 0) {
            script = script + ", maxheight:" + maxheight;
        }
        script = script + "});";
        writer.writeAttribute("onclick", script);
        writer.startElement("span", camera);
        writer.writeText(camera.getButtonLabel());
        writer.endElement("span");
        writer.startElement("span", camera);
        writer.startElement("script", camera);
        writer.writeAttribute("type", "text/javascript");
        writer.writeText("new ice.mobi.button('" + clientId + "_button');");
        writer.writeText("if (!window['thumbnails" + clientId + "']) window['thumbnails" + clientId + "'] = {};");
        writer.writeText("window['callback" + clientId + "'] = function(arg) {for (t in window['thumbnails" + clientId + "']) { setTimeout(function() {var e = document.getElementById(t); if (e) e.src = arg.preview; }, 350); try {document.getElementById(window['thumbnails" + clientId + "'][t]).value = arg.preview;} catch (e) {} }};");
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("button");
        writer.endElement("span");
        camera.setButtonLabel(oldLabel);
    }
}

