/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.deviceresource;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpServletRequest;
import org.icefaces.ace.util.Attribute;
import org.icefaces.ace.util.PassThruAttributeWriter;
import org.icefaces.mobi.component.deviceresource.DeviceResource;
import org.icefaces.mobi.util.MobiJSFUtils;
import org.icefaces.mobi.util.SXUtils;
import org.icefaces.util.ClientDescriptor;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class DeviceResourceRenderer
extends Renderer
implements ComponentSystemEventListener {
    private static final Logger log = Logger.getLogger(DeviceResourceRenderer.class.getName());
    public static final String CSS_LOCATION = "org.icefaces.component.skins";
    public static final String UTIL_RESOURCE = "org.icefaces.component.util";
    public static final String RESOURCE_URL_ERROR = "MOBI_RES_NOT_FOUND";
    public static final String IOS_APP_ID = "727736414";
    public static final String META_CONTENTTYPE = "<meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>";
    public static final String META_VIEWPORT = "<meta name='viewport' content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, minimal-ui'/>";
    public static final String META_IOS_WEBAPPCAPABLE = "<meta name='apple-mobile-web-app-capable' content='yes'/>";
    public static final String META_IOS_APPSTATUSBAR = "<meta name='apple-mobile-web-app-status-bar-style' content='black'/>";
    public static final String META_IOS_SMARTAPPBANNER = "<meta name='apple-itunes-app' content=\"app-id=%s, app-argument=%s\"/>";
    public static final String LINK_SHORTCUT_ICON = "<link href='%s/resources/images/favicon.ico' rel='shortcut icon' type='image/x-icon'/>";
    public static final String LINK_FAV_ICON = "<link href='%s/resources/images/favicon.ico' rel='icon' type='image/x-icon'/>";
    public static final String SCRIPT_ICEMOBILE = "<script type='text/javascript' src='%s%s/javascript/icemobile.js'></script>";
    public static final String SCRIPT_SIMULATOR = "simulator-interface.js";
    public static final String CSS_SIMULATOR = "simulator.css";

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        FacesContext context = FacesContext.getCurrentInstance();
        if (log.isLoggable(Level.FINER)) {
            log.finer("processEvent for component = " + component.getClass().getName());
        }
        context.getViewRoot().addComponentResource(context, component, "head");
    }

    public void encodeEnd(FacesContext context, UIComponent uiComponent) throws IOException {
        DeviceResource comp = (DeviceResource)uiComponent;
        boolean ios6orHigher = false;
        boolean desktop = false;
        boolean isSimulated = false;
        ClientDescriptor client = ClientDescriptor.getInstance((HttpServletRequest)((HttpServletRequest)context.getExternalContext().getRequest()));
        boolean bl = ios6orHigher = client.isIOS6() || client.isIOS7();
        if (!ios6orHigher) {
            desktop = client.isDesktopBrowser();
        }
        if (desktop) {
            isSimulated = client.isSimulator();
        }
        String contextRoot = context.getExternalContext().getRequestContextPath();
        ResponseWriter writer = context.getResponseWriter();
        writer.write(String.format(LINK_FAV_ICON, contextRoot));
        writer.write(String.format(LINK_SHORTCUT_ICON, contextRoot));
        if (!desktop) {
            writer.write(META_VIEWPORT);
            if (ios6orHigher) {
                writer.write(META_IOS_WEBAPPCAPABLE);
                writer.write(META_IOS_APPSTATUSBAR);
                if (this.isNeedAppBanner(context, comp, client)) {
                    String smartAppMeta = String.format(META_IOS_SMARTAPPBANNER, IOS_APP_ID, SXUtils.getRegisterSXURL(MobiJSFUtils.getRequest(context), "javax.faces.resource/auxupload.txt.jsf"));
                    writer.write(smartAppMeta);
                    context.getAttributes().put("org.icemobile.iosSmartAppBanner", Boolean.TRUE);
                }
            }
        }
        if (client.isAndroid2OS()) {
            this.writeOverthrow(context);
        }
        if (isSimulated) {
            this.writeSimulatorResources(context, comp);
        }
        this.encodeMarkers(writer, client);
    }

    private void writeOverthrow(FacesContext context) throws IOException {
        Resource ot = context.getApplication().getResourceHandler().createResource("overthrow.js", UTIL_RESOURCE);
        String src = ot.getRequestPath();
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)src, null);
        writer.endElement("script");
    }

    private boolean isNeedAppBanner(FacesContext facesContext, DeviceResource comp, ClientDescriptor client) {
        ProjectStage projectStage = facesContext.getApplication().getProjectStage();
        if (ProjectStage.Development == projectStage) {
            return false;
        }
        return comp.isIncludeIOSSmartAppBanner() && !client.isSXRegistered();
    }

    private void writeOutDeviceStyleSheets(FacesContext facesContext, DeviceResource comp) throws IOException {
        String resourceUrl = RESOURCE_URL_ERROR;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("link", (UIComponent)comp);
        writer.writeAttribute("type", (Object)"text/css", "type");
        writer.writeAttribute("rel", (Object)"stylesheet", "rel");
        PassThruAttributeWriter.renderNonBooleanAttributes((ResponseWriter)writer, (UIComponent)comp, (Attribute[])new Attribute[]{new Attribute("media", null)});
        writer.writeURIAttribute("href", (Object)resourceUrl, "href");
        writer.endElement("link");
    }

    private void writeSimulatorResources(FacesContext facesContext, DeviceResource component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Resource simulatorCss = facesContext.getApplication().getResourceHandler().createResource(CSS_SIMULATOR, CSS_LOCATION, "text/css");
        writer.startElement("link", (UIComponent)component);
        writer.writeAttribute("type", (Object)"text/css", "type");
        writer.writeAttribute("rel", (Object)"stylesheet", "rel");
        writer.writeURIAttribute("href", (Object)simulatorCss.getRequestPath(), "href");
        writer.endElement("link");
        Resource simulatorScript = facesContext.getApplication().getResourceHandler().createResource(SCRIPT_SIMULATOR, UTIL_RESOURCE);
        String src = simulatorScript.getRequestPath();
        writer.startElement("script", (UIComponent)component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)src, null);
        writer.endElement("script");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)"console.log('Welcome to the Matrix');", null);
        writer.endElement("script");
    }

    public void encodeMarkers(ResponseWriter writer, ClientDescriptor client) throws IOException {
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String markers = " ui-mobile";
        if (client.isIE10Browser()) {
            markers = markers + " ie10";
        }
        if (client.isAndroidBrowserOrWebView()) {
            markers = markers + " android-browser";
        }
        if (client.isDesktopBrowser()) {
            markers = markers + " desktop";
        }
        if (client.isSimulator()) {
            markers = markers + " simulator";
        }
        writer.writeText((Object)("document.documentElement.className = document.documentElement.className+'" + markers + "'; if (window.addEventListener) window.addEventListener('load', function() {document.body.className = 'ui-body-c';});"), null);
        writer.endElement("script");
    }

    private String deriveLibrary(Map attributes) {
        String library = (String)attributes.get("library");
        if (library == null) {
            library = CSS_LOCATION;
        }
        return library;
    }
}

