/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.fetchcontact;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class ContactDecoder {
    private String name;
    private String phone;
    private String email;

    public ContactDecoder(String rawContactString) {
        if (rawContactString != null && !"".equals(rawContactString)) {
            try {
                String decoded = URLDecoder.decode(rawContactString, "UTF-8");
                String[] tokens = decoded.split("&");
                for (int i = 0; i < tokens.length; ++i) {
                    String key = tokens[i].substring(0, tokens[i].indexOf("="));
                    String val = tokens[i].substring(tokens[i].indexOf("=") + 1);
                    if ("name".equals(key)) {
                        this.name = val;
                        continue;
                    }
                    if ("phone".equals(key)) {
                        this.phone = val;
                        continue;
                    }
                    if (!"email".equals(key)) continue;
                    this.email = val;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getEmail() {
        return this.email;
    }
}

