/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.fetchcontact;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.icefaces.impl.application.AuxUploadResourceHandler;
import org.icefaces.mobi.component.fetchcontact.ContactDecoder;
import org.icefaces.mobi.component.fetchcontact.FetchContact;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.util.MobiJSFUtils;
import org.icefaces.util.ClientDescriptor;

public class FetchContactRenderer
extends Renderer {
    private static final Logger log = Logger.getLogger(FetchContactRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        FetchContact contactList = (FetchContact)uiComponent;
        String clientId = contactList.getClientId();
        try {
            Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
            String contactListResult = (String)requestParameterMap.get(clientId);
            if (null == contactListResult) {
                Map auxMap = AuxUploadResourceHandler.getAuxRequestMap();
                contactListResult = (String)auxMap.get(clientId);
            }
            if (null != contactListResult) {
                contactList.setValue(contactListResult);
                ContactDecoder modelHelper = new ContactDecoder(contactListResult);
                contactList.setName(modelHelper.getName());
                contactList.setEmail(modelHelper.getEmail());
                contactList.setPhone(modelHelper.getPhone());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error decoding fetchContacts request paramaters.", e);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String styleClass;
        String style;
        FetchContact contactList = (FetchContact)uiComponent;
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        String clientId = contactList.getClientId();
        writer.startElement("span", contactList);
        writer.writeAttribute("id", clientId);
        StringBuilder baseClass = new StringBuilder("mobi-button ui-btn-up-c");
        ClientDescriptor cd = contactList.getClient();
        writer.startElement("button", contactList);
        writer.writeAttribute("id", clientId + "_button");
        writer.writeAttribute("name", clientId + "_button");
        writer.writeAttribute("type", "button");
        writer.writeAttribute("tabindex", contactList.getTabindex());
        String script = "bridgeit.fetchContact('" + clientId + "', '', {postURL:'" + contactList.getPostURL() + "', " + "cookies:{'JSESSIONID':'" + MobiJSFUtils.getSessionIdCookie(facesContext) + "'}, " + "fields: '" + contactList.getFields() + "'});";
        writer.writeAttribute("onclick", script);
        boolean disabled = contactList.isDisabled();
        if (disabled) {
            writer.writeAttribute("disabled", "disabled");
        }
        if ((style = contactList.getStyle()) != null) {
            writer.writeAttribute("style", style);
        }
        if ((styleClass = contactList.getStyleClass()) != null) {
            writer.writeAttribute("class", styleClass);
        }
        writer.startElement("span", contactList);
        writer.writeText(contactList.getButtonLabel());
        writer.endElement("span");
        writer.startElement("span", contactList);
        writer.startElement("script", contactList);
        writer.writeAttribute("type", "text/javascript");
        writer.writeText("new ice.mobi.button('" + clientId + "_button');");
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("button");
        writer.endElement("span");
    }
}

