/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.icefaces.mobi.renderkit.CoreRenderer;

public class InputRenderer
extends CoreRenderer {
    public static final String LABEL_STYLE_CLASS = "ui-input-label";
    public static final String IN_FIELD_LABEL_STYLE_CLASS = "ui-input-label-infield";
    public static final Set<String> labelPositionSet = new HashSet<String>(Arrays.asList("left", "right", "top", "bottom", "inField", "none"));
    public static final Set<String> indicatorPositionSet = new HashSet<String>(Arrays.asList("left", "right", "top", "bottom", "labelLeft", "labelRight", "none"));

    protected List<SelectItem> getSelectItems(FacesContext context, UIInput component) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UISelectItem) {
                UISelectItem uiSelectItem = (UISelectItem)child;
                selectItems.add(new SelectItem(uiSelectItem.getItemValue(), uiSelectItem.getItemLabel()));
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            UISelectItems uiSelectItems = (UISelectItems)child;
            Object value = uiSelectItems.getValue();
            if (value instanceof SelectItem[]) {
                selectItems.addAll(Arrays.asList((SelectItem[])value));
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                for (Object key : map.keySet()) {
                    selectItems.add(new SelectItem(map.get(key), String.valueOf(key)));
                }
                continue;
            }
            if (!(value instanceof Collection)) continue;
            Collection collection = (Collection)value;
            String var = (String)uiSelectItems.getAttributes().get("var");
            if (var != null) {
                for (Object object : collection) {
                    context.getExternalContext().getRequestMap().put(var, object);
                    String itemLabel = (String)uiSelectItems.getAttributes().get("itemLabel");
                    Object itemValue = uiSelectItems.getAttributes().get("itemValue");
                    selectItems.add(new SelectItem(itemValue, itemLabel));
                }
                continue;
            }
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                selectItems.add((SelectItem)it.next());
            }
        }
        return selectItems;
    }

    protected String getOptionAsString(FacesContext context, UIInput component, Converter converter, Object value) {
        if (converter != null) {
            return converter.getAsString(context, (UIComponent)component, value);
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    protected Converter getConverter(FacesContext context, UIInput component) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression ve = component.getValueExpression("value");
        if (ve != null) {
            Class valueType = ve.getType(context.getELContext());
            return context.getApplication().createConverter(valueType);
        }
        return null;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        UIInput uiInput = (UIInput)component;
        String value = (String)submittedValue;
        Converter converter = uiInput.getConverter();
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)uiInput, value);
        }
        ValueExpression ve = uiInput.getValueExpression("value");
        if (ve != null) {
            Class valueType = ve.getType(context.getELContext());
            Converter converterForType = context.getApplication().createConverter(valueType);
            if (converterForType != null) {
                return converterForType.getAsObject(context, (UIComponent)uiInput, value);
            }
        }
        return value;
    }

    protected void encodeLabelAndInput(UIComponent component, Map<String, Object> labelAttributes, Map<String, Object> domUpdateMap) throws IOException {
        this.writeLabelAndIndicatorBefore(labelAttributes);
        this.writeInputField(component, labelAttributes, domUpdateMap);
        this.writeLabelAndIndicatorAfter(labelAttributes);
    }

    protected void writeInputField(UIComponent component, Map<String, Object> labelAttributes, Map<String, Object> domUpdateMap) throws IOException {
    }

    private void writeHiddenLabel(ResponseWriter writer, String label) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-input-label hidden", null);
        writer.write(label);
        writer.endElement("span");
    }

    private void writeLabel(Map<String, Object> attributes) throws IOException {
        ResponseWriter writer = FacesContext.getCurrentInstance().getResponseWriter();
        boolean required = (Boolean)attributes.get("required");
        boolean hasIndicator = (Boolean)attributes.get("hasIndicator");
        String clientId = (String)attributes.get("clientId");
        String label = (String)attributes.get("label");
        String labelPosition = (String)attributes.get("labelPosition");
        String indicator = (String)attributes.get("indicator");
        String indicatorPosition = (String)attributes.get("indicatorPosition");
        if (hasIndicator) {
            if (indicatorPosition.equals("labelLeft") || indicatorPosition.equals("labelRight")) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)("ui-input-label ui-input-label-" + labelPosition), null);
            }
            if (indicatorPosition.equals("labelLeft")) {
                this.writeIndicator(writer, required, indicator, indicatorPosition);
            }
        }
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)("label_" + clientId), null);
        if (!hasIndicator || !indicatorPosition.equals("labelLeft") && !indicatorPosition.equals("labelRight")) {
            writer.writeAttribute("class", (Object)("ui-input-label ui-input-label-" + labelPosition), null);
        }
        writer.write(label);
        writer.endElement("span");
        if (hasIndicator) {
            if (indicatorPosition.equals("labelRight")) {
                this.writeIndicator(writer, required, indicator, indicatorPosition);
            }
            if (indicatorPosition.equals("labelLeft") || indicatorPosition.equals("labelRight")) {
                writer.endElement("span");
            }
        }
    }

    private void writeIndicator(ResponseWriter writer, boolean required, String indicator, String indicatorPosition) throws IOException {
        String class1 = "ui-" + (required ? "required" : "optional") + "-indicator";
        String class2 = indicatorPosition.equals("labelLeft") ? class1 + "-label-left" : (indicatorPosition.equals("labelRight") ? class1 + "-label-right" : class1 + "-" + indicatorPosition);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)(class1 + " " + class2), null);
        writer.write(indicator);
        writer.endElement("span");
    }

    protected String getStateStyleClasses(UIInput component) {
        String styleClases = "";
        styleClases = component.isRequired() ? styleClases + " ui-state-required" : styleClases + " ui-state-optional";
        if (!component.isValid()) {
            styleClases = styleClases + " ui-state-error";
        }
        return styleClases;
    }

    protected Map<String, Object> getLabelAttributes(final UIComponent component) {
        return new HashMap<String, Object>(){
            {
                boolean required = (Boolean)component.getAttributes().get("required");
                String label = (String)component.getAttributes().get("label");
                String labelPosition = (String)component.getAttributes().get("labelPosition");
                if (!labelPositionSet.contains(labelPosition)) {
                    labelPosition = "none";
                }
                boolean hasLabel = !InputRenderer.this.isValueBlank(label) && !labelPosition.equals("none");
                String indicator = (String)(required ? component.getAttributes().get("requiredIndicator") : component.getAttributes().get("optionalIndicator"));
                String indicatorPosition = (String)component.getAttributes().get("indicatorPosition");
                if (!indicatorPositionSet.contains(indicatorPosition)) {
                    indicatorPosition = labelPosition.equals("inField") ? "labelRight" : "right";
                }
                boolean hasIndicator = !InputRenderer.this.isValueBlank(indicator) && !indicatorPosition.equals("none");
                String inFieldLabel = null;
                if (hasLabel && labelPosition.equals("inField")) {
                    inFieldLabel = label;
                    if (hasIndicator) {
                        if (indicatorPosition.equals("labelLeft")) {
                            inFieldLabel = indicator + inFieldLabel;
                        } else if (indicatorPosition.equals("labelRight")) {
                            inFieldLabel = inFieldLabel + indicator;
                        }
                    }
                }
                this.put("clientId", component.getClientId());
                this.put("required", required);
                this.put("label", label);
                this.put("labelPosition", labelPosition);
                this.put("hasLabel", hasLabel);
                this.put("indicator", indicator);
                this.put("indicatorPosition", indicatorPosition);
                this.put("hasIndicator", hasIndicator);
                this.put("inFieldLabel", inFieldLabel);
                this.put("labelIsInField", false);
            }
        };
    }

    protected void writeLabelAndIndicatorBefore(Map<String, Object> attributes) throws IOException {
        ResponseWriter writer = FacesContext.getCurrentInstance().getResponseWriter();
        boolean required = (Boolean)attributes.get("required");
        boolean hasLabel = (Boolean)attributes.get("hasLabel");
        boolean hasIndicator = (Boolean)attributes.get("hasIndicator");
        String label = (String)attributes.get("label");
        String labelPosition = (String)attributes.get("labelPosition");
        String indicator = (String)attributes.get("indicator");
        String indicatorPosition = (String)attributes.get("indicatorPosition");
        if (hasLabel && labelPosition.equals("top")) {
            this.writeLabel(attributes);
            writer.startElement("br", null);
            writer.endElement("br");
        }
        if (hasIndicator && indicatorPosition.equals("top")) {
            if (hasLabel && labelPosition.equals("left")) {
                this.writeHiddenLabel(writer, label);
            }
            this.writeIndicator(writer, required, indicator, indicatorPosition);
            writer.startElement("br", null);
            writer.endElement("br");
        }
        if (hasLabel) {
            if (labelPosition.equals("left")) {
                this.writeLabel(attributes);
            }
            if (labelPosition.equals("top")) {
                // empty if block
            }
        }
        if (hasIndicator) {
            if (indicatorPosition.equals("top") || indicatorPosition.equals("bottom")) {
                // empty if block
            }
            if (indicatorPosition.equals("left")) {
                this.writeIndicator(writer, required, indicator, indicatorPosition);
            }
            if (indicatorPosition.equals("top")) {
                // empty if block
            }
        }
    }

    protected void writeLabelAndIndicatorAfter(Map<String, Object> attributes) throws IOException {
        ResponseWriter writer = FacesContext.getCurrentInstance().getResponseWriter();
        boolean required = (Boolean)attributes.get("required");
        boolean hasLabel = (Boolean)attributes.get("hasLabel");
        boolean hasIndicator = (Boolean)attributes.get("hasIndicator");
        String label = (String)attributes.get("label");
        String labelPosition = (String)attributes.get("labelPosition");
        String indicator = (String)attributes.get("indicator");
        String indicatorPosition = (String)attributes.get("indicatorPosition");
        if (hasIndicator && indicatorPosition.equals("right")) {
            this.writeIndicator(writer, required, indicator, indicatorPosition);
        }
        if (hasLabel && labelPosition.equals("right")) {
            this.writeLabel(attributes);
        }
        if (hasIndicator) {
            if (indicatorPosition.equals("bottom")) {
                writer.startElement("br", null);
                writer.endElement("br");
            }
            if (indicatorPosition.equals("bottom")) {
                if (hasLabel && labelPosition.equals("left")) {
                    this.writeHiddenLabel(writer, label);
                }
                this.writeIndicator(writer, required, indicator, indicatorPosition);
            }
            if (indicatorPosition.equals("top") || indicatorPosition.equals("bottom")) {
                // empty if block
            }
        }
        if (hasLabel) {
            if (labelPosition.equals("bottom")) {
                writer.startElement("br", null);
                writer.endElement("br");
            }
            if (labelPosition.equals("bottom")) {
                this.writeLabel(attributes);
            }
        }
    }

    protected void writeAriaAttributes(Map<String, Object> ariaAttributes, Map<String, Object> labelAttributes) throws IOException {
        ResponseWriter writer = FacesContext.getCurrentInstance().getResponseWriter();
        String autocomplete = (String)ariaAttributes.get("autocomplete");
        Boolean multiline = (Boolean)ariaAttributes.get("multiline");
        Boolean readonly = (Boolean)ariaAttributes.get("readonly");
        Boolean required = (Boolean)labelAttributes.get("required");
        Boolean disabled = (Boolean)ariaAttributes.get("disabled");
        Boolean invalid = (Boolean)ariaAttributes.get("invalid");
        String clientId = (String)labelAttributes.get("clientId");
        String label = (String)labelAttributes.get("label");
        String labelPosition = (String)labelAttributes.get("labelPosition");
        boolean hasLabel = (Boolean)labelAttributes.get("hasLabel");
        if (autocomplete != null && !autocomplete.equals("none")) {
            writer.writeAttribute("aria-autocomplete", (Object)autocomplete, null);
        }
        if (multiline != null && multiline.booleanValue()) {
            writer.writeAttribute("aria-multiline", (Object)true, null);
        }
        if (readonly != null && readonly.booleanValue()) {
            writer.writeAttribute("aria-readonly", (Object)true, "readonly");
        }
        if (required != null && required.booleanValue()) {
            writer.writeAttribute("aria-required", (Object)true, "required");
        }
        if (disabled != null && disabled.booleanValue()) {
            writer.writeAttribute("aria-disabled", (Object)true, "disabled");
        }
        if (invalid != null && invalid.booleanValue()) {
            writer.writeAttribute("aria-invalid", (Object)true, "valid");
        }
        if (hasLabel) {
            if (labelPosition.equals("inField")) {
                writer.writeAttribute("aria-label", (Object)label, "label");
            } else {
                writer.writeAttribute("aria-labelledby", (Object)("label_" + clientId), null);
            }
        }
    }
}

