/*
 * Copyright 2004-2014 ICEsoft Technologies Canada Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.icefaces.mobi.component.fetchcontact;

import org.icefaces.mobi.util.MobiJSFUtils;
import org.icefaces.util.ClientDescriptor;
import org.icefaces.mobi.api.IContactList;

public class FetchContact extends FetchContactBase implements IContactList{


    public ClientDescriptor getClient() {
        return MobiJSFUtils.getClientDescriptor();
    }

    public String getScript(String id, boolean isSX)  {
       return MobiJSFUtils.getICEmobileSXScript(
                "fetchContacts", null, this);
    }

    public String getPostURL()  {
       return MobiJSFUtils.getPostURL();
    }

    public String getSessionId()  {
       return MobiJSFUtils.getSessionIdCookie();
    }

}
