/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.camcorder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import org.icefaces.mobi.component.camcorder.Camcorder;
import org.icefaces.mobi.renderkit.BaseInputResourceRenderer;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.util.MobiJSFUtils;

public class CamcorderRenderer
extends BaseInputResourceRenderer {
    private static final Logger logger = Logger.getLogger(CamcorderRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Camcorder camcorder = (Camcorder)uiComponent;
        String clientId = camcorder.getClientId();
        if (!camcorder.isDisabled()) {
            try {
                HashMap map = new HashMap();
                boolean isValid = this.extractVideo(facesContext, map, clientId);
                if (isValid && map != null) {
                    camcorder.setValue(map);
                    uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, null, map));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean extractVideo(FacesContext facesContext, Map map, String clientId) throws IOException {
        return MobiJSFUtils.decodeComponentFile(facesContext, clientId, map);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String styleClass;
        String style;
        Camcorder camcorder = (Camcorder)uiComponent;
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        String clientId = camcorder.getClientId();
        UIComponent fallbackFacet = camcorder.getFacet("fallback");
        writer.startElement("span", camcorder);
        writer.writeAttribute("id", clientId);
        writer.writeAttribute("class", "mobi-camcorder");
        String oldLabel = camcorder.getButtonLabel();
        if (MobiJSFUtils.uploadInProgress((UIComponent)camcorder)) {
            camcorder.setButtonLabel(camcorder.getCaptureMessageLabel());
        }
        writer.startElement("button", camcorder);
        writer.writeAttribute("id", clientId + "_button");
        writer.writeAttribute("name", clientId + "_button");
        writer.writeAttribute("type", "button");
        if (camcorder.isDisabled()) {
            writer.writeAttribute("disabled", "disabled");
        }
        if ((style = camcorder.getStyle()) != null) {
            writer.writeAttribute("style", style);
        }
        if ((styleClass = camcorder.getStyleClass()) != null) {
            writer.writeAttribute("class", styleClass);
        }
        writer.writeAttribute("tabindex", camcorder.getTabindex());
        String launchFailed = fallbackFacet != null ? "ice.mobi.fallback.setupLaunchFailed('" + clientId + "_button','" + clientId + "_fallback');" : "";
        String script = launchFailed + "bridgeit.camcorder('" + clientId + "', 'callback" + clientId + "', {postURL:'" + camcorder.getPostURL() + "', ";
        script = script + "cookies:{'JSESSIONID':'" + MobiJSFUtils.getSessionIdCookie(facesContext) + "'}";
        script = script + "});";
        writer.writeAttribute("onclick", script);
        writer.startElement("span", camcorder);
        writer.writeText(camcorder.getButtonLabel());
        writer.endElement("span");
        writer.startElement("span", camcorder);
        writer.startElement("script", camcorder);
        writer.writeAttribute("type", "text/javascript");
        writer.writeText(MobiJSFUtils.getCameraOrCamcorderButtonAndThumbnailScript(clientId));
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("button");
        if (fallbackFacet != null) {
            writer.startElement("span", camcorder);
            writer.writeAttribute("id", clientId + "_fallback");
            writer.writeAttribute("style", "display:none;");
            if (fallbackFacet.isRendered()) {
                fallbackFacet.encodeAll(facesContext);
            }
            writer.endElement("span");
        }
        writer.startElement("script", camcorder);
        writer.writeAttribute("type", "text/javascript");
        writer.writeText("if (!bridgeit.isSupportedPlatform('camcorder') && document.getElementById('" + clientId + "_fallback')) {");
        writer.writeText("document.getElementById('" + clientId + "_button').style.display='none';");
        writer.writeText("document.getElementById('" + clientId + "_fallback').style.display='inline';");
        writer.writeText("}");
        writer.endElement("script");
        writer.endElement("span");
        camcorder.setButtonLabel(oldLabel);
    }
}

