/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.camera;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.render.Renderer;
import org.icefaces.ace.util.IceOutputResource;
import org.icefaces.application.ResourceRegistry;
import org.icefaces.mobi.component.camera.Camera;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.util.MobiJSFUtils;
import org.icefaces.util.ClientDescriptor;

public class CameraRenderer
extends Renderer {
    private static final Logger logger = Logger.getLogger(CameraRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Camera camera = (Camera)uiComponent;
        String clientId = camera.getClientId();
        try {
            HashMap map;
            boolean valid;
            if (!camera.isDisabled() && (valid = this.extractImages(facesContext, map = new HashMap(), clientId)) && map != null) {
                camera.setValue(map);
                uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, null, map));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean extractImages(FacesContext facesContext, Map map, String clientId) throws IOException {
        return MobiJSFUtils.decodeComponentFile(facesContext, clientId, map);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String styleClass;
        String style;
        boolean isImageButton;
        Camera camera = (Camera)uiComponent;
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        String clientId = camera.getClientId();
        writer.startElement("span", camera);
        writer.writeAttribute("id", clientId);
        writer.writeAttribute("class", "mobi-camera");
        String oldLabel = camera.getButtonLabel();
        Object oldImage = camera.getButtonImage();
        boolean bl = isImageButton = oldImage != null;
        if (MobiJSFUtils.uploadInProgress((UIComponent)camera)) {
            Object newImage;
            camera.setButtonLabel(camera.getCaptureMessageLabel());
            if (oldImage != null && (newImage = camera.getCaptureButtonImage()) != null) {
                camera.setButtonImage(newImage);
            }
        }
        ClientDescriptor cd = camera.getClient();
        writer.startElement("button", camera);
        writer.writeAttribute("id", clientId + "_button");
        writer.writeAttribute("name", clientId + "_button");
        writer.writeAttribute("type", "button");
        if (camera.isDisabled()) {
            writer.writeAttribute("disabled", "disabled");
        }
        if ((style = camera.getStyle()) != null) {
            writer.writeAttribute("style", style);
        }
        if ((styleClass = camera.getStyleClass()) != null) {
            writer.writeAttribute("class", styleClass);
        }
        writer.writeAttribute("tabindex", camera.getTabindex());
        String script = "ice.mobi.cameraBtnOnclick('%s', '%s', '%s', '%s', '%s', %s, %s, '%s', '%s');";
        writer.writeAttribute("onclick", String.format(script, clientId, camera.getButtonLabel(), camera.getCaptureMessageLabel(), camera.getPostURL(), MobiJSFUtils.getSessionIdCookie(facesContext), camera.getMaxwidth() > 0 ? Integer.valueOf(camera.getMaxwidth()) : "undefined", camera.getMaxheight() > 0 ? Integer.valueOf(camera.getMaxheight()) : "undefined", this.processImageSource(facesContext, camera.getButtonImage(), clientId + "_buttonImage"), this.processImageSource(facesContext, camera.getCaptureButtonImage(), clientId + "_captureButtonImage")));
        writer.startElement("span", camera);
        if (isImageButton) {
            writer.startElement("img", camera);
            writer.writeAttribute("src", this.processImageSource(facesContext, camera.getButtonImage(), clientId + "_buttonImage"));
            writer.endElement("img");
        } else {
            writer.writeText(camera.getButtonLabel());
        }
        writer.endElement("span");
        writer.startElement("span", camera);
        writer.startElement("script", camera);
        writer.writeAttribute("type", "text/javascript");
        if (isImageButton) {
            writer.writeText(MobiJSFUtils.getCameraOrCamcorderButtonAndThumbnailScriptImageButton(clientId));
        } else {
            writer.writeText(MobiJSFUtils.getCameraOrCamcorderButtonAndThumbnailScript(clientId));
        }
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("button");
        writer.endElement("span");
        camera.setButtonLabel(oldLabel);
        camera.setButtonImage(oldImage);
    }

    public String processImageSource(FacesContext facesContext, Object o, String name) {
        if (o instanceof IceOutputResource) {
            IceOutputResource iceResource = (IceOutputResource)o;
            return ResourceRegistry.addWindowResource((Resource)iceResource);
        }
        if (o instanceof byte[]) {
            IceOutputResource iceResource = new IceOutputResource(name, o, "");
            return ResourceRegistry.addWindowResource((Resource)iceResource);
        }
        if (o != null) {
            return facesContext.getApplication().getViewHandler().getResourceURL(facesContext, (String)o);
        }
        return "";
    }
}

